/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Iterator;
import java.util.TreeMap;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.JabRefPreferences;

public abstract class BibtexEntryType
implements Comparable {
    public static final BibtexEntryType OTHER = new BibtexEntryType(){

        public String getName() {
            return "Other";
        }

        public String[] getOptionalFields() {
            return new String[0];
        }

        public String[] getRequiredFields() {
            return new String[0];
        }

        public String describeRequiredFields() {
            return "";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return true;
        }
    };
    public static final BibtexEntryType ARTICLE = new BibtexEntryType(){

        public String getName() {
            return "Article";
        }

        public String[] getOptionalFields() {
            return new String[]{"number", "month", "eid", "note"};
        }

        public String[] getRequiredFields() {
            return new String[]{"author", "title", "journal", "year", "volume", "pages"};
        }

        public String describeRequiredFields() {
            return "AUTHOR, TITLE, JOURNAL and YEAR";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return bibtexEntry.allFieldsPresent(new String[]{"author", "title", "journal", "year", "bibtexkey", "volume", "pages"});
        }
    };
    public static final BibtexEntryType BOOKLET = new BibtexEntryType(){

        public String getName() {
            return "Booklet";
        }

        public String[] getOptionalFields() {
            return new String[]{"author", "howpublished", "lastchecked", "address", "month", "year", "note"};
        }

        public String[] getRequiredFields() {
            return new String[]{"title"};
        }

        public String describeRequiredFields() {
            return "TITLE";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return bibtexEntry.allFieldsPresent(new String[]{"title", "bibtexkey"});
        }
    };
    public static final BibtexEntryType INBOOK = new BibtexEntryType(){

        public String getName() {
            return "Inbook";
        }

        public String[] getOptionalFields() {
            return new String[]{"volume", "number", "pages", "series", "type", "address", "edition", "month", "note"};
        }

        public String[] getRequiredFields() {
            return new String[]{"chapter", "pages", "title", "publisher", "year", "editor", "author"};
        }

        public String describeRequiredFields() {
            return "TITLE, CHAPTER and/or PAGES, PUBLISHER, YEAR, and an EDITOR and/or AUTHOR";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return !(!bibtexEntry.allFieldsPresent(new String[]{"title", "publisher", "year", "bibtexkey"}) || bibtexEntry.getField("author") == null && bibtexEntry.getField("editor") == null || bibtexEntry.getField("chapter") == null && bibtexEntry.getField("pages") == null);
        }
    };
    public static final BibtexEntryType BOOK = new BibtexEntryType(){

        public String getName() {
            return "Book";
        }

        public String[] getOptionalFields() {
            return new String[]{"volume", "number", "pages", "series", "address", "edition", "month", "note"};
        }

        public String[] getRequiredFields() {
            return new String[]{"title", "publisher", "year", "editor", "author"};
        }

        public String describeRequiredFields() {
            return "TITLE, PUBLISHER, YEAR, and an EDITOR and/or AUTHOR";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return bibtexEntry.allFieldsPresent(new String[]{"title", "publisher", "year", "bibtexkey"}) && (bibtexEntry.getField("author") != null || bibtexEntry.getField("editor") != null);
        }
    };
    public static final BibtexEntryType INCOLLECTION = new BibtexEntryType(){

        public String getName() {
            return "Incollection";
        }

        public String[] getOptionalFields() {
            return new String[]{"editor", "volume", "number", "series", "type", "chapter", "pages", "address", "edition", "month", "note"};
        }

        public String[] getRequiredFields() {
            return new String[]{"author", "title", "booktitle", "publisher", "year"};
        }

        public String describeRequiredFields() {
            return "AUTHOR, TITLE, BOOKTITLE, PUBLISHER and YEAR";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return bibtexEntry.allFieldsPresent(new String[]{"author", "title", "booktitle", "publisher", "year", "bibtexkey"});
        }
    };
    public static final BibtexEntryType CONFERENCE = new BibtexEntryType(){

        public String getName() {
            return "Conference";
        }

        public String[] getOptionalFields() {
            return new String[]{"editor", "volume", "number", "series", "pages", "address", "month", "organization", "publisher", "note"};
        }

        public String[] getRequiredFields() {
            return new String[]{"author", "title", "booktitle", "year"};
        }

        public String describeRequiredFields() {
            return "AUTHOR, TITLE, BOOKTITLE and YEAR";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return bibtexEntry.allFieldsPresent(new String[]{"author", "title", "booktitle", "year", "bibtexkey"});
        }
    };
    public static final BibtexEntryType INPROCEEDINGS = new BibtexEntryType(){

        public String getName() {
            return "Inproceedings";
        }

        public String[] getOptionalFields() {
            return new String[]{"editor", "volume", "number", "series", "pages", "address", "month", "organization", "publisher", "note"};
        }

        public String[] getRequiredFields() {
            return new String[]{"author", "title", "booktitle", "year"};
        }

        public String describeRequiredFields() {
            return "AUTHOR, TITLE, BOOKTITLE and YEAR";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return bibtexEntry.allFieldsPresent(new String[]{"author", "title", "booktitle", "year", "bibtexkey"});
        }
    };
    public static final BibtexEntryType PROCEEDINGS = new BibtexEntryType(){

        public String getName() {
            return "Proceedings";
        }

        public String[] getOptionalFields() {
            return new String[]{"editor", "volume", "number", "series", "address", "publisher", "note", "month", "organization"};
        }

        public String[] getRequiredFields() {
            return new String[]{"title", "year"};
        }

        public String describeRequiredFields() {
            return "TITLE and YEAR";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return bibtexEntry.allFieldsPresent(new String[]{"title", "year", "bibtexkey"});
        }
    };
    public static final BibtexEntryType MANUAL = new BibtexEntryType(){

        public String getName() {
            return "Manual";
        }

        public String[] getOptionalFields() {
            return new String[]{"author", "organization", "address", "edition", "month", "year", "note"};
        }

        public String[] getRequiredFields() {
            return new String[]{"title"};
        }

        public String describeRequiredFields() {
            return "TITLE";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return bibtexEntry.allFieldsPresent(new String[]{"title", "bibtexkey"});
        }
    };
    public static final BibtexEntryType TECHREPORT = new BibtexEntryType(){

        public String getName() {
            return "Techreport";
        }

        public String[] getOptionalFields() {
            return new String[]{"type", "number", "address", "month", "note"};
        }

        public String[] getRequiredFields() {
            return new String[]{"author", "title", "institution", "year"};
        }

        public String describeRequiredFields() {
            return "AUTHOR, TITLE, INSTITUTION and YEAR";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return bibtexEntry.allFieldsPresent(new String[]{"author", "title", "institution", "year", "bibtexkey"});
        }
    };
    public static final BibtexEntryType MASTERSTHESIS = new BibtexEntryType(){

        public String getName() {
            return "Mastersthesis";
        }

        public String[] getOptionalFields() {
            return new String[]{"type", "address", "month", "note"};
        }

        public String[] getRequiredFields() {
            return new String[]{"author", "title", "school", "year"};
        }

        public String describeRequiredFields() {
            return "AUTHOR, TITLE, SCHOOL and YEAR";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return bibtexEntry.allFieldsPresent(new String[]{"author", "title", "school", "year", "bibtexkey"});
        }
    };
    public static final BibtexEntryType PHDTHESIS = new BibtexEntryType(){

        public String getName() {
            return "Phdthesis";
        }

        public String[] getOptionalFields() {
            return new String[]{"type", "address", "month", "note"};
        }

        public String[] getRequiredFields() {
            return new String[]{"author", "title", "school", "year"};
        }

        public String describeRequiredFields() {
            return "AUTHOR, TITLE, SCHOOL and YEAR";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return bibtexEntry.allFieldsPresent(new String[]{"author", "title", "school", "year", "bibtexkey"});
        }
    };
    public static final BibtexEntryType UNPUBLISHED = new BibtexEntryType(){

        public String getName() {
            return "Unpublished";
        }

        public String[] getOptionalFields() {
            return new String[]{"month", "year"};
        }

        public String[] getRequiredFields() {
            return new String[]{"author", "title", "note"};
        }

        public String describeRequiredFields() {
            return "AUTHOR, TITLE and NOTE";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return bibtexEntry.allFieldsPresent(new String[]{"author", "title", "note", "bibtexkey"});
        }
    };
    public static final BibtexEntryType MISC = new BibtexEntryType(){

        public String getName() {
            return "Misc";
        }

        public String[] getOptionalFields() {
            return new String[]{"author", "title", "howpublished", "month", "year", "note"};
        }

        public String[] getRequiredFields() {
            return null;
        }

        public String describeRequiredFields() {
            return "None";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return bibtexEntry.allFieldsPresent(new String[]{"bibtexkey"});
        }
    };
    public static final BibtexEntryType TYPELESS = new BibtexEntryType(){

        public String getName() {
            return "Typeless";
        }

        public String[] getOptionalFields() {
            return null;
        }

        public String[] getRequiredFields() {
            return null;
        }

        public String describeRequiredFields() {
            return "None";
        }

        public boolean hasAllRequiredFields(BibtexEntry bibtexEntry) {
            return false;
        }
    };
    public static TreeMap ALL_TYPES = new TreeMap();
    public static TreeMap STANDARD_TYPES = new TreeMap();

    public abstract String getName();

    public int compareTo(Object object) {
        return this.getName().compareTo(((BibtexEntryType)object).getName());
    }

    public abstract String[] getOptionalFields();

    public abstract String[] getRequiredFields();

    public String[] getGeneralFields() {
        return new String[]{"crossref", "keywords", "doi", "url", "citeseerurl", "pdf", "abstract", "comment"};
    }

    public abstract String describeRequiredFields();

    public abstract boolean hasAllRequiredFields(BibtexEntry var1);

    public String[] getUtilityFields() {
        return new String[]{"search"};
    }

    public boolean isRequired(String string) {
        String[] stringArray = this.getRequiredFields();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isOptional(String string) {
        String[] stringArray = this.getOptionalFields();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static BibtexEntryType getType(String string) {
        Object v = ALL_TYPES.get(string.toLowerCase());
        if (v == null) {
            return null;
        }
        return (BibtexEntryType)v;
    }

    public static BibtexEntryType getStandardType(String string) {
        Object v = STANDARD_TYPES.get(string.toLowerCase());
        if (v == null) {
            return null;
        }
        return (BibtexEntryType)v;
    }

    public static void removeType(String string) {
        String string2 = string.toLowerCase();
        ALL_TYPES.remove(string2);
        if (STANDARD_TYPES.get(string2) != null) {
            ALL_TYPES.put(string2, STANDARD_TYPES.get(string2));
        }
    }

    public static void loadCustomEntryTypes(JabRefPreferences jabRefPreferences) {
        CustomEntryType customEntryType;
        int n = 0;
        while ((customEntryType = jabRefPreferences.getCustomEntryType(n)) != null) {
            ALL_TYPES.put(customEntryType.getName().toLowerCase(), customEntryType);
            ++n;
        }
    }

    public static void saveCustomEntryTypes(JabRefPreferences jabRefPreferences) {
        Iterator iterator = ALL_TYPES.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object v = ALL_TYPES.get(iterator.next());
            if (!(v instanceof CustomEntryType)) continue;
            jabRefPreferences.storeCustomEntryType((CustomEntryType)v, n);
            ++n;
        }
        jabRefPreferences.purgeCustomEntryTypes(n);
    }

    static {
        ALL_TYPES.put("article", ARTICLE);
        ALL_TYPES.put("inbook", INBOOK);
        ALL_TYPES.put("book", BOOK);
        ALL_TYPES.put("booklet", BOOKLET);
        ALL_TYPES.put("incollection", INCOLLECTION);
        ALL_TYPES.put("conference", CONFERENCE);
        ALL_TYPES.put("inproceedings", INPROCEEDINGS);
        ALL_TYPES.put("proceedings", PROCEEDINGS);
        ALL_TYPES.put("manual", MANUAL);
        ALL_TYPES.put("mastersthesis", MASTERSTHESIS);
        ALL_TYPES.put("phdthesis", PHDTHESIS);
        ALL_TYPES.put("techreport", TECHREPORT);
        ALL_TYPES.put("unpublished", UNPUBLISHED);
        ALL_TYPES.put("misc", MISC);
        ALL_TYPES.put("other", OTHER);
        STANDARD_TYPES = (TreeMap)ALL_TYPES.clone();
    }
}

