/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionModificationException;

public class ShortOption
extends Option {
    private short value;

    public ShortOption() {
        this(0);
    }

    public ShortOption(ShortOption shortOption) {
        super(shortOption);
        shortOption.value = shortOption.getValue();
    }

    public ShortOption(short s) {
        this(s, null);
    }

    public ShortOption(short s, String string) {
        this(s, string, '\u0000');
    }

    public ShortOption(short s, char c) {
        this(s, null, c);
    }

    public ShortOption(short s, String string, char c) {
        super(string, c);
        this.value = s;
    }

    public Object getObject() {
        return new Short(this.value);
    }

    public void modify(String string) throws OptionModificationException {
        try {
            this.value = Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OptionModificationException("Error. A short must be specified, not '" + string + "'.");
        }
    }

    public void setValue(String string) throws OptionModificationException {
        this.modify(string);
    }

    public void setValue(short s) {
        this.value = s;
    }

    public short getValue() {
        return this.value;
    }

    public String getStringValue() {
        return Short.toString(this.value);
    }

    public String getTypeName() {
        return "SHORT";
    }

    public String toString() {
        return this.getStringValue();
    }
}

