/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionProcessingException;
import gnu.dtools.ritopt.OptionRegistrar;
import gnu.dtools.ritopt.OptionRegistrationException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class OptionModule
implements OptionRegistrar {
    private HashMap options = new HashMap();
    private String name;
    private boolean deprecated;
    public static final char DEFAULT_SHORT_OPTION = '\u0000';
    public static final String DEFAULT_LONG_OPTION = null;
    public static final String DEFAULT_DESCRIPTION = "No description given";
    public static final boolean DEFAULT_DEPRECATED = false;
    public static final String DEFAULT_MODULE_NAME = "Special";

    public OptionModule() {
        this(DEFAULT_MODULE_NAME);
    }

    public OptionModule(String string) {
        this.name = string;
        this.deprecated = false;
    }

    public void register(String string, Option option) {
        this.register(string, '\u0000', option);
    }

    public void register(char c, Option option) {
        this.register(DEFAULT_LONG_OPTION, c, option);
    }

    public void register(String string, char c, Option option) {
        this.register(string, c, DEFAULT_DESCRIPTION, option);
    }

    public void register(String string, char c, String string2, Option option) {
        this.register(string, c, string2, option, false);
    }

    public void register(String string, char c, String string2, Option option, boolean bl) {
        if (this.optionExists(option)) {
            throw new OptionRegistrationException("Option Already Registered", option);
        }
        option.setLongOption(string);
        option.setShortOption(c);
        option.setDeprecated(bl);
        option.setDescription(string2);
        this.options.put(option.getHashKey(), option);
    }

    public boolean optionExists(Option option) {
        return this.optionExists(option.getShortOption()) || this.optionExists(option.getLongOption());
    }

    public boolean optionExists(char c) {
        Collection collection = this.options.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            char c2 = option.getShortOption();
            if (c2 == '\u0000' || c2 != c) continue;
            return true;
        }
        return false;
    }

    public boolean optionExists(String string) {
        Collection collection = this.options.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            String string2 = option.getLongOption();
            if (string2 == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public Iterator getOptionIterator() {
        return this.options.values().iterator();
    }

    public Option getOption(char c) {
        Option option = null;
        Collection collection = this.options.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Option option2 = (Option)iterator.next();
            char c2 = option2.getShortOption();
            if (c2 == '\u0000' || c2 != c) continue;
            option = option2;
        }
        return option;
    }

    public Option getOption(String string) {
        Option option = null;
        Collection collection = this.options.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Option option2 = (Option)iterator.next();
            String string2 = option2.getLongOption();
            if (string2 == null || !string2.equals(string)) continue;
            option = option2;
        }
        return option;
    }

    public String getHelp() {
        String string = "";
        Collection collection = this.options.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            string = string + option.getHelp() + "\n";
        }
        return string;
    }

    public void writeFileToPrintStream(PrintStream printStream) {
        Collection collection = this.options.values();
        Iterator iterator = collection.iterator();
        printStream.println(":" + this.name + ":");
        while (iterator.hasNext()) {
            Option option = (Option)iterator.next();
            printStream.println(option.getOptionFileLine());
        }
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean bl) {
        this.deprecated = bl;
    }

    public void action(char c, char c2) {
        this.action(c, "" + c2);
    }

    public void action(String string, char c) {
        this.action(string, "" + c);
    }

    public void action(char c, String string) {
        Option option = this.getOption(c);
        if (option == null) {
            throw new OptionProcessingException("Option -" + c + " does not" + " exist in module '" + this.name + "'.");
        }
        option.setInvoked(true);
        option.action();
        option.modify(string);
    }

    public void action(String string, String string2) {
        Option option = this.getOption(string);
        if (option == null) {
            throw new OptionProcessingException("Option --" + string + " does not" + " exist in module '" + this.name + "'.");
        }
        option.setInvoked(true);
        option.action();
        option.modify(string2);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }
}

