/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.OptionEvent;
import gnu.dtools.ritopt.OptionListener;
import gnu.dtools.ritopt.Options;
import gnu.dtools.ritopt.SimpleProcess;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class OptionMenu
implements OptionListener {
    public static final String OPTION_COMMAND_CHAR = "-";
    public static final String HELP_COMMAND_CHAR = "?";
    public static final String RUN_COMMAND_CHAR = "=";
    public static final String SHELL_COMMAND_CHAR = "!";
    public static final String EXIT_MENU_COMMAND_CHAR = "$";
    public static final String LIST_MODULES_COMMAND_CHAR = "+";
    public static final String FILE_READ_COMMAND_CHAR = "@";
    public static final String FILE_WRITE_COMMAND_CHAR = "%";
    public static final String FILE_MODULE_COMMAND_CHAR = ":";
    public static final String MENU_PROMPT = "-> ";
    private Options options;
    private BufferedReader reader;

    public OptionMenu(Options options) {
        this.options = options;
        this.reader = new BufferedReader(new InputStreamReader(System.in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMenu() {
        String string = "";
        while (!string.equals(EXIT_MENU_COMMAND_CHAR)) {
            boolean bl;
            System.out.print(MENU_PROMPT);
            try {
                string = this.reader.readLine();
            }
            catch (IOException iOException) {
                return;
            }
            boolean bl2 = bl = string != null && string.length() > 0;
            if (string.equals(HELP_COMMAND_CHAR)) {
                System.err.println("\t- Options Delimiter");
                System.err.println("\t? Help");
                System.err.println("\t= Run program and return to menu");
                System.err.println("\t! Shell to Operating System");
                System.err.println("\t$ Exit menu");
                System.err.println("\t+ Additional options");
                System.err.println("\t@<filename> Get options from file [" + this.options.getDefaultOptionFilename() + "]");
                System.err.println("\t@@ Get options from file [" + this.options.getDefaultOptionFilename() + "]");
                System.err.println("\t%<filename> Put options in file");
                System.err.println("\t%% Put options in file [" + this.options.getDefaultOptionFilename() + "]");
                System.err.println("\t. Quit");
                continue;
            }
            if (bl && (string.substring(0, 1).equals(FILE_READ_COMMAND_CHAR) || string.substring(0, 1).equals(FILE_WRITE_COMMAND_CHAR) || string.substring(0, 1).equals(OPTION_COMMAND_CHAR) || string.substring(0, 1).equals(FILE_MODULE_COMMAND_CHAR))) {
                this.options.process(string);
                continue;
            }
            if (bl && string.substring(0, 1).equals(SHELL_COMMAND_CHAR)) continue;
            if (bl && string.substring(0, 1).equals(RUN_COMMAND_CHAR)) {
                try {
                    SimpleProcess simpleProcess = new SimpleProcess(Runtime.getRuntime().exec(string.substring(1)));
                    System.err.println("Exit status: " + simpleProcess.waitFor());
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("ritopt: An Error Occurred During Process Execution");
                    exception.printStackTrace();
                    continue;
                }
                finally {
                    System.out.println("Press enter to continue...");
                    try {
                        this.reader.readLine();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            System.err.println("(Type ? for Help)");
        }
    }

    public void optionInvoked(OptionEvent optionEvent) {
        if (optionEvent.getCommand().equals("menu")) {
            this.startMenu();
        }
    }
}

