/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionModificationException;

public class FloatOption
extends Option {
    private float value;

    public FloatOption() {
        this(0.0f);
    }

    public FloatOption(FloatOption floatOption) {
        super(floatOption);
        floatOption.value = floatOption.getValue();
    }

    public FloatOption(float f) {
        this(f, null);
    }

    public FloatOption(float f, String string) {
        this(f, string, '\u0000');
    }

    public FloatOption(float f, char c) {
        this(f, null, c);
    }

    public FloatOption(float f, String string, char c) {
        super(string, c);
        this.value = f;
    }

    public Object getObject() {
        return new Float(this.value);
    }

    public void modify(String string) throws OptionModificationException {
        try {
            this.value = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OptionModificationException("Error. A float must be specified, not '" + string + "'.");
        }
    }

    public void setValue(String string) throws OptionModificationException {
        this.modify(string);
    }

    public void setValue(float f) {
        this.value = f;
    }

    public float getValue() {
        return this.value;
    }

    public String getStringValue() {
        return Float.toString(this.value);
    }

    public String getTypeName() {
        return "FLOAT";
    }

    public String toString() {
        return this.getStringValue();
    }
}

