/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionModificationException;

public class ByteOption
extends Option {
    private byte value;

    public ByteOption() {
        this(0);
    }

    public ByteOption(ByteOption byteOption) {
        super(byteOption);
        byteOption.value = byteOption.getValue();
    }

    public ByteOption(byte by) {
        this(by, null);
    }

    public ByteOption(byte by, String string) {
        this(by, string, '\u0000');
    }

    public ByteOption(byte by, char c) {
        this(by, null, c);
    }

    public ByteOption(byte by, String string, char c) {
        super(string, c);
        this.value = by;
    }

    public Object getObject() {
        return new Byte(this.value);
    }

    public void modify(String string) throws OptionModificationException {
        try {
            this.value = Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OptionModificationException("Error. A byte must be specified, not '" + string + "'.");
        }
    }

    public void setValue(String string) throws OptionModificationException {
        this.modify(string);
    }

    public void setValue(byte by) {
        this.value = by;
    }

    public byte getValue() {
        return this.value;
    }

    public String getStringValue() {
        return Byte.toString(this.value);
    }

    public String getTypeName() {
        return "BYTE";
    }

    public String toString() {
        return this.getStringValue();
    }
}

