/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif_lite.panel;

import com.jgoodies.looks.LookUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public class SimpleInternalFrame
extends JPanel {
    private JLabel titleLabel;
    private GradientPanel gradientPanel;
    private JPanel headerPanel;
    private boolean isSelected = false;

    public SimpleInternalFrame(String string) {
        this(null, string, null, null);
    }

    public SimpleInternalFrame(Icon icon, String string) {
        this(icon, string, null, null);
    }

    public SimpleInternalFrame(String string, JToolBar jToolBar, JComponent jComponent) {
        this(null, string, jToolBar, jComponent);
    }

    public SimpleInternalFrame(Icon icon, String string, JToolBar jToolBar, JComponent jComponent) {
        super(new BorderLayout());
        this.titleLabel = new JLabel(string, icon, 10);
        JPanel jPanel = this.buildHeader(this.titleLabel, jToolBar);
        this.add((Component)jPanel, "North");
        if (jComponent != null) {
            this.setContent(jComponent);
        }
        this.setBorder(new ShadowBorder());
        this.setSelected(true);
        this.updateHeader();
    }

    public Icon getFrameIcon() {
        return this.titleLabel.getIcon();
    }

    public void setFrameIcon(Icon icon) {
        Icon icon2 = this.getFrameIcon();
        this.titleLabel.setIcon(icon);
        this.firePropertyChange("frameIcon", icon2, icon);
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setTitle(String string) {
        String string2 = this.getTitle();
        this.titleLabel.setText(string);
        this.firePropertyChange("title", string2, string);
    }

    public JToolBar getToolBar() {
        return this.headerPanel.getComponentCount() > 1 ? (JToolBar)this.headerPanel.getComponent(1) : null;
    }

    public void setToolBar(JToolBar jToolBar) {
        JToolBar jToolBar2 = this.getToolBar();
        if (jToolBar2 == jToolBar) {
            return;
        }
        if (jToolBar2 != null) {
            this.headerPanel.remove(jToolBar2);
        }
        if (jToolBar != null) {
            jToolBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.headerPanel.add((Component)jToolBar, "East");
        }
        this.updateHeader();
        this.firePropertyChange("toolBar", jToolBar2, jToolBar);
    }

    public Component getContent() {
        return this.hasContent() ? this.getComponent(1) : null;
    }

    public void setContent(Component component) {
        Component component2 = this.getContent();
        if (this.hasContent()) {
            this.remove(component2);
        }
        this.add(component, "Center");
        this.firePropertyChange("content", component2, component);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean bl) {
        boolean bl2 = this.isSelected();
        this.isSelected = bl;
        this.updateHeader();
        this.firePropertyChange("selected", bl2, bl);
    }

    private JPanel buildHeader(JLabel jLabel, JToolBar jToolBar) {
        this.gradientPanel = new GradientPanel(new BorderLayout(), this.getHeaderBackground());
        jLabel.setOpaque(false);
        this.gradientPanel.add((Component)jLabel, "West");
        this.gradientPanel.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 1));
        this.headerPanel = new JPanel(new BorderLayout());
        this.headerPanel.add((Component)this.gradientPanel, "Center");
        this.setToolBar(jToolBar);
        this.headerPanel.setBorder(new RaisedHeaderBorder());
        this.headerPanel.setOpaque(false);
        return this.headerPanel;
    }

    private void updateHeader() {
        this.gradientPanel.setBackground(this.getHeaderBackground());
        this.gradientPanel.setOpaque(this.isSelected());
        this.titleLabel.setForeground(this.getTextForeground(this.isSelected()));
        this.headerPanel.repaint();
    }

    public void updateUI() {
        super.updateUI();
        if (this.titleLabel != null) {
            this.updateHeader();
        }
    }

    private boolean hasContent() {
        return this.getComponentCount() > 1;
    }

    protected Color getTextForeground(boolean bl) {
        Color color = UIManager.getColor(bl ? "SimpleInternalFrame.activeTitleForeground" : "SimpleInternalFrame.inactiveTitleForeground");
        if (color != null) {
            return color;
        }
        return UIManager.getColor(bl ? "InternalFrame.activeTitleForeground" : "Label.foreground");
    }

    protected Color getHeaderBackground() {
        Color color = UIManager.getColor("SimpleInternalFrame.activeTitleBackground");
        if (color != null) {
            return color;
        }
        if (LookUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            color = UIManager.getColor("InternalFrame.activeTitleGradient");
        }
        return color != null ? color : UIManager.getColor("InternalFrame.activeTitleBackground");
    }

    private static class GradientPanel
    extends JPanel {
        private GradientPanel(LayoutManager layoutManager, Color color) {
            super(layoutManager);
            this.setBackground(color);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (!this.isOpaque()) {
                return;
            }
            Color color = UIManager.getColor("control");
            int n = this.getWidth();
            int n2 = this.getHeight();
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), n, 0.0f, color));
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setPaint(paint);
        }
    }

    private static class ShadowBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 3, 3);

        private ShadowBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = UIManager.getColor("controlShadow");
            if (color == null) {
                color = Color.GRAY;
            }
            Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 170);
            Color color3 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 70);
            graphics.translate(n, n2);
            graphics.setColor(color);
            graphics.fillRect(0, 0, n3 - 3, 1);
            graphics.fillRect(0, 0, 1, n4 - 3);
            graphics.fillRect(n3 - 3, 1, 1, n4 - 3);
            graphics.fillRect(1, n4 - 3, n3 - 3, 1);
            graphics.setColor(color2);
            graphics.fillRect(n3 - 3, 0, 1, 1);
            graphics.fillRect(0, n4 - 3, 1, 1);
            graphics.fillRect(n3 - 2, 1, 1, n4 - 3);
            graphics.fillRect(1, n4 - 2, n3 - 3, 1);
            graphics.setColor(color3);
            graphics.fillRect(n3 - 2, 0, 1, 1);
            graphics.fillRect(0, n4 - 2, 1, 1);
            graphics.fillRect(n3 - 2, n4 - 2, 1, 1);
            graphics.fillRect(n3 - 1, 1, 1, n4 - 2);
            graphics.fillRect(1, n4 - 1, n3 - 2, 1);
            graphics.translate(-n, -n2);
        }
    }

    private static class RaisedHeaderBorder
    extends AbstractBorder {
        private static final Insets INSETS = new Insets(1, 1, 1, 0);

        private RaisedHeaderBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return INSETS;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            graphics.setColor(UIManager.getColor("controlLtHighlight"));
            graphics.fillRect(0, 0, n3, 1);
            graphics.fillRect(0, 1, 1, n4 - 1);
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.fillRect(0, n4 - 1, n3, 1);
            graphics.translate(-n, -n2);
        }
    }
}

