/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.impl.filter.TextMatcher;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;

public class TextMatcherEditor
extends AbstractMatcherEditor {
    public static final int CONTAINS = 0;
    public static final int STARTS_WITH = 1;
    private static final String[] EMPTY_FILTER = new String[0];
    private final TextFilterator filterator;
    private int mode = 0;

    public TextMatcherEditor() {
        this(null);
    }

    public TextMatcherEditor(TextFilterator filterator) {
        this.filterator = filterator;
    }

    public TextFilterator getFilterator() {
        return this.filterator;
    }

    public void setMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Mode must be either TextMatcherEditor.CONTAINS or TextMatcherEditor.STARTS_WITH");
        }
        if (mode == this.mode) {
            return;
        }
        this.mode = mode;
        if (this.getCurrentFilter().length == 0) {
            return;
        }
        if (mode == 1) {
            this.fireConstrained(new TextMatcher(this.getCurrentFilter(), this.filterator, mode));
        } else {
            this.fireRelaxed(new TextMatcher(this.getCurrentFilter(), this.filterator, mode));
        }
    }

    public int getMode() {
        return this.mode;
    }

    private String[] getCurrentFilter() {
        if (this.currentMatcher instanceof TextMatcher) {
            return ((TextMatcher)this.currentMatcher).getFilters();
        }
        return EMPTY_FILTER;
    }

    public void setFilterText(String[] newFilters) {
        String[] oldFilters = this.getCurrentFilter();
        if (TextMatcher.isFilterEqual(oldFilters, newFilters = TextMatcher.normalizeFilters(newFilters))) {
            return;
        }
        if (newFilters.length == 0) {
            this.fireMatchAll();
            return;
        }
        TextMatcher matcher = new TextMatcher(newFilters, this.filterator, this.mode);
        if (TextMatcher.isFilterRelaxed(oldFilters, newFilters)) {
            this.fireRelaxed(matcher);
        } else if (TextMatcher.isFilterConstrained(oldFilters, newFilters)) {
            this.fireConstrained(matcher);
        } else {
            this.fireChanged(matcher);
        }
    }
}

