/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompositeMatcherEditor
extends AbstractMatcherEditor {
    public static final int AND = 42;
    public static final int OR = 24;
    private EventList matcherEditors;
    private int mode = 42;
    private List matcherEditorListeners = new ArrayList();

    public CompositeMatcherEditor(EventList matcherEditors) {
        this.matcherEditors = matcherEditors;
        Iterator i = matcherEditors.iterator();
        while (i.hasNext()) {
            MatcherEditor matcherEditor = (MatcherEditor)i.next();
            this.matcherEditorListeners.add(new DelegateMatcherEditorListener(matcherEditor));
        }
        matcherEditors.addListEventListener(new MatcherEditorsListListener());
        this.fireChanged(this.rebuildMatcher());
    }

    public CompositeMatcherEditor() {
        this(new BasicEventList());
    }

    public EventList getMatcherEditors() {
        return this.matcherEditors;
    }

    private Matcher rebuildMatcher() {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        Iterator i = this.matcherEditors.iterator();
        while (i.hasNext()) {
            MatcherEditor matcherEditor = (MatcherEditor)i.next();
            matchers.add(matcherEditor.getMatcher());
        }
        if (this.mode == 42) {
            return new AndMatcher(matchers);
        }
        if (this.mode == 24) {
            return new OrMatcher(matchers);
        }
        throw new IllegalStateException();
    }

    public void setMode(int mode) {
        if (this.mode == mode) {
            return;
        }
        int oldMode = this.mode;
        this.mode = mode;
        if (this.matcherEditors.isEmpty()) {
            return;
        }
        if (oldMode == 42 && mode == 24) {
            this.fireRelaxed(this.rebuildMatcher());
        } else if (oldMode == 24 && mode == 42) {
            this.fireConstrained(this.rebuildMatcher());
        } else {
            throw new IllegalArgumentException();
        }
    }

    public int getMode() {
        return this.mode;
    }

    private class OrMatcher
    implements Matcher {
        private List matchers = new ArrayList();

        public OrMatcher(List matchers) {
            this.matchers.addAll(matchers);
        }

        public boolean matches(Object item) {
            Iterator i = this.matchers.iterator();
            while (i.hasNext()) {
                if (!((Matcher)i.next()).matches(item)) continue;
                return true;
            }
            return false;
        }
    }

    private class AndMatcher
    implements Matcher {
        private List matchers = new ArrayList();

        public AndMatcher(List matchers) {
            this.matchers.addAll(matchers);
        }

        public boolean matches(Object item) {
            Iterator i = this.matchers.iterator();
            while (i.hasNext()) {
                if (((Matcher)i.next()).matches(item)) continue;
                return false;
            }
            return true;
        }
    }

    private class DelegateMatcherEditorListener
    implements MatcherEditor.Listener {
        private MatcherEditor source;

        public void changedMatcher(MatcherEditor.Event matcherEvent) {
            switch (matcherEvent.getType()) {
                case 2: {
                    this.constrained();
                    break;
                }
                case 3: {
                    this.relaxed();
                    break;
                }
                case 4: {
                    this.changed();
                    break;
                }
                case 0: {
                    this.matchAll();
                    break;
                }
                case 1: {
                    this.matchNone();
                }
            }
        }

        private DelegateMatcherEditorListener(MatcherEditor source) {
            this.source = source;
            source.addMatcherEditorListener(this);
        }

        private void matchAll() {
            if (CompositeMatcherEditor.this.matcherEditors.size() == 1) {
                CompositeMatcherEditor.this.fireMatchAll();
            } else {
                CompositeMatcherEditor.this.fireRelaxed(CompositeMatcherEditor.this.rebuildMatcher());
            }
        }

        private void matchNone() {
            if (CompositeMatcherEditor.this.matcherEditors.size() == 1) {
                CompositeMatcherEditor.this.fireMatchNone();
            } else {
                CompositeMatcherEditor.this.fireConstrained(CompositeMatcherEditor.this.rebuildMatcher());
            }
        }

        private void changed() {
            CompositeMatcherEditor.this.fireChanged(CompositeMatcherEditor.this.rebuildMatcher());
        }

        private void constrained() {
            CompositeMatcherEditor.this.fireConstrained(CompositeMatcherEditor.this.rebuildMatcher());
        }

        private void relaxed() {
            CompositeMatcherEditor.this.fireRelaxed(CompositeMatcherEditor.this.rebuildMatcher());
        }

        public void setMatcherEditor(MatcherEditor source) {
            if (this.source == source) {
                return;
            }
            this.stopListening();
            this.source = source;
            source.addMatcherEditorListener(this);
        }

        public void stopListening() {
            this.source.removeMatcherEditorListener(this);
        }
    }

    private class MatcherEditorsListListener
    implements ListEventListener {
        private MatcherEditorsListListener() {
        }

        public void listChanged(ListEvent listChanges) {
            boolean inserts = false;
            boolean deletes = false;
            boolean wasEmpty = CompositeMatcherEditor.this.matcherEditorListeners.isEmpty();
            while (listChanges.next()) {
                int index = listChanges.getIndex();
                int type = listChanges.getType();
                if (type == 2) {
                    MatcherEditor inserted = (MatcherEditor)CompositeMatcherEditor.this.matcherEditors.get(index);
                    CompositeMatcherEditor.this.matcherEditorListeners.add(new DelegateMatcherEditorListener(inserted));
                    inserts = true;
                    continue;
                }
                if (type == 0) {
                    DelegateMatcherEditorListener listener = (DelegateMatcherEditorListener)CompositeMatcherEditor.this.matcherEditorListeners.remove(index);
                    listener.stopListening();
                    deletes = true;
                    continue;
                }
                if (type != 1) continue;
                MatcherEditor updated = (MatcherEditor)CompositeMatcherEditor.this.matcherEditors.get(index);
                DelegateMatcherEditorListener listener = (DelegateMatcherEditorListener)CompositeMatcherEditor.this.matcherEditorListeners.get(index);
                listener.setMatcherEditor(updated);
                inserts = true;
                deletes = true;
            }
            boolean isEmpty = CompositeMatcherEditor.this.matcherEditorListeners.isEmpty();
            if (CompositeMatcherEditor.this.mode == 42) {
                if (inserts && deletes) {
                    CompositeMatcherEditor.this.fireChanged(CompositeMatcherEditor.this.rebuildMatcher());
                } else if (inserts) {
                    CompositeMatcherEditor.this.fireConstrained(CompositeMatcherEditor.this.rebuildMatcher());
                } else if (deletes) {
                    if (isEmpty) {
                        CompositeMatcherEditor.this.fireMatchAll();
                    } else {
                        CompositeMatcherEditor.this.fireRelaxed(CompositeMatcherEditor.this.rebuildMatcher());
                    }
                }
            } else if (CompositeMatcherEditor.this.mode == 24) {
                if (inserts && deletes) {
                    CompositeMatcherEditor.this.fireChanged(CompositeMatcherEditor.this.rebuildMatcher());
                } else if (inserts) {
                    if (wasEmpty) {
                        CompositeMatcherEditor.this.fireConstrained(CompositeMatcherEditor.this.rebuildMatcher());
                    } else {
                        CompositeMatcherEditor.this.fireRelaxed(CompositeMatcherEditor.this.rebuildMatcher());
                    }
                } else if (deletes) {
                    if (isEmpty) {
                        CompositeMatcherEditor.this.fireMatchAll();
                    } else {
                        CompositeMatcherEditor.this.fireConstrained(CompositeMatcherEditor.this.rebuildMatcher());
                    }
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }
}

