/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.event;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.BlockSequence;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventAssembler;
import ca.odell.glazedlists.event.Tree4Deltas;
import java.util.List;

class Tree4DeltasListEvent
extends ListEvent {
    private Tree4Deltas.Iterator deltasIterator;
    private BlockSequence.Iterator linearIterator;
    private ListEventAssembler.Tree4DeltasAssembler deltasAssembler;

    public Tree4DeltasListEvent(ListEventAssembler.Tree4DeltasAssembler deltasAssembler, EventList sourceList) {
        super(sourceList);
        this.deltasAssembler = deltasAssembler;
    }

    public ListEvent copy() {
        Tree4DeltasListEvent result = new Tree4DeltasListEvent(this.deltasAssembler, this.sourceList);
        result.deltasIterator = this.deltasIterator != null ? this.deltasIterator.copy() : null;
        result.linearIterator = this.linearIterator != null ? this.linearIterator.copy() : null;
        result.deltasAssembler = this.deltasAssembler;
        return result;
    }

    public void reset() {
        if (this.deltasAssembler.getUseListBlocksLinear()) {
            this.linearIterator = this.deltasAssembler.getListBlocksLinear().iterator();
            this.deltasIterator = null;
        } else {
            this.deltasIterator = this.deltasAssembler.getListDeltas().iterator();
            this.linearIterator = null;
        }
    }

    public boolean next() {
        if (this.linearIterator != null) {
            return this.linearIterator.next();
        }
        return this.deltasIterator.next();
    }

    public boolean hasNext() {
        if (this.linearIterator != null) {
            return this.linearIterator.hasNext();
        }
        return this.deltasIterator.hasNext();
    }

    public boolean nextBlock() {
        if (this.linearIterator != null) {
            return this.linearIterator.nextBlock();
        }
        return this.deltasIterator.nextNode();
    }

    public boolean isReordering() {
        return this.deltasAssembler.getReorderMap() != null;
    }

    public int[] getReorderMap() {
        int[] reorderMap = this.deltasAssembler.getReorderMap();
        if (reorderMap == null) {
            throw new IllegalStateException("Cannot get reorder map for a non-reordering change");
        }
        return reorderMap;
    }

    public int getIndex() {
        if (this.linearIterator != null) {
            return this.linearIterator.getIndex();
        }
        return this.deltasIterator.getIndex();
    }

    public int getBlockStartIndex() {
        if (this.linearIterator != null) {
            return this.linearIterator.getBlockStart();
        }
        return this.deltasIterator.getIndex();
    }

    public int getBlockEndIndex() {
        if (this.linearIterator != null) {
            return this.linearIterator.getBlockEnd() - 1;
        }
        return this.deltasIterator.getEndIndex() - 1;
    }

    public int getType() {
        if (this.linearIterator != null) {
            return this.linearIterator.getType();
        }
        return this.deltasIterator.getType();
    }

    List getBlocks() {
        throw new UnsupportedOperationException();
    }

    public int getBlocksRemaining() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this.linearIterator != null) {
            return "ListEvent: " + this.deltasAssembler.getListBlocksLinear().toString();
        }
        return "ListEvent: " + this.deltasAssembler.getListDeltas().toString();
    }
}

