/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.event;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.Block;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventAssembler;
import java.util.List;

final class BlockDeltasListEvent
extends ListEvent {
    private int blockCount;
    private Block currentBlock = null;
    private int rowIndex;
    private ListEventAssembler.BlockDeltasAssembler blocksAssembler;

    BlockDeltasListEvent(ListEventAssembler.BlockDeltasAssembler blocksAssembler, EventList sourceList) {
        super(sourceList);
        this.blocksAssembler = blocksAssembler;
        this.blockCount = 0;
    }

    public BlockDeltasListEvent(BlockDeltasListEvent original) {
        super(original.sourceList);
        this.blocksAssembler = original.blocksAssembler;
        this.blockCount = original.blockCount;
        this.currentBlock = original.currentBlock;
        this.rowIndex = original.rowIndex;
        this.sourceList = original.sourceList;
    }

    public ListEvent copy() {
        return new BlockDeltasListEvent(this);
    }

    public void reset() {
        this.currentBlock = null;
        this.blockCount = 0;
    }

    public boolean next() {
        if (this.currentBlock == null || this.rowIndex == this.getBlockEndIndex()) {
            return this.nextBlock();
        }
        if (this.rowIndex >= this.getBlockEndIndex()) {
            throw new IllegalStateException();
        }
        ++this.rowIndex;
        return true;
    }

    public boolean hasNext() {
        if (this.currentBlock == null || this.rowIndex == this.getBlockEndIndex()) {
            return this.blockCount < this.getBlocks().size();
        }
        return true;
    }

    public boolean nextBlock() {
        if (this.blockCount == this.getBlocks().size()) {
            this.currentBlock = null;
            this.rowIndex = -5;
            this.blockCount = 0;
            return false;
        }
        this.currentBlock = (Block)this.getBlocks().get(this.blockCount);
        ++this.blockCount;
        this.rowIndex = this.getBlockStartIndex();
        return true;
    }

    public boolean isReordering() {
        return this.blocksAssembler.getReorderMap() != null;
    }

    public int[] getReorderMap() {
        int[] reorderMap = this.blocksAssembler.getReorderMap();
        if (reorderMap == null) {
            throw new IllegalStateException("Cannot get reorder map for a non-reordering change");
        }
        return reorderMap;
    }

    public int getIndex() {
        return this.getType() == 0 ? this.getBlockStartIndex() : this.rowIndex;
    }

    public int getBlockStartIndex() {
        if (this.currentBlock == null) {
            throw new IllegalStateException();
        }
        return this.currentBlock.getStartIndex();
    }

    public int getBlockEndIndex() {
        if (this.currentBlock == null) {
            throw new IllegalStateException();
        }
        return this.currentBlock.getEndIndex();
    }

    public int getType() {
        if (this.currentBlock == null) {
            throw new IllegalStateException();
        }
        return this.currentBlock.getType();
    }

    List getBlocks() {
        return this.blocksAssembler.getBlocks();
    }

    public int getBlocksRemaining() {
        if (this.currentBlock != null && this.rowIndex < this.getBlockEndIndex()) {
            return this.getBlocks().size() - this.blockCount + 1;
        }
        return this.getBlocks().size() - this.blockCount;
    }

    public String toString() {
        return "ListEvent: " + this.blocksAssembler.getBlocks();
    }
}

