/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.Grouper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class UniqueList
extends TransformedList {
    private final Grouper grouper;

    public UniqueList(EventList source) {
        this(source, GlazedLists.comparableComparator());
    }

    public UniqueList(EventList source, Comparator comparator) {
        this(new SortedList(source, comparator), comparator, null);
    }

    private UniqueList(SortedList source, Comparator comparator, Void dummyParameter) {
        super(source);
        GrouperClient grouperClient = new GrouperClient();
        this.grouper = new Grouper(source, grouperClient);
        source.addListEventListener(this);
    }

    public int size() {
        return this.grouper.getBarcode().colourSize(Grouper.UNIQUE);
    }

    protected int getSourceIndex(int index) {
        if (index == this.size()) {
            return this.source.size();
        }
        return this.grouper.getBarcode().getIndex(index, Grouper.UNIQUE);
    }

    private int getEndIndex(int index) {
        if (index == this.size() - 1) {
            return this.source.size();
        }
        return this.getSourceIndex(index + 1);
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot remove at " + index + " on list of size " + this.size());
        }
        this.updates.beginEvent(true);
        Object result = this.get(index);
        int startIndex = this.getSourceIndex(index);
        int endIndex = this.getEndIndex(index);
        ((SortedList)this.source).subList(startIndex, endIndex).clear();
        this.updates.commitEvent();
        return result;
    }

    public Object set(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot set at " + index + " on list of size " + this.size());
        }
        this.updates.beginEvent(true);
        int startIndex = this.getSourceIndex(index) + 1;
        int endIndex = this.getEndIndex(index);
        if (endIndex > startIndex) {
            ((SortedList)this.source).subList(startIndex, endIndex).clear();
        }
        Object result = super.set(index, value);
        this.updates.commitEvent();
        return result;
    }

    public int indexOf(Object element) {
        int index = Collections.binarySearch(this, element, ((SortedList)this.source).getComparator());
        return index < 0 ? -1 : index;
    }

    protected boolean isWritable() {
        return true;
    }

    public void listChanged(ListEvent listChanges) {
        this.updates.beginEvent(true);
        this.grouper.listChanged(listChanges);
        this.updates.commitEvent();
    }

    public int getCount(int index) {
        int startIndex = this.getSourceIndex(index);
        int endIndex = this.getEndIndex(index);
        return endIndex - startIndex;
    }

    public int getCount(Object value) {
        int index = this.indexOf(value);
        if (index == -1) {
            return 0;
        }
        return this.getCount(index);
    }

    public List getAll(int index) {
        int startIndex = this.getSourceIndex(index);
        int endIndex = this.getEndIndex(index);
        return new ArrayList(this.source.subList(startIndex, endIndex));
    }

    public List getAll(Object value) {
        int index = this.indexOf(value);
        return index == -1 ? Collections.EMPTY_LIST : this.getAll(index);
    }

    public void dispose() {
        ((SortedList)this.source).dispose();
        super.dispose();
    }

    private class GrouperClient
    implements Grouper.Client {
        private GrouperClient() {
        }

        public void groupChanged(int index, int groupIndex, int groupChangeType, boolean primary, int elementChangeType) {
            if (groupChangeType == 2) {
                UniqueList.this.updates.addInsert(groupIndex);
            } else if (groupChangeType == 0) {
                UniqueList.this.updates.addDelete(groupIndex);
            } else if (groupChangeType == 1) {
                UniqueList.this.updates.addUpdate(groupIndex);
            } else {
                throw new IllegalStateException();
            }
        }
    }
}

