/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.adt.BarcodeIterator;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.matchers.Matchers;

public final class FilterList
extends TransformedList {
    private Barcode flagList = new Barcode();
    private Matcher currentMatcher = Matchers.trueMatcher();
    private MatcherEditor currentEditor = null;
    private final MatcherEditor.Listener listener = new PrivateMatcherEditorListener();

    public FilterList(EventList source) {
        super(source);
        this.flagList.addBlack(0, source.size());
        source.addListEventListener(this);
    }

    public FilterList(EventList source, Matcher matcher) {
        this(source);
        if (matcher == null) {
            return;
        }
        this.currentMatcher = matcher;
        this.changed();
    }

    public FilterList(EventList source, MatcherEditor matcherEditor) {
        this(source);
        if (matcherEditor == null) {
            return;
        }
        this.currentEditor = matcherEditor;
        this.currentEditor.addMatcherEditorListener(this.listener);
        this.currentMatcher = this.currentEditor.getMatcher();
        this.changed();
    }

    public void setMatcher(Matcher matcher) {
        if (this.currentEditor != null) {
            this.currentEditor.removeMatcherEditorListener(this.listener);
            this.currentEditor = null;
        }
        if (matcher != null) {
            this.changeMatcherWithLocks(this.currentEditor, matcher, 4);
        } else {
            this.changeMatcherWithLocks(this.currentEditor, null, 0);
        }
    }

    public void setMatcherEditor(MatcherEditor editor) {
        if (this.currentEditor != null) {
            this.currentEditor.removeMatcherEditorListener(this.listener);
        }
        this.currentEditor = editor;
        if (this.currentEditor != null) {
            this.currentEditor.addMatcherEditorListener(this.listener);
            this.changeMatcherWithLocks(this.currentEditor, this.currentEditor.getMatcher(), 4);
        } else {
            this.changeMatcherWithLocks(this.currentEditor, null, 0);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.currentEditor != null) {
            this.currentEditor.removeMatcherEditorListener(this.listener);
            this.currentEditor = null;
        }
        this.currentMatcher = null;
    }

    public final void listChanged(ListEvent listChanges) {
        this.updates.beginEvent();
        if (listChanges.isReordering()) {
            int[] sourceReorderMap = listChanges.getReorderMap();
            int[] filterReorderMap = new int[this.flagList.blackSize()];
            Barcode previousFlagList = this.flagList;
            this.flagList = new Barcode();
            for (int i = 0; i < sourceReorderMap.length; ++i) {
                Object flag = previousFlagList.get(sourceReorderMap[i]);
                this.flagList.add(i, flag, 1);
                if (flag == Barcode.WHITE) continue;
                filterReorderMap[this.flagList.getBlackIndex((int)i)] = previousFlagList.getBlackIndex(sourceReorderMap[i]);
            }
            this.updates.reorder(filterReorderMap);
        } else {
            while (listChanges.next()) {
                int filteredIndex;
                int sourceIndex = listChanges.getIndex();
                int changeType = listChanges.getType();
                if (changeType == 0) {
                    filteredIndex = this.flagList.getBlackIndex(sourceIndex);
                    if (filteredIndex != -1) {
                        this.updates.addDelete(filteredIndex);
                    }
                    this.flagList.remove(sourceIndex, 1);
                    continue;
                }
                if (changeType == 2) {
                    boolean include = this.currentMatcher.matches(this.source.get(sourceIndex));
                    if (include) {
                        this.flagList.addBlack(sourceIndex, 1);
                        int filteredIndex2 = this.flagList.getBlackIndex(sourceIndex);
                        this.updates.addInsert(filteredIndex2);
                        continue;
                    }
                    this.flagList.addWhite(sourceIndex, 1);
                    continue;
                }
                if (changeType != 1) continue;
                filteredIndex = this.flagList.getBlackIndex(sourceIndex);
                boolean wasIncluded = filteredIndex != -1;
                boolean include = this.currentMatcher.matches(this.source.get(sourceIndex));
                if (wasIncluded && !include) {
                    this.flagList.setWhite(sourceIndex, 1);
                    this.updates.addDelete(filteredIndex);
                    continue;
                }
                if (!wasIncluded && include) {
                    this.flagList.setBlack(sourceIndex, 1);
                    this.updates.addInsert(this.flagList.getBlackIndex(sourceIndex));
                    continue;
                }
                if (!wasIncluded || !include) continue;
                this.updates.addUpdate(filteredIndex);
            }
        }
        this.updates.commitEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeMatcherWithLocks(MatcherEditor matcherEditor, Matcher matcher, int changeType) {
        this.getReadWriteLock().writeLock().lock();
        try {
            this.changeMatcher(matcherEditor, matcher, changeType);
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    private void changeMatcher(MatcherEditor matcherEditor, Matcher matcher, int changeType) {
        if (this.currentEditor != matcherEditor) {
            throw new IllegalStateException();
        }
        switch (changeType) {
            case 2: {
                this.currentMatcher = matcher;
                this.constrained();
                break;
            }
            case 3: {
                this.currentMatcher = matcher;
                this.relaxed();
                break;
            }
            case 4: {
                this.currentMatcher = matcher;
                this.changed();
                break;
            }
            case 0: {
                this.currentMatcher = Matchers.trueMatcher();
                this.matchAll();
                break;
            }
            case 1: {
                this.currentMatcher = Matchers.falseMatcher();
                this.matchNone();
            }
        }
    }

    private void matchNone() {
        this.updates.beginEvent();
        if (this.size() > 0) {
            this.updates.addDelete(0, this.size() - 1);
        }
        this.flagList.clear();
        this.flagList.addWhite(0, this.source.size());
        this.updates.commitEvent();
    }

    private void matchAll() {
        this.updates.beginEvent();
        BarcodeIterator i = this.flagList.iterator();
        while (i.hasNextWhite()) {
            i.nextWhite();
            this.updates.addInsert(i.getIndex());
        }
        this.flagList.clear();
        this.flagList.addBlack(0, this.source.size());
        this.updates.commitEvent();
    }

    private void relaxed() {
        this.updates.beginEvent();
        BarcodeIterator i = this.flagList.iterator();
        while (i.hasNextWhite()) {
            i.nextWhite();
            if (!this.currentMatcher.matches(this.source.get(i.getIndex()))) continue;
            this.updates.addInsert(i.setBlack());
        }
        this.updates.commitEvent();
    }

    private void constrained() {
        this.updates.beginEvent();
        BarcodeIterator i = this.flagList.iterator();
        while (i.hasNextBlack()) {
            i.nextBlack();
            if (this.currentMatcher.matches(this.source.get(i.getIndex()))) continue;
            int blackIndex = i.getBlackIndex();
            i.setWhite();
            this.updates.addDelete(blackIndex);
        }
        this.updates.commitEvent();
    }

    private void changed() {
        this.updates.beginEvent();
        BarcodeIterator i = this.flagList.iterator();
        while (i.hasNext()) {
            i.next();
            int filteredIndex = i.getBlackIndex();
            boolean wasIncluded = filteredIndex != -1;
            boolean include = this.currentMatcher.matches(this.source.get(i.getIndex()));
            if (wasIncluded && !include) {
                i.setWhite();
                this.updates.addDelete(filteredIndex);
                continue;
            }
            if (wasIncluded || !include) continue;
            this.updates.addInsert(i.setBlack());
        }
        this.updates.commitEvent();
    }

    public final int size() {
        return this.flagList.blackSize();
    }

    protected final int getSourceIndex(int mutationIndex) {
        return this.flagList.getIndex(mutationIndex, Barcode.BLACK);
    }

    protected boolean isWritable() {
        return true;
    }

    private class PrivateMatcherEditorListener
    implements MatcherEditor.Listener {
        private PrivateMatcherEditorListener() {
        }

        public void changedMatcher(MatcherEditor.Event matcherEvent) {
            MatcherEditor matcherEditor = matcherEvent.getMatcherEditor();
            Matcher matcher = matcherEvent.getMatcher();
            int changeType = matcherEvent.getType();
            FilterList.this.changeMatcherWithLocks(matcherEditor, matcher, changeType);
        }
    }
}

