/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package test.jboss.deployment;

import java.io.File;
import java.net.URL;

import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.jboss.deployment.Deployment;
import org.jboss.deployment.InstallerFactory;
import org.jboss.logging.Logger;

/** Tests of the org.jboss.deployment.InstallerFactory
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.1 $
 */
public class InstallerFactoryTest extends TestCase
{
   static Logger log;

   static
   {
      org.apache.log4j.BasicConfigurator.configure();
      log = Logger.getLogger(InstallerFactoryTest.class);
   }

   public InstallerFactoryTest(String s)
   {
      super(s);
   }

   public void testUnpackagedEJB() throws Exception
   {
      File tmpDir = new File("G:/InstallerFactory/tmp");
      InstallerFactory factory = new InstallerFactory(tmpDir, log);
      File pkg = new File("G:/InstallerFactory/secejb.jar");
      Deployment d = factory.install(pkg.toURL());
      log.info(d);
   }

   public void testUnpackagedWAR() throws Exception
   {
      File tmpDir = new File("G:/InstallerFactory/tmp");
      InstallerFactory factory = new InstallerFactory(tmpDir, log);
      File pkg = new File("G:/InstallerFactory/sectest.war");
      Deployment d = factory.install(pkg.toURL());
      log.info(d);
   }

   public void testUnpackagedEAR() throws Exception
   {
      File tmpDir = new File("G:/InstallerFactory/tmp");
      InstallerFactory factory = new InstallerFactory(tmpDir, log);
      File pkg = new File("G:/InstallerFactory/sectest");
      Deployment d = factory.install(pkg.toURL());
      log.info(d);
   }

   public static void main(java.lang.String[] args)
   {
      System.setErr(System.out);
      TestSuite suite = new TestSuite(InstallerFactoryTest.class);
      junit.textui.TestRunner.run(suite);
   }
}