/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.monitor;

import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.net.URL;

import javax.management.MBeanServer;
import javax.management.MBeanRegistration;
import javax.management.ObjectName;
import javax.management.ObjectInstance;
import javax.management.JMException;

import org.jboss.ejb.ContainerFactory;
import org.jboss.ejb.ContainerFactoryMBean;
import org.jboss.ejb.Application;
import org.jboss.ejb.InstanceCache;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.monitor.client.BeanCacheSnapshot;
import org.jboss.util.ServiceMBeanSupport;

/**
 *
 * @see Monitorable
 * @author Bill Burke (bill@jboss.org)
 * @version $Revision: 1.1.2.1 $
 */
public class DynamicMonitor extends ServiceMBeanSupport
   implements DynamicMonitorMBean
{
   // Constants ----------------------------------------------------
   
   // Static -------------------------------------------------------
   
   private static class MonitoredAttribute
   {
      public ObjectName objectName;
      public String attribute;
      public String displayName;

      public MonitoredAttribute(String displayName, String oname, String attr) throws Exception
      {
         objectName = new ObjectName(oname);
         attribute = attr;
         this.displayName = displayName;
      }
   }

   private ArrayList attributes = new ArrayList();
   private String monitoredAttributes;

   // Constructors -------------------------------------------------
   public DynamicMonitor()
   {}
   
   // Public -------------------------------------------------------
   public String getName()
   {
      return "DynamicMonitor";
   }

   public String getMonitoredAttributes()
   {
      return monitoredAttributes;
   }

   public void setMonitoredAttributes(String attrs)
   {
      attributes.clear();
      StringTokenizer tokenizer = new StringTokenizer(attrs);
      while (tokenizer.hasMoreTokens())
      {
         String displayName = tokenizer.nextToken();
         String objectName = tokenizer.nextToken();
         String attr = tokenizer.nextToken();
         MonitoredAttribute ma = null;
         try
         {
            ma = new MonitoredAttribute(displayName, objectName, attr);
         }
         catch (Exception ex)
         {
            log.error(ex);
         }
         attributes.add(ma);
      }
   }

   public String monitoredAttributesHTML()
   {
      StringBuffer output = new StringBuffer();
      output.append("<table width=\"1\" border=\"1\">");
      output.append("<tr><td>Threads</td><td>");
      output.append(Integer.toString(Thread.activeCount()));
      output.append("</td></tr>\n");
      output.append("<tr><td>Free Memory</td><td>");
      output.append(Long.toString(Runtime.getRuntime().freeMemory()));
      output.append("</td></tr>\n");
      output.append("<tr><td>Total Memory</td><td>");
      output.append(Long.toString(Runtime.getRuntime().totalMemory()));
      output.append("</td></tr>\n");
      for (int i = 0; i < attributes.size(); i++)
      {
         MonitoredAttribute attr = (MonitoredAttribute)attributes.get(i);
         Object obj = null;
         try
         {
            obj = getServer().getAttribute(attr.objectName, attr.attribute);
         }
         catch (Exception ex)
         {
            log.error(ex);
         }
         output.append("<tr><td>");
         output.append(attr.displayName);
         output.append("</td><td>");
         if (obj == null) obj = "FAILED TO GET ATTRIBUTE!";
         output.append(obj.toString());
         output.append("</td></tr>\n");
      }
      output.append("</table>");
      return output.toString();
    }

   public HashMap monitoredAttributes()
   {
      HashMap rtn = new HashMap();
      rtn.put("Threads", new Integer(Thread.activeCount()));
      rtn.put("Free Memory", new Long(Runtime.getRuntime().freeMemory()));
      rtn.put("Total Memory", new Long(Runtime.getRuntime().totalMemory()));
      for (int i = 0; i < attributes.size(); i++)
      {
         MonitoredAttribute attr = (MonitoredAttribute)attributes.get(i);
         Object obj = null;
         try
         {
            obj = getServer().getAttribute(attr.objectName, attr.attribute);
         }
         catch (Exception ex)
         {
            log.error(ex);
         }
         rtn.put(attr.displayName, obj);
      }
      return rtn;
    }

   // Inner classes -------------------------------------------------
}

