/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.deployment;

import java.io.File;

/** Common deployment utility methods.

 @author Scott.Stark@jboss.org
 @version: $Revision: 1.1.2.1 $
*/
public class Util
{

   /* Check that the file is a valid deployment descriptor name in the
    correct META-INF or WEB-INF directory
   */
   public static int hasDeploymentDescriptor(File file)
   {
      int ddType = -1;
      for(int n = 0; n < Installer.files.length; n ++)
      {
         File dd = new File(file, Installer.files[n]);
         if( dd.exists() )
         {
            ddType = n;
            break;
         }
      }
      return ddType;
   }

   /* Check that the file is a valid deployment descriptor name in the
    correct META-INF or WEB-INF directory
   */
   public static String getDeploymentDescriptor(File file)
   {
      String path = null;
      for(int n = 0; n < Installer.files.length; n ++)
      {
         File dd = new File(file, Installer.files[n]);
         if( dd.exists() )
         {
            path = Installer.files[n];
            break;
         }
      }
      return path;
   }

   /** Truncates the the name (the last cluster of letters after the last slash.
    *  @param _url an URL or something like that
    */
   public static String getName(String url)
   {
      int index = 0;
      if( url.endsWith("/") )
         index = url.lastIndexOf('/', url.length()-2);
      else
         index = url.lastIndexOf('/');
      String name = url.substring(index + 1);
      return name;
   }

   /** Generates a webcontex for the given url
    *  @param _url an URL or something like that
    */
   public static String getWebContext(String _url)
   {
      String s = getName(_url);
      
      // truncate the file extension
      int p = s.lastIndexOf(".");
      if (p != -1)
         s = s.substring(0, p);
      
      return "/" + s.replace('.', '/');
   }
}
