/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.util.Hashtable;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeGroupDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Referable;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.ScopableResolver;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComplexTypeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ElementUnmarshaller;
import org.exolab.castor.xml.schema.reader.ImportUnmarshaller;
import org.exolab.castor.xml.schema.reader.IncludeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ModelGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;
import org.exolab.castor.xml.schema.reader.UnknownUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class SchemaUnmarshaller
extends SaxUnmarshaller {
    public static final String XSD_NAMESPACE = "http://www.w3.org/2000/10/XMLSchema";
    public static final String[] UNSUPPORTED_NAMESPACES = new String[]{"http://www.w3.org/1999/XMLSchema"};
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_PREFIX = "xmlns:";
    private boolean _include = false;
    private SaxUnmarshaller unmarshaller;
    private int depth = 0;
    boolean skipAll = false;
    Resolver _resolver = null;
    Schema _schema = new Schema();
    private boolean foundSchemaDef = false;
    private String defaultNS = null;
    private Hashtable namespaces = null;

    public SchemaUnmarshaller() throws SAXException {
        this(null, null);
        this.foundSchemaDef = false;
    }

    public SchemaUnmarshaller(AttributeList attributeList, Resolver resolver) throws SAXException {
        this.setResolver(resolver);
        this.foundSchemaDef = true;
        this.namespaces = new Hashtable();
        this.init(attributeList);
    }

    public SchemaUnmarshaller(boolean bl) throws SAXException {
        this();
        this._include = bl;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }

    public String elementName() {
        return "schema";
    }

    public void endElement(String string) throws SAXException {
        Object object;
        if (this.skipAll) {
            return;
        }
        String string2 = null;
        int n = string.indexOf(58);
        if (n >= 0) {
            object = string.substring(0, n);
            string = string.substring(n + 1);
            string2 = (String)this.namespaces.get(object);
        } else {
            string2 = this.defaultNS;
        }
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string);
            --this.depth;
            return;
        }
        if ((string = string.intern()) == "schema") {
            return;
        }
        if (this.unmarshaller != null) {
            if (!string.equals(this.unmarshaller.elementName())) {
                object = "error: missing end element for ";
                object = String.valueOf(object) + this.unmarshaller.elementName();
                throw new SAXException((String)object);
            }
        } else {
            object = "error: missing start element for " + string;
            throw new SAXException((String)object);
        }
        this.unmarshaller.finish();
        if (string == "annotation") {
            this._schema.addAnnotation((Annotation)this.unmarshaller.getObject());
        } else if (string == "attributeGroup") {
            object = this.unmarshaller.getObject();
            try {
                this._schema.addAttributeGroup((AttributeGroupDecl)object);
            }
            catch (ClassCastException classCastException) {
                String string3 = "Top-level AttributeGroups must be defining AttributeGroups and not referring AttributeGroups.";
                this.error(string3);
            }
        } else if (string == "complexType") {
            object = null;
            object = ((ComplexTypeUnmarshaller)this.unmarshaller).getComplexType();
            this._schema.addComplexType((ComplexType)object);
            if (((XMLType)object).getName() != null) {
                this._resolver.addResolvable(((ComplexType)object).getReferenceId(), (Referable)object);
            } else {
                System.out.println("warning: top-level complexType with no name.");
            }
        } else if (string == "simpleType") {
            object = null;
            object = ((SimpleTypeUnmarshaller)this.unmarshaller).getSimpleType();
            this._schema.addSimpleType((SimpleType)object);
            this._resolver.addResolvable(((SimpleType)object).getReferenceId(), (Referable)object);
        } else if (string == "element") {
            object = null;
            object = ((ElementUnmarshaller)this.unmarshaller).getElement();
            this._schema.addElementDecl((ElementDecl)object);
        } else if (string == "group") {
            object = null;
            object = ((ModelGroupUnmarshaller)this.unmarshaller).getGroup();
            this._schema.addModelGroup((ModelGroup)object);
        }
        this.unmarshaller = null;
    }

    public Object getObject() {
        return this.getSchema();
    }

    public Schema getSchema() {
        return this._schema;
    }

    private void handleXMLNS(String string, String string2) throws SAXException {
        if (string == null || !string.startsWith(XMLNS)) {
            throw new IllegalArgumentException(String.valueOf(string) + " is not a namespace attribute.");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("error null or empty namespace value");
        }
        if (string.equals(XMLNS)) {
            this.defaultNS = string2;
            return;
        }
        String string3 = string.substring(XMLNS_PREFIX.length());
        this.namespaces.put(string3, string2);
        int n = 0;
        while (n < UNSUPPORTED_NAMESPACES.length) {
            if (string2.equals(UNSUPPORTED_NAMESPACES[n])) {
                this.error("The following namespace \"" + string2 + "\" is no longer supported. Please update to " + " XML Schema Candidate Release (October)");
            }
            ++n;
        }
        this._schema.addNamespace(string3, string2);
    }

    private void init(AttributeList attributeList) throws SAXException {
        if (attributeList == null) {
            return;
        }
        String string = attributeList.getValue("targetNamespace");
        if (string != null && string.length() > 0) {
            if (this._include && !this._schema.getTargetNamespace().equals(string)) {
                throw new SAXException("The target namespace of the included components must be the same as the target namespace of the including schema");
            }
            this._schema.setTargetNamespace(string);
        }
        this._schema.setId(attributeList.getValue("id"));
        this._schema.setVersion(attributeList.getValue("version"));
    }

    private void processNamespaces(AttributeList attributeList) throws SAXException {
        if (attributeList == null) {
            return;
        }
        int n = 0;
        while (n < attributeList.getLength()) {
            String string = attributeList.getName(n);
            if (string.equals(XMLNS) || string.startsWith(XMLNS_PREFIX)) {
                this.handleXMLNS(string, attributeList.getValue(n));
            }
            ++n;
        }
    }

    public void setResolver(Resolver resolver) {
        if (resolver == null) {
            resolver = new ScopableResolver();
        }
        super.setResolver(resolver);
        this._resolver = resolver;
    }

    public void setSchema(Schema schema) {
        this._schema = schema;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.skipAll) {
            return;
        }
        String string2 = string;
        this.processNamespaces(attributeList);
        String string3 = null;
        int n = string.indexOf(58);
        if (n >= 0) {
            String string4 = string.substring(0, n);
            string = string.substring(n + 1);
            string3 = (String)this.namespaces.get(string4);
        } else {
            string3 = this.defaultNS;
        }
        if (!this.foundSchemaDef && n < 0 && this.defaultNS == null) {
            this.defaultNS = XSD_NAMESPACE;
            string3 = XSD_NAMESPACE;
            System.out.println("No namespace declaration has been found for " + string);
            System.out.print("   * assuming default namespace of ");
            System.out.println(XSD_NAMESPACE);
        }
        if (!XSD_NAMESPACE.equals(string3)) {
            this.error("'" + string2 + "' has not been declared in the XML " + "Schema namespace.");
        }
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, attributeList);
            ++this.depth;
            return;
        }
        if ((string = string.intern()) == "schema") {
            if (this.foundSchemaDef) {
                this.illegalElement(string);
            }
            this.foundSchemaDef = true;
            this.init(attributeList);
            return;
        }
        if (string == "annotation") {
            this.unmarshaller = new AnnotationUnmarshaller(attributeList);
        } else if (string == "attributeGroup") {
            this.unmarshaller = new AttributeGroupUnmarshaller(this._schema, attributeList);
        } else if (string == "complexType") {
            this.unmarshaller = new ComplexTypeUnmarshaller(this._schema, attributeList, this._resolver);
        } else if (string == "element") {
            this.unmarshaller = new ElementUnmarshaller(this._schema, attributeList, this._resolver);
        } else if (string == "simpleType") {
            this.unmarshaller = new SimpleTypeUnmarshaller(this._schema, attributeList);
        } else if (string == "group") {
            this.unmarshaller = new ModelGroupUnmarshaller(this._schema, attributeList, this._resolver);
        } else if (string == "include") {
            this.unmarshaller = new IncludeUnmarshaller(this._schema, attributeList, this._resolver, this.getDocumentLocator());
        } else if (string == "import") {
            this.unmarshaller = new ImportUnmarshaller(this._schema, attributeList, this._resolver, this.getDocumentLocator());
        } else {
            System.out.print('<');
            System.out.print(string);
            System.out.print("> elements are either currently unsupported ");
            System.out.println("or non-valid schema elements.");
            this.unmarshaller = new UnknownUnmarshaller(string);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }
}

