/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeUnmarshaller;
import org.exolab.castor.xml.schema.reader.GroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class ExtensionUnmarshaller
extends SaxUnmarshaller {
    private SaxUnmarshaller unmarshaller;
    private int depth = 0;
    private ComplexType _complexType = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;
    private boolean foundAttributes = false;
    private boolean foundModelGroup = false;

    public ExtensionUnmarshaller(ComplexType complexType, AttributeList attributeList, Resolver resolver) throws SAXException {
        this.setResolver(resolver);
        this._complexType = complexType;
        this._schema = complexType.getSchema();
        this._complexType.setDerivationMethod("extension");
        String string = attributeList.getValue("base");
        if (string != null && string.length() > 0) {
            XMLType xMLType = this._schema.getType(string);
            if (xMLType == null) {
                this._complexType.setBase(string);
            } else {
                if (xMLType.isSimpleType() && this._complexType.isComplexContent()) {
                    String string2 = "In a 'complexContent', the base attribute must be a complexType but " + string + " is a simpleType.\n";
                    this.error(string2);
                }
                this._complexType.setBaseType(xMLType);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }

    public String elementName() {
        return "extension";
    }

    public void endElement(String string) throws SAXException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("attribute".equals(string)) {
            AttributeDecl attributeDecl = ((AttributeUnmarshaller)this.unmarshaller).getAttribute();
            this._complexType.addAttributeDecl(attributeDecl);
        } else if ("attributeGroup".equals(string)) {
            AttributeGroupReference attributeGroupReference = (AttributeGroupReference)this.unmarshaller.getObject();
            this._complexType.addAttributeGroupReference(attributeGroupReference);
        } else if (SchemaNames.isGroupName(string)) {
            Group group = ((GroupUnmarshaller)this.unmarshaller).getGroup();
            this._complexType.addGroup(group);
        } else if ("annotation".equals(string)) {
            Annotation annotation = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._complexType.addAnnotation(annotation);
        }
        this.unmarshaller = null;
    }

    public Object getObject() {
        return null;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, attributeList);
            ++this.depth;
            return;
        }
        if ("attribute".equals(string)) {
            this.foundAttributes = true;
            this.unmarshaller = new AttributeUnmarshaller(this._schema, attributeList, this.getResolver());
        } else if ("attributeGroup".equals(string)) {
            if (attributeList.getValue("ref") == null) {
                String string2 = "A complexType may contain referring attribute groups, but not defining ones.";
                this.error(string2);
            }
            this.foundAttributes = true;
            this.unmarshaller = new AttributeGroupUnmarshaller(this._schema, attributeList);
        } else if (SchemaNames.isGroupName(string)) {
            if (this.foundAttributes) {
                this.error("'" + string + "' must appear before attribute " + "definitions in an 'extension' element.");
            }
            if (this.foundModelGroup) {
                this.error("'" + string + "' cannot appear as a child of 'extension' " + "if another 'all', 'sequence', 'choice' or " + "'group' already exists.");
            }
            if (this._complexType.isSimpleContent()) {
                this.error("'" + string + "' may not appear in a 'extension' of " + "'simpleContent'.");
            }
            this.foundModelGroup = true;
            this.unmarshaller = new GroupUnmarshaller(this._schema, string, attributeList, this.getResolver());
        } else if ("anyAttribute".equals(string)) {
            this.error("anyAttribute is not yet supported.");
        } else if (string.equals("annotation")) {
            if (this.foundAttributes || this.foundModelGroup) {
                this.error("An annotation must appear as the first child of an 'extension' element.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation may appear as the child of an 'extension' element.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeList);
        } else {
            this.illegalElement(string);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }
}

