/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.dtd;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.dtd.Attribute;
import org.exolab.castor.xml.dtd.ContentParticle;
import org.exolab.castor.xml.dtd.DTDException;
import org.exolab.castor.xml.dtd.DTDdocument;
import org.exolab.castor.xml.dtd.Element;
import org.exolab.castor.xml.dtd.GeneralEntity;
import org.exolab.castor.xml.dtd.Notation;
import org.exolab.castor.xml.dtd.parser.DTDInitialParser;
import org.exolab.castor.xml.dtd.parser.DTDParser;
import org.exolab.castor.xml.dtd.parser.InputCharStream;
import org.exolab.castor.xml.dtd.parser.ParseException;
import org.exolab.castor.xml.dtd.parser.TokenMgrError;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentType;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;
import org.xml.sax.InputSource;

public class Converter {
    public static AttributeDecl convertAttribute(Attribute attribute, Schema schema) throws DTDException {
        AttributeDecl attributeDecl = new AttributeDecl(schema, attribute.getName());
        SimpleType simpleType = null;
        if (attribute.isStringType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(1));
        } else if (attribute.isIDType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(10));
        } else if (attribute.isIDREFType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(11));
        } else if (attribute.isIDREFSType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(17));
        } else if (attribute.isENTITYType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(12));
        } else if (attribute.isENTITIESType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(18));
        } else if (attribute.isNMTOKENType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(19));
        } else if (attribute.isNMTOKENSType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(20));
        } else if (attribute.isNOTATIONType()) {
            simpleType = schema.getSimpleType(schema.getBuiltInTypeName(14));
        } else if (!attribute.isEnumerationType()) {
            String string = "Converter: attribute \"" + attribute.getName();
            string = String.valueOf(string) + "\" has unspecified type.";
            throw new DTDException(string);
        }
        if (simpleType != null) {
            attributeDecl.setSimpleType(simpleType);
        }
        if (attribute.isREQUIRED()) {
            attributeDecl.setUse("required");
        } else if (attribute.isIMPLIED()) {
            attributeDecl.setUse("optional");
        } else if (attribute.isFIXED()) {
            attributeDecl.setValue(attribute.getDefaultValue());
            attributeDecl.setUse("fixed");
        } else {
            attributeDecl.setValue(attribute.getDefaultValue());
            attributeDecl.setUse("default");
        }
        return attributeDecl;
    }

    public static Object convertContentParticle(ContentParticle contentParticle, Schema schema) throws DTDException, SchemaException {
        Particle particle;
        if (contentParticle.isReferenceType()) {
            ElementDecl elementDecl = new ElementDecl(schema);
            elementDecl.setReference(contentParticle.getReference());
            if (contentParticle.isOneOccurance()) {
                elementDecl.setMinOccurs(1);
                elementDecl.setMaxOccurs(1);
            } else if (contentParticle.isOneOrMoreOccurances()) {
                elementDecl.setMinOccurs(1);
                elementDecl.setMaxOccurs(-1);
            } else if (contentParticle.isZeroOrMoreOccurances()) {
                elementDecl.setMinOccurs(0);
                elementDecl.setMaxOccurs(-1);
            } else if (contentParticle.isZeroOrOneOccurance()) {
                elementDecl.setMinOccurs(0);
                elementDecl.setMaxOccurs(1);
            }
            particle = elementDecl;
        } else if (contentParticle.isSeqType() || contentParticle.isChoiceType()) {
            Group group = new Group();
            if (contentParticle.isSeqType()) {
                group.setOrder(Order.seq);
            } else {
                group.setOrder(Order.choice);
            }
            Enumeration enumeration = contentParticle.getChildren();
            while (enumeration.hasMoreElements()) {
                ContentParticle contentParticle2 = (ContentParticle)enumeration.nextElement();
                Object object = Converter.convertContentParticle(contentParticle2, schema);
                if (object instanceof ElementDecl) {
                    group.addElementDecl((ElementDecl)object);
                    continue;
                }
                group.addGroup((Group)object);
            }
            if (contentParticle.isOneOccurance()) {
                group.setMinOccurs(1);
                group.setMaxOccurs(1);
            } else if (contentParticle.isOneOrMoreOccurances()) {
                group.setMinOccurs(1);
                group.setMaxOccurs(-1);
            } else if (contentParticle.isZeroOrMoreOccurances()) {
                group.setMinOccurs(0);
                group.setMaxOccurs(-1);
            } else if (contentParticle.isZeroOrOneOccurance()) {
                group.setMinOccurs(0);
                group.setMaxOccurs(1);
            }
            particle = group;
        } else {
            throw new DTDException();
        }
        return particle;
    }

    public static ElementDecl convertDTDElementToSchemaElement(Element element, Schema schema) throws DTDException, SchemaException {
        Object object;
        Object object2;
        String string = element.getName();
        if (string == null || string.equals("")) {
            String string2 = "Converter: a DTD element has no name.";
            throw new DTDException(string2);
        }
        ElementDecl elementDecl = new ElementDecl(schema, string);
        ComplexType complexType = new ComplexType(schema);
        ContentType contentType = null;
        Iterator iterator = null;
        String string3 = null;
        ElementDecl elementDecl2 = null;
        if (element.isEmptyContent()) {
            contentType = ContentType.empty;
        } else if (element.isAnyContent()) {
            contentType = ContentType.any;
        } else if (element.isElemOnlyContent()) {
            contentType = ContentType.elemOnly;
            object2 = element.getContent();
            if (object2 == null) {
                String string4 = "Converter: element \"" + element.getName();
                string4 = String.valueOf(string4) + "\" has unspecified content.";
                throw new DTDException(string4);
            }
            object = null;
            try {
                object = Converter.convertContentParticle((ContentParticle)object2, schema);
            }
            catch (DTDException dTDException) {
                String string5 = "Converter: content of element \"" + element.getName();
                string5 = String.valueOf(string5) + "\", represented by a Content Particle, is malformed.";
                throw new DTDException(string5);
            }
            if (object instanceof ElementDecl) {
                complexType.addElementDecl((ElementDecl)object);
            } else {
                complexType.addGroup((Group)object);
            }
        } else if (element.isMixedContent()) {
            iterator = element.getMixedContentChildren();
            if (iterator.hasNext()) {
                contentType = ContentType.mixed;
                while (iterator.hasNext()) {
                    string3 = (String)iterator.next();
                    elementDecl2 = new ElementDecl(schema);
                    elementDecl2.setReference(string3);
                    complexType.addElementDecl(elementDecl2);
                }
            } else {
                contentType = ContentType.textOnly;
            }
        } else {
            String string6 = "Converter: type of element \"" + element.getName();
            string6 = String.valueOf(string6) + "\" has not been specified.";
            throw new DTDException(string6);
        }
        complexType.setContentType(contentType);
        object2 = element.getAttributes();
        while (object2.hasMoreElements()) {
            object = (Attribute)object2.nextElement();
            AttributeDecl attributeDecl = Converter.convertAttribute((Attribute)object, schema);
            complexType.addAttributeDecl(attributeDecl);
        }
        elementDecl.setType(complexType);
        return elementDecl;
    }

    public static Schema convertDTDObjectToSchemaObject(DTDdocument dTDdocument) throws DTDException, SchemaException {
        Schema schema = new Schema();
        String string = dTDdocument.getName();
        if (string != null && !string.equals("")) {
            schema.setName(string);
        }
        Enumeration enumeration = dTDdocument.getNotations();
        while (enumeration.hasMoreElements()) {
            Notation notation = (Notation)enumeration.nextElement();
        }
        Enumeration enumeration2 = dTDdocument.getGeneralEntities();
        Annotation annotation = new Annotation();
        while (enumeration2.hasMoreElements()) {
            GeneralEntity generalEntity = (GeneralEntity)enumeration2.nextElement();
            Documentation documentation = new Documentation();
            String string2 = "General Entity Declaration";
            documentation.setContent(string2);
            documentation.add(generalEntity);
            annotation.addDocumentation(documentation);
        }
        schema.addAnnotation(annotation);
        Enumeration enumeration3 = dTDdocument.getElements();
        while (enumeration3.hasMoreElements()) {
            Element element = (Element)enumeration3.nextElement();
            ElementDecl elementDecl = Converter.convertDTDElementToSchemaElement(element, schema);
            schema.addElementDecl(elementDecl);
        }
        return schema;
    }

    public static void convertDTDtoSchema(Reader reader, Writer writer) throws DTDException, SchemaException, IOException, MarshalException, ValidationException, MappingException {
        DTDdocument dTDdocument = Converter.parseDTD(reader);
        Schema schema = Converter.convertDTDObjectToSchemaObject(dTDdocument);
        Converter.marshalSchema(schema, writer);
    }

    public static void main(String[] stringArray) throws IOException, DTDException, SchemaException, MarshalException, ValidationException, MappingException {
        if (stringArray.length < 2 || stringArray.length > 3) {
            String string = "\nUsage:\n";
            string = String.valueOf(string) + "java org.exolab.castor.xml.dtd.Converter dtd_file xsd_file [character_encoding]\n\n";
            string = String.valueOf(string) + "dtd_file: name of the input DTD file\n";
            string = String.valueOf(string) + "xsd_file: name of the output Schema file\n";
            string = String.valueOf(string) + "character_encoding: name of the character encoding,\n";
            string = String.valueOf(string) + "                    if not specified, ASCII is chosen\n";
            System.out.println(string);
        } else {
            String string = stringArray.length == 2 ? "US-ASCII" : (stringArray[2].equals("ascii") || stringArray[2].equals("ASCII") || stringArray[2].equals("us-ascii") ? "US-ASCII" : (stringArray[2].equals("utf-8") ? "UTF-8" : (stringArray[2].equals("utf-16") ? "UTF-16" : stringArray[2])));
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string);
            Converter.convertDTDtoSchema(inputStreamReader, outputStreamWriter);
            inputStreamReader.close();
            outputStreamWriter.close();
        }
    }

    public static void marshalSchema(Schema schema, Writer writer) throws IOException, MarshalException, ValidationException, MappingException {
        Marshaller marshaller = new Marshaller(writer);
        marshaller.setMarshalAsDocument(true);
        Mapping mapping = new Mapping();
        InputStream inputStream = mapping.getClass().getResourceAsStream("/org/exolab/castor/xml/dtd/SchemaMapping.xml");
        mapping.loadMapping(new InputSource(inputStream));
        marshaller.setMapping(mapping);
        marshaller.marshal(schema);
    }

    public static DTDdocument parseDTD(Reader reader) throws DTDException {
        try {
            InputCharStream inputCharStream = new InputCharStream(reader);
            DTDInitialParser dTDInitialParser = new DTDInitialParser(inputCharStream);
            String string = dTDInitialParser.Input();
            StringReader stringReader = new StringReader(string);
            inputCharStream = new InputCharStream(stringReader);
            DTDParser dTDParser = new DTDParser(inputCharStream);
            DTDdocument dTDdocument = dTDParser.Input();
            stringReader.close();
            return dTDdocument;
        }
        catch (TokenMgrError tokenMgrError) {
            String string = tokenMgrError.getMessage();
            throw new DTDException("TokenMgrError" + (string == null ? "" : ": " + string));
        }
        catch (ParseException parseException) {
            String string = parseException.getMessage();
            throw new DTDException("ParseException" + (string == null ? "" : ": " + string));
        }
    }
}

