/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.List;
import org.exolab.castor.util.Messages;
import org.exolab.castor.util.MimeBase64Encoder;
import org.exolab.castor.util.Stack;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.MarshalFramework;
import org.exolab.castor.xml.StringClassDescriptor;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.XMLMappingLoader;
import org.exolab.castor.xml.XMLNaming;
import org.exolab.castor.xml.util.ClassDescriptorResolverImpl;
import org.exolab.castor.xml.util.SAX2DOMHandler;
import org.exolab.castor.xml.util.XMLFieldDescriptorImpl;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class Marshaller
extends MarshalFramework {
    private static final String SERIALIZER_NOT_SAX_CAPABLE = "conf.serializerNotSaxCapable";
    public static final String XSI_NAMESPACE = "http://www.w3.org/2000/10/XMLSchema-instance";
    private static final String XMLNS = "xmlns";
    private static final String XSI_PREFIX = "xsi";
    private static final String XSI_TYPE = "xsi:type";
    private boolean _debug = false;
    private PrintWriter _logWriter = null;
    private Hashtable _nsPrefixKeyHash = null;
    private Hashtable _nsURIKeyHash = null;
    private boolean _nsPrefixAtRoot = false;
    private String _defaultNamespace = null;
    private boolean _validate = false;
    private List _nsScope = null;
    private ClassDescriptorResolver _cdResolver = null;
    private Hashtable _cdCache = null;
    private DocumentHandler _handler = null;
    private Serializer _serializer = null;
    private XMLNaming _naming = null;
    private Node _node = null;
    private boolean _asDocument = true;
    int depth = 0;
    private List _packages = null;
    private Stack _parents = null;
    private boolean _marshalExtendedType = true;
    private static final StringClassDescriptor _StringClassDescriptor = new StringClassDescriptor();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Class;

    public Marshaller(Writer writer) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("Argument 'out' is null.");
        }
        this.initialize();
        this._serializer = Configuration.getSerializer();
        if (this._serializer == null) {
            throw new RuntimeException("Unable to obtain serailizer");
        }
        this._serializer.setOutputCharStream(writer);
        this._handler = this._serializer.asDocumentHandler();
        if (this._handler == null) {
            String string = Messages.format(SERIALIZER_NOT_SAX_CAPABLE, this._serializer.getClass().getName());
            throw new RuntimeException(string);
        }
    }

    public Marshaller(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 'node' is null.");
        }
        this._node = node;
        this._handler = new SAX2DOMHandler(node);
        this.initialize();
    }

    public Marshaller(DocumentHandler documentHandler) {
        if (documentHandler == null) {
            throw new IllegalArgumentException("Argument 'handler' is null.");
        }
        this._handler = documentHandler;
        this.initialize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private boolean declareNamespace(String string, String string2, AttributeListImpl attributeListImpl) {
        boolean bl = false;
        if (string2 != null && !this._nsScope.contains(string2)) {
            int n;
            String string3 = XMLNS;
            if (string != null && (n = string.length()) > 0) {
                StringBuffer stringBuffer = new StringBuffer(6 + n);
                stringBuffer.append(XMLNS);
                stringBuffer.append(':');
                stringBuffer.append(string);
                string3 = stringBuffer.toString();
            }
            this._nsScope.add(string2);
            attributeListImpl.addAttribute(string3, null, string2);
            bl = true;
        }
        return bl;
    }

    private XMLClassDescriptor getClassDescriptor(Class clazz) throws MarshalException {
        XMLClassDescriptor xMLClassDescriptor = null;
        if (!MarshalFramework.isPrimitive(clazz)) {
            xMLClassDescriptor = this._cdResolver.resolve(clazz);
        }
        if (this._cdResolver.error()) {
            throw new MarshalException(this._cdResolver.getErrorMessage());
        }
        return xMLClassDescriptor;
    }

    private XMLClassDescriptor getClassDescriptor(String string, ClassLoader classLoader) throws MarshalException {
        XMLClassDescriptor xMLClassDescriptor = this._cdResolver.resolve(string, classLoader);
        if (this._cdResolver.error()) {
            throw new MarshalException(this._cdResolver.getErrorMessage());
        }
        return xMLClassDescriptor;
    }

    public boolean getMarshalExtendedType() {
        return this._marshalExtendedType;
    }

    public boolean getNSPrefixAtRoot() {
        return this._nsPrefixAtRoot;
    }

    private void initialize() {
        this._nsPrefixKeyHash = new Hashtable(3);
        this._nsURIKeyHash = new Hashtable(3);
        this._nsScope = new List(3);
        this._packages = new List(3);
        this._cdResolver = new ClassDescriptorResolverImpl();
        this._cdCache = new Hashtable(3);
        this._parents = new Stack();
        this._validate = Configuration.marshallingValidation();
        this._naming = XMLNaming.getInstance();
    }

    public void marshal(Object object) throws MarshalException, ValidationException {
        this.validate(object);
        if (this._asDocument) {
            try {
                this._handler.startDocument();
                this.marshal(object, null, this._handler);
                this._handler.endDocument();
            }
            catch (SAXException sAXException) {
                throw new MarshalException(sAXException);
            }
        } else {
            this.marshal(object, null, this._handler);
        }
    }

    public static void marshal(Object object, Writer writer) throws MarshalException, ValidationException {
        try {
            Marshaller marshaller = new Marshaller(writer);
            marshaller.marshal(object);
        }
        catch (IOException iOException) {
            throw new MarshalException(iOException);
        }
    }

    private void marshal(Object object, XMLFieldDescriptor xMLFieldDescriptor, DocumentHandler documentHandler) throws MarshalException, ValidationException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string;
        Object object7;
        XMLClassDescriptor xMLClassDescriptor;
        Object object8;
        Object object9;
        Object object10;
        if (object == null) {
            String string2 = "Marshaller#marshal: null parameter: 'object'";
            throw new IllegalArgumentException(string2);
        }
        if (this._parents.search(object) >= 0) {
            return;
        }
        this._parents.push(object);
        Class clazz = object.getClass();
        boolean bl = false;
        if (clazz.isArray()) {
            bl = clazz.getComponentType() == Byte.TYPE;
        }
        boolean bl2 = false;
        if (xMLFieldDescriptor == null) {
            xMLFieldDescriptor = new XMLFieldDescriptorImpl(clazz, "root", null, null);
            bl2 = true;
        }
        if ((object10 = xMLFieldDescriptor.getXMLName()) == null) {
            object10 = clazz.getName();
            int n = ((String)object10).lastIndexOf(46);
            if (n >= 0) {
                object10 = ((String)object10).substring(n + 1);
            }
            object10 = this._naming.toXMLName((String)object10);
        }
        XMLClassDescriptor xMLClassDescriptor2 = null;
        boolean bl3 = false;
        if (clazz == xMLFieldDescriptor.getFieldType()) {
            xMLClassDescriptor2 = (XMLClassDescriptor)xMLFieldDescriptor.getClassDescriptor();
        }
        if (xMLClassDescriptor2 == null) {
            if (MarshalFramework.isPrimitive(clazz) || bl) {
                xMLClassDescriptor2 = _StringClassDescriptor;
                bl3 = xMLFieldDescriptor.getFieldType() == (class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = Marshaller.class$("java.lang.Object")));
            } else {
                object9 = clazz.getName();
                int n = ((String)object9).lastIndexOf(".");
                if (n > 0 && !this._packages.contains(object8 = ((String)object9).substring(0, n + 1))) {
                    this._packages.add(object8);
                }
                if (this._marshalExtendedType) {
                    xMLClassDescriptor2 = this.getClassDescriptor(clazz);
                    bl3 = clazz != xMLFieldDescriptor.getFieldType();
                } else {
                    clazz = xMLFieldDescriptor.getFieldType();
                    xMLClassDescriptor2 = this.getClassDescriptor(clazz);
                }
                if (xMLFieldDescriptor.getXMLName() == null) {
                    object10 = xMLClassDescriptor2.getXMLName();
                }
            }
            if (xMLClassDescriptor2 == null) {
                if (clazz == (class$java$lang$Void != null ? class$java$lang$Void : (class$java$lang$Void = Marshaller.class$("java.lang.Void"))) || clazz == (class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = Marshaller.class$("java.lang.Object"))) || clazz == (class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = Marshaller.class$("java.lang.Class")))) {
                    throw new MarshalException("The marshaller cannot marshal/unmarshal types of Void.class, Class.class or Object.class");
                }
                this._parents.pop();
                return;
            }
        }
        if (bl3 && (xMLClassDescriptor = this._cdResolver.resolveByXMLName((String)(object9 = xMLClassDescriptor2.getXMLName()), null)) != null && !Introspector.introspected(xMLClassDescriptor)) {
            object8 = (XMLClassDescriptor)xMLClassDescriptor.getExtends();
            while (object8 != null && object8.getJavaClass() != xMLFieldDescriptor.getFieldType()) {
                object8 = (XMLClassDescriptor)object8.getExtends();
            }
            if (xMLFieldDescriptor.getFieldType().isAssignableFrom(xMLClassDescriptor.getJavaClass()) && (xMLClassDescriptor.getJavaClass() == xMLFieldDescriptor.getFieldType() || object8 != null && object8.getJavaClass() == xMLFieldDescriptor.getFieldType())) {
                bl3 = false;
                object10 = object9;
            }
        }
        object9 = new AttributeListImpl();
        XMLFieldDescriptor[] xMLFieldDescriptorArray = xMLClassDescriptor2.getAttributeDescriptors();
        int n = 0;
        while (n < xMLFieldDescriptorArray.length) {
            block81: {
                if (xMLFieldDescriptorArray[n] != null) {
                    object7 = xMLFieldDescriptorArray[n];
                    string = object7.getXMLName();
                    Object object11 = null;
                    try {
                        object11 = object7.getHandler().getValue(object);
                    }
                    catch (IllegalStateException illegalStateException) {
                        break block81;
                    }
                    if (object7.isReference() && object11 != null) {
                        object6 = this.getClassDescriptor(object11.getClass());
                        object5 = null;
                        if (object6 != null) {
                            object4 = (XMLFieldDescriptor)object6.getIdentity();
                            if (object4 != null) {
                                object3 = object4.getHandler();
                                if (object3 != null) {
                                    try {
                                        object11 = object3.getValue(object11);
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        object5 = illegalStateException.toString();
                                    }
                                } else {
                                    object5 = "FieldHandler for Identity descriptor is null.";
                                }
                            } else {
                                object5 = "No identity descriptor available";
                            }
                        } else {
                            object5 = "Unable to resolve ClassDescriptor for: " + object11.getClass().getName();
                        }
                        if (object5 != null) {
                            object4 = "Unable to save reference to: " + object6.getXMLName() + " from element: " + xMLClassDescriptor2.getXMLName() + " due to the following error: ";
                            throw new MarshalException((String)object4);
                        }
                    }
                    if (object11 != null) {
                        ((AttributeListImpl)object9).addAttribute(string, null, object11.toString());
                    }
                }
            }
            ++n;
        }
        if (bl3) {
            bl3 = this.declareNamespace(XSI_PREFIX, XSI_NAMESPACE, (AttributeListImpl)object9);
            ((AttributeListImpl)object9).addAttribute(XSI_TYPE, null, "java:" + clazz.getName());
        }
        if ((object7 = xMLFieldDescriptor.getNameSpacePrefix()) == null) {
            object7 = xMLClassDescriptor2.getNameSpacePrefix();
        }
        if ((string = xMLFieldDescriptor.getNameSpaceURI()) == null) {
            string = xMLClassDescriptor2.getNameSpaceURI();
        }
        if (string == null && object7 != null) {
            string = (String)this._nsPrefixKeyHash.get(object7);
        } else if (object7 == null && string != null) {
            object7 = (String)this._nsURIKeyHash.get(string);
        }
        boolean bl4 = false;
        if (!(string == null || this._nsPrefixAtRoot && object7 != null)) {
            bl4 = this.declareNamespace((String)object7, string, (AttributeListImpl)object9);
        }
        if (this._nsPrefixAtRoot && bl2) {
            object6 = this._nsPrefixKeyHash.keys();
            object5 = this._nsPrefixKeyHash.elements();
            while (object6.hasMoreElements()) {
                this.declareNamespace((String)object6.nextElement(), (String)object5.nextElement(), (AttributeListImpl)object9);
            }
        }
        object6 = null;
        if (object7 != null) {
            int n2 = ((String)object7).length();
            if (n2 > 0) {
                object4 = new StringBuffer(n2 + ((String)object10).length() + 1);
                ((StringBuffer)object4).append((String)object7);
                ((StringBuffer)object4).append(':');
                ((StringBuffer)object4).append((String)object10);
                object6 = ((StringBuffer)object4).toString();
            } else {
                object6 = object10;
            }
        } else {
            object6 = object10;
        }
        try {
            documentHandler.startElement((String)object6, (AttributeList)object9);
        }
        catch (SAXException sAXException) {
            throw new MarshalException(sAXException);
        }
        XMLFieldDescriptor xMLFieldDescriptor2 = xMLClassDescriptor2.getContentDescriptor();
        if (xMLFieldDescriptor2 != null) {
            object4 = null;
            try {
                object4 = xMLFieldDescriptor2.getHandler().getValue(object);
            }
            catch (IllegalStateException illegalStateException) {}
            if (object4 != null && (object3 = object4.toString()) != null && ((String)object3).length() > 0) {
                object2 = ((String)object3).toCharArray();
                try {
                    documentHandler.characters((char[])object2, 0, ((char[])object2).length);
                }
                catch (SAXException sAXException) {
                    throw new MarshalException(sAXException);
                }
            }
        } else {
            if (bl) {
                object4 = new MimeBase64Encoder();
                ((MimeBase64Encoder)object4).translate((byte[])object);
                object3 = ((MimeBase64Encoder)object4).getCharArray();
                try {
                    documentHandler.characters((char[])object3, 0, ((Object)object3).length);
                }
                catch (SAXException sAXException) {
                    throw new MarshalException(sAXException);
                }
            }
            if (MarshalFramework.isPrimitive(clazz)) {
                object4 = object.toString().toCharArray();
                try {
                    documentHandler.characters((char[])object4, 0, ((Object)object4).length);
                }
                catch (SAXException sAXException) {
                    throw new MarshalException(sAXException);
                }
            }
        }
        xMLFieldDescriptorArray = xMLClassDescriptor2.getElementDescriptors();
        ++this.depth;
        int n3 = 0;
        while (n3 < xMLFieldDescriptorArray.length) {
            block82: {
                object3 = xMLFieldDescriptorArray[n3];
                object2 = null;
                try {
                    object2 = object3.getHandler().getValue(object);
                }
                catch (IllegalStateException illegalStateException) {
                    break block82;
                }
                if (object2 != null) {
                    Class<?> clazz2 = object2.getClass();
                    if (clazz2.isArray()) {
                        if (clazz2.getComponentType() == Byte.TYPE) {
                            this.marshal(object2, (XMLFieldDescriptor)object3, documentHandler);
                        } else {
                            int n4 = Array.getLength(object2);
                            int n5 = 0;
                            while (n5 < n4) {
                                Object object12 = Array.get(object2, n5);
                                if (object12 != null) {
                                    this.marshal(object12, (XMLFieldDescriptor)object3, documentHandler);
                                }
                                ++n5;
                            }
                        }
                    } else if (object2 instanceof Enumeration) {
                        Enumeration enumeration = (Enumeration)object2;
                        while (enumeration.hasMoreElements()) {
                            Object e = enumeration.nextElement();
                            if (e == null) continue;
                            this.marshal(e, (XMLFieldDescriptor)object3, documentHandler);
                        }
                    } else if (object2 instanceof Vector) {
                        this.marshal(object2, (XMLFieldDescriptor)object3, documentHandler);
                    } else {
                        this.marshal(object2, (XMLFieldDescriptor)object3, documentHandler);
                    }
                }
            }
            ++n3;
        }
        try {
            documentHandler.endElement((String)object6);
        }
        catch (SAXException sAXException) {
            throw new MarshalException(sAXException);
        }
        --this.depth;
        this._parents.pop();
        if (bl4) {
            this._nsScope.remove(string);
        }
        if (bl3) {
            this._nsScope.remove(XSI_NAMESPACE);
        }
    }

    public static void marshal(Object object, Node node) throws MarshalException, ValidationException {
        Marshaller marshaller = new Marshaller(node);
        marshaller.marshal(object);
    }

    public static void marshal(Object object, DocumentHandler documentHandler) throws MarshalException, ValidationException {
        Marshaller marshaller = new Marshaller(documentHandler);
        marshaller.marshal(object);
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this._logWriter = printWriter;
    }

    public void setMapping(Mapping mapping) throws MappingException {
        if (this._cdResolver == null) {
            this._cdResolver = new ClassDescriptorResolverImpl();
        }
        this._cdResolver.setMappingLoader((XMLMappingLoader)mapping.getResolver(Mapping.XML));
    }

    public void setMarshalAsDocument(boolean bl) {
        block2: {
            this._asDocument = bl;
            if (this._serializer == null) break block2;
            OutputFormat outputFormat = Configuration.getOutputFormat();
            outputFormat.setOmitXMLDeclaration(bl ^ true);
            this._serializer.setOutputFormat(outputFormat);
            try {
                this._handler = this._serializer.asDocumentHandler();
            }
            catch (IOException iOException) {}
        }
    }

    public void setMarshalExtendedType(boolean bl) {
        this._marshalExtendedType = bl;
    }

    public void setNSPrefixAtRoot(boolean bl) {
        this._nsPrefixAtRoot = bl;
    }

    public void setNamespaceMapping(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            String string3 = "namespace URI must not be null.";
            throw new IllegalArgumentException(string3);
        }
        if (string == null || string.length() == 0) {
            this._defaultNamespace = string2;
            return;
        }
        this._nsPrefixKeyHash.put(string, string2);
        this._nsURIKeyHash.put(string2, string);
    }

    public void setResolver(ClassDescriptorResolver classDescriptorResolver) {
        if (classDescriptorResolver != null) {
            this._cdResolver = classDescriptorResolver;
        }
    }

    public void setValidation(boolean bl) {
        this._validate = bl;
    }

    private void validate(Object object) throws ValidationException {
        if (this._validate) {
            Validator validator = new Validator();
            validator.validate(object, this._cdResolver);
        }
    }
}

