/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.types.TimePeriod;

public class Year
extends TimePeriod {
    private static final boolean DEBUG = false;
    private static final String YEAR_FORMAT = "yyyy";

    public Year() {
        super("P1Y");
        int n = TimeZone.getDefault().getRawOffset();
        if (n < 0) {
            n = -n;
            try {
                this.setZoneNegative();
            }
            catch (OperationNotSupportedException operationNotSupportedException) {}
        }
        short s = (short)(n / 3600000);
        short s2 = (short)((n %= 3600000) / 60000);
        try {
            this.setZone(s, s2);
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
    }

    public static Object parse(String string) throws ParseException {
        return Year.parseYear(string);
    }

    public static Year parseYear(String string) throws ParseException {
        Year year = new Year();
        if (string.startsWith("-")) {
            year.setNegative();
            string = string.substring(1);
        }
        if (string.length() != 4) {
            throw new ParseException(String.valueOf(string) + ": Bad XML Schema Year type format (CCYY)", 0);
        }
        year.setCentury(Short.parseShort(string.substring(0, 2)));
        try {
            year.setYear(Short.parseShort(string.substring(2, 4)));
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        return year;
    }

    public void setDay(short s) throws OperationNotSupportedException {
        String string = "In a Year : the day field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setHour(short s) throws OperationNotSupportedException {
        String string = "In a Year : the hour field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setMinute(short s) throws OperationNotSupportedException {
        String string = "In a Year : the minute field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setMonth(short s) throws OperationNotSupportedException {
        String string = "In a Year : the month field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setSecond(short s, short s2) throws OperationNotSupportedException {
        String string = "In a Year : the second fields must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setZone(short s, short s2) throws OperationNotSupportedException {
        String string = "In a Year : the time zone fields must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setZoneNegative() throws OperationNotSupportedException {
        String string = "In a Year : the time zone fields must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public Date toDate() throws ParseException {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(YEAR_FORMAT);
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
        if (!this.isUTC()) {
            int n = 0;
            n = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            n = this.isZoneNegative() ? -n : n;
            simpleTimeZone.setRawOffset(n);
            simpleTimeZone.setID(TimeZone.getAvailableIDs(n)[0]);
        }
        simpleDateFormat.setTimeZone(simpleTimeZone);
        date = simpleDateFormat.parse(this.toString());
        return date;
    }

    public String toString() {
        String string;
        String string2 = null;
        string2 = String.valueOf(this.getCentury());
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if ((string = String.valueOf(this.getYear())).length() == 1) {
            string = "0" + string;
        }
        string2 = String.valueOf(string2) + string;
        string2 = this.isNegative() ? "-" + string2 : string2;
        return string2;
    }
}

