/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.types.TimePeriod;

public class Century
extends TimePeriod {
    private static final boolean DEBUG = false;
    private static final String YEAR_FORMAT = "yyyy";

    public Century() {
        super("P100Y");
        int n = TimeZone.getDefault().getRawOffset();
        if (n < 0) {
            n = -n;
            try {
                this.setZoneNegative();
            }
            catch (OperationNotSupportedException operationNotSupportedException) {}
        }
        try {
            short s = (short)(n / 3600000);
            short s2 = (short)((n %= 3600000) / 60000);
            super.setZone(s, s2);
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
    }

    public static Object parse(String string) throws ParseException {
        return Century.parseCentury(string);
    }

    public static Century parseCentury(String string) throws ParseException {
        Century century = new Century();
        if (string.startsWith("-")) {
            century.setNegative();
            string = string.substring(1);
        }
        if (string.length() != 2) {
            throw new ParseException(String.valueOf(string) + ": Bad XML Schema Century type format (CC)", 0);
        }
        century.setCentury(Short.parseShort(string));
        return century;
    }

    public void setDay(short s) throws OperationNotSupportedException {
        String string = "In a Century : the day field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setHour(short s) throws OperationNotSupportedException {
        String string = "In a Century : the hour field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setMinute(short s) throws OperationNotSupportedException {
        String string = "In a Century : the minute field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setMonth(short s) throws OperationNotSupportedException {
        String string = "In a Century : the month field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setSecond(short s, short s2) throws OperationNotSupportedException {
        String string = "In a Century : the second field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setYear(short s) throws OperationNotSupportedException {
        String string = "In a Century : the year field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setZone(short s, short s2) throws OperationNotSupportedException {
        String string = "In a Century : the time zone field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setZoneNegative() throws OperationNotSupportedException {
        String string = "In a Century : the time zone field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public Date toDate() throws ParseException {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(YEAR_FORMAT);
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
        if (!this.isUTC()) {
            int n = 0;
            n = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            n = this.isZoneNegative() ? -n : n;
            simpleTimeZone.setRawOffset(n);
            simpleTimeZone.setID(TimeZone.getAvailableIDs(n)[0]);
        }
        simpleDateFormat.setTimeZone(simpleTimeZone);
        date = simpleDateFormat.parse(this.toString());
        return date;
    }

    public String toString() {
        String string = null;
        string = String.valueOf(this.getCentury());
        if (string.length() == 1) {
            string = "0" + string;
        }
        string = this.isNegative() ? "-" + string : string;
        return string;
    }
}

