/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.oql;

import java.util.Hashtable;
import org.exolab.castor.jdo.oql.InvalidCharException;
import org.exolab.castor.jdo.oql.NoMoreTokensException;
import org.exolab.castor.jdo.oql.Token;
import org.exolab.castor.jdo.oql.TokenTypes;

public class Lexer
implements TokenTypes {
    String _queryString;
    int _pos;
    Hashtable keywords;
    boolean endOfQueryPassed = false;

    public Lexer(String string) {
        this._queryString = string;
        this.keywords = new Hashtable();
        this.keywords.put("select", new Integer(1));
        this.keywords.put("as", new Integer(3));
        this.keywords.put("from", new Integer(5));
        this.keywords.put("in", new Integer(6));
        this.keywords.put("where", new Integer(7));
        this.keywords.put("or", new Integer(8));
        this.keywords.put("and", new Integer(9));
        this.keywords.put("like", new Integer(12));
        this.keywords.put("mod", new Integer(22));
        this.keywords.put("abs", new Integer(23));
        this.keywords.put("not", new Integer(24));
        this.keywords.put("nil", new Integer(28));
        this.keywords.put("undefined", new Integer(29));
        this.keywords.put("between", new Integer(40));
        this.keywords.put("distinct", new Integer(41));
        this.keywords.put("is_defined", new Integer(42));
        this.keywords.put("is_undefined", new Integer(43));
        this.keywords.put("list", new Integer(44));
        this.keywords.put("order", new Integer(46));
        this.keywords.put("by", new Integer(47));
        this.keywords.put("asc", new Integer(48));
        this.keywords.put("desc", new Integer(49));
        this.keywords.put("count", new Integer(50));
        this.keywords.put("sum", new Integer(51));
        this.keywords.put("min", new Integer(52));
        this.keywords.put("max", new Integer(53));
        this.keywords.put("avg", new Integer(54));
        this.keywords.put("limit", new Integer(55));
    }

    private Token charLiteral() throws NoMoreTokensException, InvalidCharException {
        StringBuffer stringBuffer;
        block7: {
            char c;
            try {
                c = this._queryString.charAt(this._pos);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoMoreTokensException();
            }
            if (c != '\'') {
                throw new InvalidCharException("charLiteral() was called when the next character was not a double quote.  Position: " + this._pos);
            }
            stringBuffer = new StringBuffer("'");
            ++this._pos;
            try {
                c = this._queryString.charAt(this._pos);
                stringBuffer.append(c);
                ++this._pos;
                if (c == '\\') {
                    c = this._queryString.charAt(this._pos);
                    stringBuffer.append(c);
                    ++this._pos;
                }
                if ((c = this._queryString.charAt(this._pos)) == '\'') {
                    stringBuffer.append(c);
                    ++this._pos;
                    break block7;
                }
                throw new InvalidCharException("Character literals may only contain a single character or escape sequence.  Position: " + this._pos);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new InvalidCharException("End of query string reached, but ' expected.");
            }
        }
        return new Token(35, stringBuffer.toString());
    }

    private char consumeWhiteSpace(char c) {
        while (this.isWhiteSpace(c)) {
            ++this._pos;
            c = this._queryString.charAt(this._pos);
        }
        return c;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Token dateLiteral(String string) throws InvalidCharException {
        StringBuffer stringBuffer = new StringBuffer(string);
        char c = this.getChar();
        try {
            c = this._queryString.charAt(this._pos);
            c = this.consumeWhiteSpace(c);
            if (c != '\'') {
                throw new InvalidCharException("The date keyword must be followed by a single quote.  Position: " + this._pos);
            }
            stringBuffer.append(" '");
            ++this._pos;
            c = this._queryString.charAt(this._pos);
            c = this.consumeWhiteSpace(c);
            if (!this.isDigit(c)) {
                throw new InvalidCharException("Digit expected in date literal.  Position: " + this._pos);
            }
            while (true) {
                if (!this.isDigit(c)) {
                    if ((c = this.consumeWhiteSpace(c)) == '-') break;
                    throw new InvalidCharException("- expected.  Fields in date literal must be separated by a dash.  Position: " + this._pos);
                }
                stringBuffer.append(c);
                ++this._pos;
                c = this._queryString.charAt(this._pos);
            }
            stringBuffer.append(c);
            ++this._pos;
            c = this._queryString.charAt(this._pos);
            c = this.consumeWhiteSpace(c);
            if (!this.isDigit(c)) {
                throw new InvalidCharException("Digit expected in date literal.  Position: " + this._pos);
            }
            while (true) {
                if (!this.isDigit(c)) {
                    if ((c = this.consumeWhiteSpace(c)) == '-') break;
                    throw new InvalidCharException("- expected.  Fields in date literal must be separated by a dash.  Position: " + this._pos);
                }
                stringBuffer.append(c);
                ++this._pos;
                c = this._queryString.charAt(this._pos);
            }
            stringBuffer.append(c);
            ++this._pos;
            c = this._queryString.charAt(this._pos);
            c = this.consumeWhiteSpace(c);
            if (!this.isDigit(c)) {
                throw new InvalidCharException("Digit expected in date literal.  Position: " + this._pos);
            }
            while (true) {
                if (!this.isDigit(c)) {
                    if ((c = this.consumeWhiteSpace(c)) == '\'') break;
                    throw new InvalidCharException("' expected.  Date literal must be enclosed by a single quotes.  Position: " + this._pos);
                }
                stringBuffer.append(c);
                ++this._pos;
                c = this._queryString.charAt(this._pos);
            }
            stringBuffer.append(c);
            ++this._pos;
            return new Token(37, stringBuffer.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidCharException("End of query encountered in the middle of date literal.");
        }
    }

    private char getChar() {
        try {
            return this._queryString.charAt(this._pos);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return '\u0000';
        }
    }

    public boolean hasMoreTokens() {
        return this.endOfQueryPassed ^ true;
    }

    private Token identifier() throws NoMoreTokensException, InvalidCharException {
        char c;
        try {
            c = this._queryString.charAt(this._pos);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoMoreTokensException();
        }
        if (!this.isLetter(c)) {
            throw new InvalidCharException("identifier() was called when the next character was not a letter.  Position: " + this._pos);
        }
        StringBuffer stringBuffer = new StringBuffer().append(c);
        ++this._pos;
        c = this.getChar();
        while (this.isDigit(c) || this.isLetter(c) || c == '_') {
            stringBuffer.append(c);
            ++this._pos;
            c = this.getChar();
        }
        String string = stringBuffer.toString().toLowerCase();
        if (string.equals("date")) {
            return this.dateLiteral(stringBuffer.toString());
        }
        if (string.equals("time")) {
            return this.timeLiteral(stringBuffer.toString());
        }
        if (string.equals("timestamp")) {
            return this.timeStampLiteral(stringBuffer.toString());
        }
        if (string.equals("true") || string.equals("false")) {
            return new Token(32, stringBuffer.toString());
        }
        if (this.keywords.containsKey(string)) {
            return new Token((Integer)this.keywords.get(string), stringBuffer.toString());
        }
        return new Token(2, stringBuffer.toString());
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private boolean isWhiteSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public Token nextToken() throws NoMoreTokensException, InvalidCharException {
        try {
            var1_1 = this._queryString.charAt(this._pos);
            if (true) ** GOTO lbl18
        }
        catch (IndexOutOfBoundsException v0) {
            if (!this.endOfQueryPassed) {
                this.endOfQueryPassed = true;
                return new Token(0, "");
            }
            throw new NoMoreTokensException();
        }
        do {
            ++this._pos;
            try {
                var1_1 = this._queryString.charAt(this._pos);
            }
            catch (IndexOutOfBoundsException v1) {
                if (this.endOfQueryPassed) continue;
                this.endOfQueryPassed = true;
                return new Token(0, "");
            }
lbl18:
            // 3 sources

        } while (this.isWhiteSpace(var1_1));
        if (this.isDigit(var1_1)) {
            return this.numericLiteral();
        }
        if (this.isLetter(var1_1)) {
            return this.identifier();
        }
        var2_2 = '\u0000';
        try {
            var2_2 = this._queryString.charAt(this._pos + 1);
        }
        catch (IndexOutOfBoundsException v2) {}
        if (var1_1 == '!' && var2_2 == '=') {
            this._pos += 2;
            return new Token(11, "!=");
        }
        if (var1_1 == '>' && var2_2 == '=') {
            this._pos += 2;
            return new Token(16, ">=");
        }
        if (var1_1 == '<' && var2_2 == '=') {
            this._pos += 2;
            return new Token(14, "<=");
        }
        if (var1_1 == '|' && var2_2 == '|') {
            this._pos += 2;
            return new Token(19, "||");
        }
        if (var1_1 == '-' && var2_2 == '>') {
            this._pos += 2;
            return new Token(31, "->");
        }
        var3_3 = null;
        switch (var1_1) {
            case '\'': {
                return this.charLiteral();
            }
            case '\"': {
                return this.stringLiteral();
            }
            case ':': {
                var3_3 = new Token(4, ":");
                break;
            }
            case '=': {
                var3_3 = new Token(10, "=");
                break;
            }
            case '<': {
                var3_3 = new Token(13, "<");
                break;
            }
            case '>': {
                var3_3 = new Token(15, ">");
                break;
            }
            case '+': {
                var3_3 = new Token(17, "+");
                break;
            }
            case '-': {
                var3_3 = new Token(18, "-");
                break;
            }
            case '*': {
                var3_3 = new Token(20, "*");
                break;
            }
            case '/': {
                var3_3 = new Token(21, "/");
                break;
            }
            case '(': {
                var3_3 = new Token(25, "(");
                break;
            }
            case ')': {
                var3_3 = new Token(26, ")");
                break;
            }
            case '.': {
                var3_3 = new Token(30, ".");
                break;
            }
            case '$': {
                var3_3 = new Token(27, "$");
                break;
            }
            case ',': {
                var3_3 = new Token(45, ",");
                break;
            }
        }
        if (var3_3 == null) {
            throw new InvalidCharException("An invalid character was found in the query at position " + this._pos);
        }
        ++this._pos;
        return var3_3;
    }

    /*
     * Unable to fully structure code
     */
    private Token numericLiteral() throws NoMoreTokensException, InvalidCharException {
        block10: {
            try {
                var1_1 = this._queryString.charAt(this._pos);
            }
            catch (IndexOutOfBoundsException v0) {
                throw new NoMoreTokensException();
            }
            if (!this.isDigit(var1_1)) {
                throw new InvalidCharException("numericLiteral() was called when the next character was not a digit.  Position: " + this._pos);
            }
            var2_2 = new StringBuffer().append(var1_1);
            ++this._pos;
            var1_1 = this.getChar();
            while (this.isDigit(var1_1)) {
                var2_2.append(var1_1);
                ++this._pos;
                var1_1 = this.getChar();
            }
            if (var1_1 != '.') break block10;
            var2_2.append('.');
            ++this._pos;
            var1_1 = this.getChar();
            if (this.isDigit(var1_1)) ** GOTO lbl28
            throw new InvalidCharException("Digit expected after decimal point in double literal. Position: " + this._pos);
lbl-1000:
            // 1 sources

            {
                var2_2.append(var1_1);
                ++this._pos;
                var1_1 = this.getChar();
lbl28:
                // 2 sources

                ** while (this.isDigit((char)var1_1))
            }
lbl29:
            // 1 sources

            if (var1_1 == 'E' || var1_1 == 'e') {
                var2_2.append(var1_1);
                ++this._pos;
                var1_1 = this.getChar();
                var3_3 = false;
                if (var1_1 == '+' || var1_1 == '-') {
                    var3_3 = true;
                    var2_2.append(var1_1);
                    ++this._pos;
                    var1_1 = this.getChar();
                }
                if (!this.isDigit(var1_1)) {
                    if (var3_3) {
                        throw new InvalidCharException("Digit expected after sign in exponent (double literal).  Position: " + this._pos);
                    }
                    throw new InvalidCharException("Digit expected after exponent character (double literal).  Position: " + this._pos);
                }
                var2_2.append(var1_1);
                ++this._pos;
                var1_1 = this.getChar();
                while (this.isDigit(var1_1)) {
                    var2_2.append(var1_1);
                    ++this._pos;
                    var1_1 = this.getChar();
                }
            }
            return new Token(34, var2_2.toString());
        }
        return new Token(33, var2_2.toString());
    }

    private Token stringLiteral() throws NoMoreTokensException, InvalidCharException {
        char c;
        try {
            c = this._queryString.charAt(this._pos);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoMoreTokensException();
        }
        if (c != '\"') {
            throw new InvalidCharException("stringLiteral() was called when the next character was not a double quote.  Position: " + this._pos);
        }
        StringBuffer stringBuffer = new StringBuffer("\"");
        ++this._pos;
        try {
            c = this._queryString.charAt(this._pos);
            while (c != '\"') {
                stringBuffer.append(c);
                if (c == '\\') {
                    ++this._pos;
                    c = this._queryString.charAt(this._pos);
                    stringBuffer.append(c);
                }
                ++this._pos;
                c = this._queryString.charAt(this._pos);
            }
            stringBuffer.append(c);
            ++this._pos;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidCharException("End of query string reached, but \" expected.");
        }
        return new Token(36, stringBuffer.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Token timeLiteral(String string) throws InvalidCharException {
        StringBuffer stringBuffer = new StringBuffer(string);
        char c = this.getChar();
        try {
            c = this._queryString.charAt(this._pos);
            c = this.consumeWhiteSpace(c);
            if (c != '\'') {
                throw new InvalidCharException("The time keyword must be followed by a single quote.  Position: " + this._pos);
            }
            stringBuffer.append(" '");
            ++this._pos;
            c = this._queryString.charAt(this._pos);
            c = this.consumeWhiteSpace(c);
            if (!this.isDigit(c)) {
                throw new InvalidCharException("Digit expected in time literal.  Position: " + this._pos);
            }
            while (true) {
                if (!this.isDigit(c)) {
                    if ((c = this.consumeWhiteSpace(c)) == ':') break;
                    throw new InvalidCharException(": expected.  Fields in time literal must be separated by a colon.  Position: " + this._pos);
                }
                stringBuffer.append(c);
                ++this._pos;
                c = this._queryString.charAt(this._pos);
            }
            stringBuffer.append(c);
            ++this._pos;
            c = this._queryString.charAt(this._pos);
            c = this.consumeWhiteSpace(c);
            if (!this.isDigit(c)) {
                throw new InvalidCharException("Digit expected in time literal.  Position: " + this._pos);
            }
            while (true) {
                if (!this.isDigit(c)) {
                    if ((c = this.consumeWhiteSpace(c)) == ':') break;
                    throw new InvalidCharException(": expected.  Fields in time literal must be separated by a colon.  Position: " + this._pos);
                }
                stringBuffer.append(c);
                ++this._pos;
                c = this._queryString.charAt(this._pos);
            }
            stringBuffer.append(c);
            ++this._pos;
            c = this._queryString.charAt(this._pos);
            c = this.consumeWhiteSpace(c);
            if (!this.isDigit(c)) {
                throw new InvalidCharException("Digit expected in time literal.  Position: " + this._pos);
            }
            while (true) {
                if (!this.isDigit(c)) {
                    if ((c = this.consumeWhiteSpace(c)) == '\'') break;
                    throw new InvalidCharException("' expected.  Time literal must be enclosed by a single quotes.  Position: " + this._pos);
                }
                stringBuffer.append(c);
                ++this._pos;
                c = this._queryString.charAt(this._pos);
            }
            stringBuffer.append(c);
            ++this._pos;
            return new Token(38, stringBuffer.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidCharException("End of query encountered in the middle of time literal.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Token timeStampLiteral(String string) throws InvalidCharException {
        StringBuffer stringBuffer = new StringBuffer(string);
        char c = this.getChar();
        try {
            c = this._queryString.charAt(this._pos);
            c = this.consumeWhiteSpace(c);
            if (c != '\'') {
                throw new InvalidCharException("The timestamp keyword must be followed by a single quote.  Position: " + this._pos);
            }
            stringBuffer.append(" '");
            ++this._pos;
            c = this._queryString.charAt(this._pos);
            c = this.consumeWhiteSpace(c);
            if (!this.isDigit(c)) {
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
            }
            while (true) {
                if (!this.isDigit(c)) {
                    if ((c = this.consumeWhiteSpace(c)) == '-') break;
                    throw new InvalidCharException("- expected.  Fields in date part of timestamp literal must be separated by a dash.  Position: " + this._pos);
                }
                stringBuffer.append(c);
                ++this._pos;
                c = this._queryString.charAt(this._pos);
            }
            stringBuffer.append(c);
            ++this._pos;
            c = this._queryString.charAt(this._pos);
            c = this.consumeWhiteSpace(c);
            if (!this.isDigit(c)) {
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
            }
            while (true) {
                if (!this.isDigit(c)) {
                    if ((c = this.consumeWhiteSpace(c)) == '-') break;
                    throw new InvalidCharException("- expected.  Fields in date part of timestamp literal must be separated by a dash.  Position: " + this._pos);
                }
                stringBuffer.append(c);
                ++this._pos;
                c = this._queryString.charAt(this._pos);
            }
            stringBuffer.append(c);
            ++this._pos;
            c = this._queryString.charAt(this._pos);
            c = this.consumeWhiteSpace(c);
            if (!this.isDigit(c)) {
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
            }
            while (true) {
                if (!this.isDigit(c)) {
                    if (this.isWhiteSpace(c)) break;
                    throw new InvalidCharException("White space expected in timestamp literal.  Position: " + this._pos);
                }
                stringBuffer.append(c);
                ++this._pos;
                c = this._queryString.charAt(this._pos);
            }
            c = this.consumeWhiteSpace(c);
            stringBuffer.append(' ');
            if (!this.isDigit(c)) {
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
            }
            while (true) {
                if (!this.isDigit(c)) {
                    if ((c = this.consumeWhiteSpace(c)) == ':') break;
                    throw new InvalidCharException(": expected.  Fields in time part of timestamp literal must be separated by a colon.  Position: " + this._pos);
                }
                stringBuffer.append(c);
                ++this._pos;
                c = this._queryString.charAt(this._pos);
            }
            stringBuffer.append(c);
            ++this._pos;
            c = this._queryString.charAt(this._pos);
            c = this.consumeWhiteSpace(c);
            if (!this.isDigit(c)) {
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
            }
            while (true) {
                if (!this.isDigit(c)) {
                    if ((c = this.consumeWhiteSpace(c)) == ':') break;
                    throw new InvalidCharException(": expected.  Fields in time part of timestamp literal must be separated by a colon.  Position: " + this._pos);
                }
                stringBuffer.append(c);
                ++this._pos;
                c = this._queryString.charAt(this._pos);
            }
            stringBuffer.append(c);
            ++this._pos;
            c = this._queryString.charAt(this._pos);
            c = this.consumeWhiteSpace(c);
            if (!this.isDigit(c)) {
                throw new InvalidCharException("Digit expected in timestamp literal.  Position: " + this._pos);
            }
            while (true) {
                if (!this.isDigit(c)) {
                    if ((c = this.consumeWhiteSpace(c)) == '\'') break;
                    throw new InvalidCharException("' expected.  Timestamp literal must be enclosed by a single quotes.  Position: " + this._pos);
                }
                stringBuffer.append(c);
                ++this._pos;
                c = this._queryString.charAt(this._pos);
            }
            stringBuffer.append(c);
            ++this._pos;
            return new Token(39, stringBuffer.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidCharException("End of query encountered in the middle of time literal.");
        }
    }
}

