/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import org.exolab.castor.builder.types.XSBinary;
import org.exolab.castor.builder.types.XSBoolean;
import org.exolab.castor.builder.types.XSCData;
import org.exolab.castor.builder.types.XSCentury;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSDate;
import org.exolab.castor.builder.types.XSDecimal;
import org.exolab.castor.builder.types.XSFloat;
import org.exolab.castor.builder.types.XSId;
import org.exolab.castor.builder.types.XSIdRef;
import org.exolab.castor.builder.types.XSInt;
import org.exolab.castor.builder.types.XSInteger;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.builder.types.XSLong;
import org.exolab.castor.builder.types.XSMonth;
import org.exolab.castor.builder.types.XSNCName;
import org.exolab.castor.builder.types.XSNMToken;
import org.exolab.castor.builder.types.XSNegativeInteger;
import org.exolab.castor.builder.types.XSNonNegativeInteger;
import org.exolab.castor.builder.types.XSNonPositiveInteger;
import org.exolab.castor.builder.types.XSPositiveInteger;
import org.exolab.castor.builder.types.XSQName;
import org.exolab.castor.builder.types.XSReal;
import org.exolab.castor.builder.types.XSRecurringDuration;
import org.exolab.castor.builder.types.XSShort;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSTime;
import org.exolab.castor.builder.types.XSTimeDuration;
import org.exolab.castor.builder.types.XSTimeInstant;
import org.exolab.castor.builder.types.XSTimePeriod;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.builder.types.XSUriReference;
import org.exolab.castor.builder.types.XSYear;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;

public class TypeConversion {
    public static XSType convertType(SimpleType simpleType) {
        if (simpleType == null) {
            return null;
        }
        XSClass xSClass = null;
        SimpleType simpleType2 = simpleType;
        while (simpleType2 != null && !simpleType2.isBuiltInType()) {
            simpleType2 = (SimpleType)simpleType2.getBaseType();
        }
        if (simpleType2 == null) {
            String string = JavaNaming.toJavaClassName(simpleType.getName());
            xSClass = new XSClass(new JClass(string));
        } else {
            switch (simpleType2.getTypeCode()) {
                case 10: {
                    return new XSId();
                }
                case 11: {
                    return new XSIdRef();
                }
                case 17: {
                    return new XSList(new XSIdRef());
                }
                case 9: {
                    return new XSUriReference();
                }
                case 22: {
                    return new XSNCName();
                }
                case 19: {
                    return new XSNMToken();
                }
                case 20: {
                    return new XSList(new XSNMToken());
                }
                case 8: {
                    return new XSBinary();
                }
                case 2: {
                    return new XSBoolean();
                }
                case 43: {
                    return new XSCentury();
                }
                case 15: {
                    XSCData xSCData = new XSCData();
                    if (!simpleType.isBuiltInType()) {
                        xSCData.setFacets(simpleType);
                    }
                    return xSCData;
                }
                case 40: {
                    return new XSDate();
                }
                case 4: {
                    XSReal xSReal = new XSReal();
                    if (!simpleType.isBuiltInType()) {
                        xSReal.setFacets(simpleType);
                    }
                    return xSReal;
                }
                case 3: {
                    XSFloat xSFloat = new XSFloat();
                    if (!simpleType.isBuiltInType()) {
                        xSFloat.setFacets(simpleType);
                    }
                    return xSFloat;
                }
                case 23: {
                    XSInteger xSInteger = new XSInteger();
                    if (!simpleType.isBuiltInType()) {
                        xSInteger.setFacets(simpleType);
                    }
                    return xSInteger;
                }
                case 27: {
                    XSInt xSInt = new XSInt();
                    if (!simpleType.isBuiltInType()) {
                        xSInt.setFacets(simpleType);
                    }
                    return xSInt;
                }
                case 26: {
                    XSLong xSLong = new XSLong();
                    if (!simpleType.isBuiltInType()) {
                        xSLong.setFacets(simpleType);
                    }
                    return xSLong;
                }
                case 41: {
                    return new XSMonth();
                }
                case 24: {
                    XSNonPositiveInteger xSNonPositiveInteger = new XSNonPositiveInteger();
                    xSNonPositiveInteger.setFacets(simpleType);
                    return xSNonPositiveInteger;
                }
                case 30: {
                    XSNonNegativeInteger xSNonNegativeInteger = new XSNonNegativeInteger();
                    xSNonNegativeInteger.setFacets(simpleType);
                    return xSNonNegativeInteger;
                }
                case 25: {
                    XSNegativeInteger xSNegativeInteger = new XSNegativeInteger();
                    xSNegativeInteger.setFacets(simpleType);
                    return xSNegativeInteger;
                }
                case 35: {
                    XSPositiveInteger xSPositiveInteger = new XSPositiveInteger();
                    xSPositiveInteger.setFacets(simpleType);
                    return xSPositiveInteger;
                }
                case 13: {
                    XSQName xSQName = new XSQName();
                    xSQName.setFacets(simpleType);
                    return xSQName;
                }
                case 7: {
                    XSRecurringDuration xSRecurringDuration = new XSRecurringDuration();
                    xSRecurringDuration.setFacets(simpleType);
                    if (xSRecurringDuration.getDuration() == null || xSRecurringDuration.getPeriod() == null) {
                        String string = "It is an error for recurringDuration to be";
                        string = String.valueOf(string) + " used directly in a Schema \n";
                        string = String.valueOf(string) + "you must set the duration facet AND the period one";
                        System.out.println(string);
                        return null;
                    }
                    return xSRecurringDuration;
                }
                case 1: {
                    XSString xSString = new XSString();
                    if (!simpleType.isBuiltInType()) {
                        xSString.setFacets(simpleType);
                    }
                    return xSString;
                }
                case 37: {
                    return new XSTime();
                }
                case 36: {
                    return new XSTimeInstant();
                }
                case 6: {
                    XSTimeDuration xSTimeDuration = new XSTimeDuration();
                    if (!simpleType.isBuiltInType()) {
                        xSTimeDuration.setFacets(simpleType);
                    }
                    return xSTimeDuration;
                }
                case 38: {
                    XSTimePeriod xSTimePeriod = new XSTimePeriod();
                    if (!simpleType.isBuiltInType()) {
                        xSTimePeriod.setFacets(simpleType);
                    }
                    return xSTimePeriod;
                }
                case 42: {
                    return new XSYear();
                }
                case 5: {
                    XSDecimal xSDecimal = new XSDecimal();
                    if (!simpleType.isBuiltInType()) {
                        xSDecimal.setFacets(simpleType);
                    }
                    return xSDecimal;
                }
                case 28: {
                    XSShort xSShort = new XSShort();
                    xSShort.setFacets(simpleType);
                    return xSShort;
                }
            }
            String string = "Warning: The W3C datatype " + simpleType.getName();
            string = String.valueOf(string) + " is not currently supported by Castor Source Generator.";
            System.out.println(string);
            String string2 = JavaNaming.toJavaClassName(simpleType.getName());
            xSClass = new XSClass(new JClass(string2));
        }
        return xSClass;
    }
}

