/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.exolab.castor.builder.ClassInfo;
import org.exolab.castor.builder.ClassInfoResolver;
import org.exolab.castor.builder.DescriptorSourceFactory;
import org.exolab.castor.builder.FieldInfoFactory;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.SourceFactory;
import org.exolab.castor.builder.util.ConsoleDialog;
import org.exolab.castor.util.CommandLineOptions;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JComment;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SourceGenerator {
    static final String appName = "Castor";
    static final String appDesc = "XML data binder for Java";
    static final String version = "0.9";
    static final String appURI = "http://castor.exolab.org";
    private static final String DEFAULT_HEADER = "This class was automatically generated with \n<a href=\"http://castor.exolab.org\">Castor 0.9</a>, using an XML Schema.\n$Id$";
    private static final String DISABLE_DESCRIPTORS_MSG = "Disabling generation of Class descriptors";
    private static final String DISABLE_MARSHALL_MSG = "Disabling generation of Marshalling framework methods (marshall, unmarshall, validate).";
    private String lineSeparator = null;
    private JComment header = null;
    private boolean warnOnOverwrite = true;
    private boolean verbose = false;
    private String destDir = null;
    private boolean _createDescriptors = true;
    private boolean _createMarshall = true;
    private FieldInfoFactory infoFactory = null;
    private SourceFactory sourceFactory = null;
    private ConsoleDialog dialog = new ConsoleDialog();
    private static final String ELEMENT_VALUE = "element";
    private static final String TYPE_VALUE = "type";
    private static final int ELEMENT_BINDING = 0;
    private static final int TYPE_BINDING = 1;
    private static int _bindingType = 0;
    private static boolean _boundProperties = false;
    private static Properties _default;
    private static Hashtable _nspackages;

    public SourceGenerator() {
        this(null);
    }

    public SourceGenerator(FieldInfoFactory fieldInfoFactory) {
        this.infoFactory = fieldInfoFactory == null ? new FieldInfoFactory() : fieldInfoFactory;
        this.sourceFactory = new SourceFactory(fieldInfoFactory);
        this.header = new JComment(3);
        this.header.appendComment(DEFAULT_HEADER);
    }

    public static boolean boundPropertiesEnabled() {
        SourceGenerator.getDefault();
        return _boundProperties;
    }

    private void createClasses(ElementDecl elementDecl, SGStateInfo sGStateInfo) {
        XMLType xMLType;
        if (SourceGenerator.mappingSchemaType2Java() && (elementDecl.isReference() || elementDecl.getType() != null && elementDecl.getType().getName() != null)) {
            return;
        }
        if (sGStateInfo.verbose()) {
            System.out.print("Creating classes for element: ");
            System.out.println(elementDecl.getName());
        }
        if ((xMLType = elementDecl.getType()) == null) {
            System.out.print("Type not found for element: ");
            System.out.println(elementDecl.getName());
            return;
        }
        if (xMLType.isComplexType()) {
            JClass jClass = this.sourceFactory.createSourceCode(elementDecl, (ClassInfoResolver)sGStateInfo, sGStateInfo.packageName);
            this.processComplexType((ComplexType)xMLType, sGStateInfo);
            this.processJClass(jClass, sGStateInfo);
        } else {
            this.processSimpleType((SimpleType)xMLType, sGStateInfo);
        }
    }

    private void createClasses(Schema schema, SGStateInfo sGStateInfo) {
        Enumeration enumeration = schema.getElementDecls();
        while (enumeration.hasMoreElements()) {
            this.createClasses((ElementDecl)enumeration.nextElement(), sGStateInfo);
        }
        enumeration = schema.getComplexTypes();
        while (enumeration.hasMoreElements()) {
            this.processComplexType((ComplexType)enumeration.nextElement(), sGStateInfo);
        }
        enumeration = schema.getSimpleTypes();
        while (enumeration.hasMoreElements()) {
            this.processSimpleType((SimpleType)enumeration.nextElement(), sGStateInfo);
        }
    }

    public void generateSource(Reader reader, String string) {
        InputSource inputSource = new InputSource(reader);
        this.generateSource(inputSource, string);
    }

    public void generateSource(String string, String string2) throws FileNotFoundException {
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        FileReader fileReader = new FileReader(string);
        InputSource inputSource = new InputSource(fileReader);
        inputSource.setSystemId(SourceGenerator.toURIRepresentation(new File(string).getAbsolutePath()));
        this.generateSource(inputSource, string2);
        try {
            fileReader.close();
        }
        catch (IOException iOException) {}
    }

    public void generateSource(Schema schema, String string) {
        SGStateInfo sGStateInfo = new SGStateInfo();
        sGStateInfo.packageName = string;
        if (sGStateInfo.packageName == null) {
            sGStateInfo.packageName = SourceGenerator.getJavaPackage(schema.getTargetNamespace());
        }
        sGStateInfo.setPromptForOverwrite(this.warnOnOverwrite);
        sGStateInfo.setVerbose(this.verbose);
        this.createClasses(schema, sGStateInfo);
    }

    public void generateSource(InputSource inputSource, String string) {
        Parser parser = null;
        try {
            parser = Configuration.getParser();
        }
        catch (RuntimeException runtimeException) {}
        if (parser == null) {
            System.out.println("fatal error: unable to create SAX parser.");
            return;
        }
        SchemaUnmarshaller schemaUnmarshaller = null;
        try {
            schemaUnmarshaller = new SchemaUnmarshaller();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        parser.setDocumentHandler(schemaUnmarshaller);
        parser.setErrorHandler(schemaUnmarshaller);
        try {
            parser.parse(inputSource);
        }
        catch (IOException iOException) {
            System.out.println("error reading XML Schema file");
            return;
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception == null) {
                exception = sAXException;
            }
            if (exception instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)exception;
                System.out.println("SAXParseException: " + sAXParseException);
                System.out.print(" - occured at line ");
                System.out.print(sAXParseException.getLineNumber());
                System.out.print(", column ");
                System.out.println(sAXParseException.getColumnNumber());
            } else {
                exception.printStackTrace();
            }
            return;
        }
        Schema schema = schemaUnmarshaller.getSchema();
        this.generateSource(schema, string);
    }

    public static synchronized Properties getDefault() {
        if (_default == null) {
            SourceGenerator.load();
        }
        return _default;
    }

    public static String getJavaPackage(String string) {
        if (string == null) {
            return "";
        }
        SourceGenerator.getDefault();
        String string2 = (String)_nspackages.get(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public static String getProperty(String string, String string2) {
        return SourceGenerator.getDefault().getProperty(string, string2);
    }

    public static String getQualifiedClassName(String string, String string2) {
        SourceGenerator.getDefault();
        String string3 = SourceGenerator.getJavaPackage(string);
        if (string3.length() > 0) {
            string3 = String.valueOf(string3) + '.';
        }
        return String.valueOf(string3) + string2;
    }

    public static String getVersion() {
        return version;
    }

    protected static void initBindingType() {
        String string = SourceGenerator.getDefault().getProperty("org.exolab.castor.builder.javaclassmapping", ELEMENT_VALUE);
        if (string.toLowerCase().equals(TYPE_VALUE)) {
            _bindingType = 1;
        }
    }

    protected static void load() {
        _default = Configuration.loadProperties("/org/exolab/castor/builder/castorbuilder.properties", "castorbuilder.properties");
        _nspackages = new Hashtable();
        String string = _default.getProperty("org.exolab.castor.builder.nspackages", "");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            _nspackages.put(string3, string4);
        }
        string = _default.getProperty("org.exolab.castor.builder.boundproperties", "");
        _boundProperties = string.equalsIgnoreCase("true");
        SourceGenerator.initBindingType();
    }

    public static void main(String[] stringArray) {
        boolean bl;
        CommandLineOptions commandLineOptions = new CommandLineOptions();
        commandLineOptions.addFlag("i", "filename", "Sets the input filename");
        commandLineOptions.addFlag("package", "package-name", "Sets the package name", true);
        String string = "Sets the destination output directory";
        commandLineOptions.addFlag("dest", "dest-dir", string, true);
        string = "Sets the line separator style for the desired platform";
        commandLineOptions.addFlag("line-separator", "( unix | mac | win)", string, true);
        string = "Suppresses non fatal warnings, such as overwriting files.";
        commandLineOptions.addFlag("f", "", string, true);
        string = "Displays this help screen.";
        commandLineOptions.addFlag("h", "", string, true);
        string = "Prints out additional messages when creaing source";
        commandLineOptions.addFlag("verbose", "", string, true);
        string = "Disables the generation of the Class descriptors";
        commandLineOptions.addFlag("nodesc", "", string, true);
        string = "Sets the source generator types name (SGTypeFactory)";
        commandLineOptions.addFlag("types", "types", string, true);
        commandLineOptions.addFlag("type-factory", "classname", "", true);
        string = "Disables the generation of the methods specific to the XML marshalling framework";
        commandLineOptions.addFlag("nomarshall", "", string, true);
        Properties properties = commandLineOptions.getOptions(stringArray);
        if (properties.getProperty("h") != null) {
            PrintWriter printWriter = new PrintWriter(System.out, true);
            commandLineOptions.printHelp(printWriter);
            printWriter.flush();
            return;
        }
        String string2 = properties.getProperty("i");
        String string3 = properties.getProperty("package");
        String string4 = properties.getProperty("line-separator");
        boolean bl2 = properties.getProperty("f") != null;
        String string5 = properties.getProperty("types");
        boolean bl3 = bl = properties.getProperty("verbose") != null;
        if (string2 == null) {
            System.out.println(appName);
            commandLineOptions.printUsage(new PrintWriter(System.out));
            return;
        }
        if (string5 == null) {
            string5 = properties.getProperty("type-factory");
        }
        String string6 = System.getProperty("line.separator");
        if (string4 != null) {
            if ("win".equals(string4)) {
                System.out.println(" - using Windows style line separation.");
                string6 = "\r\n";
            } else if ("unix".equals(string4)) {
                System.out.println(" - using UNIX style line separation.");
                string6 = "\n";
            } else if ("mac".equals(string4)) {
                System.out.println(" - using Macintosh style line separation.");
                string6 = "\r";
            } else {
                System.out.print("- invalid option for line-separator: ");
                System.out.println(string4);
                System.out.println("-- using default line separator for this platform");
            }
        }
        SourceGenerator sourceGenerator = null;
        if (string5 != null) {
            string5 = Configuration.getProperty("org.exolab.castor.builder.type." + string5.toLowerCase(), string5);
            try {
                sourceGenerator = new SourceGenerator((FieldInfoFactory)Class.forName(string5).newInstance());
            }
            catch (Exception exception) {
                System.out.print("- invalid option for types: ");
                System.out.println(string5);
                System.out.println(exception);
                System.out.println("-- using default source generator types");
                sourceGenerator = new SourceGenerator();
            }
        } else {
            sourceGenerator = new SourceGenerator();
        }
        sourceGenerator.setDestDir(properties.getProperty("dest"));
        sourceGenerator.setLineSeparator(string6);
        sourceGenerator.setSuppressNonFatalWarnings(bl2);
        sourceGenerator.setVerbose(bl);
        if (bl2) {
            System.out.println("-- Suppressing non fatal warnings.");
        }
        if (properties.getProperty("nodesc") != null) {
            sourceGenerator.setDescriptorCreation(false);
            System.out.print("-- ");
            System.out.println(DISABLE_DESCRIPTORS_MSG);
        }
        if (properties.getProperty("nomarshall") != null) {
            sourceGenerator.sourceFactory.setMarshallCreation(false);
            System.out.print("-- ");
            System.out.println(DISABLE_MARSHALL_MSG);
        }
        try {
            sourceGenerator.generateSource(string2, string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("unable to open XML schema file");
            return;
        }
    }

    public static boolean mappingSchemaElement2Java() {
        SourceGenerator.getDefault();
        return _bindingType == 0;
    }

    public static boolean mappingSchemaType2Java() {
        SourceGenerator.getDefault();
        return _bindingType == 1;
    }

    private void processAttributes(ComplexType complexType, SGStateInfo sGStateInfo) {
        if (complexType == null) {
            return;
        }
        Enumeration enumeration = complexType.getAttributeDecls();
        while (enumeration.hasMoreElements()) {
            AttributeDecl attributeDecl = (AttributeDecl)enumeration.nextElement();
            this.processSimpleType(attributeDecl.getSimpleType(), sGStateInfo);
        }
    }

    private void processComplexType(ComplexType complexType, SGStateInfo sGStateInfo) {
        if (complexType == null) {
            return;
        }
        ClassInfo classInfo = sGStateInfo.resolve(complexType);
        if (classInfo == null) {
            Object object;
            if (complexType.isTopLevel()) {
                object = this.sourceFactory.createSourceCode(complexType, (ClassInfoResolver)sGStateInfo, sGStateInfo.packageName);
                this.processJClass((JClass)object, sGStateInfo);
            }
            if ((object = complexType.getBaseType()) != null && ((XMLType)object).getSchema() == complexType.getSchema() && ((XMLType)object).isComplexType()) {
                this.processComplexType((ComplexType)object, sGStateInfo);
            }
            this.processAttributes(complexType, sGStateInfo);
            this.processContentModel(complexType, sGStateInfo);
        } else {
            JClass jClass = classInfo.getJClass();
            if (!sGStateInfo.processed(jClass)) {
                this.processAttributes(complexType, sGStateInfo);
                this.processContentModel(complexType, sGStateInfo);
                this.processJClass(jClass, sGStateInfo);
            }
        }
    }

    private void processContentModel(ContentModelGroup contentModelGroup, SGStateInfo sGStateInfo) {
        Enumeration enumeration = contentModelGroup.enumerate();
        while (enumeration.hasMoreElements()) {
            Structure structure = (Structure)enumeration.nextElement();
            switch (structure.getStructureType()) {
                case 7: {
                    ElementDecl elementDecl = (ElementDecl)structure;
                    if (elementDecl.isReference()) break;
                    this.createClasses(elementDecl, sGStateInfo);
                    break;
                }
                case 9: {
                    this.processContentModel((Group)structure, sGStateInfo);
                    break;
                }
            }
        }
    }

    private void processJClass(JClass jClass, SGStateInfo sGStateInfo) {
        String string;
        Object object;
        Object object2;
        boolean bl = true;
        if (sGStateInfo.promptForOverwrite() && ((File)(object2 = new File((String)(object = jClass.getFilename(this.destDir))))).exists()) {
            string = String.valueOf(object) + " already exists. overwrite?";
            bl = this.dialog.confirm(string);
        }
        if (bl) {
            jClass.removeImport("org.exolab.castor.types.Date");
            jClass.setHeader(this.header);
            jClass.print(this.destDir, this.lineSeparator);
        }
        object = sGStateInfo.resolve(jClass);
        if (this._createDescriptors && object != null) {
            File file;
            object2 = DescriptorSourceFactory.createSource((ClassInfo)object);
            bl = true;
            if (sGStateInfo.promptForOverwrite() && (file = new File(string = ((JClass)object2).getFilename(this.destDir))).exists()) {
                String string2 = String.valueOf(string) + " already exists. overwrite?";
                bl = this.dialog.confirm(string2);
            }
            if (bl) {
                ((JClass)object2).setHeader(this.header);
                ((JClass)object2).print(this.destDir, this.lineSeparator);
            }
        }
        sGStateInfo.markAsProcessed(jClass);
    }

    private void processSimpleType(SimpleType simpleType, SGStateInfo sGStateInfo) {
        if (simpleType == null) {
            return;
        }
        String string = sGStateInfo.packageName;
        if (simpleType.hasFacet("enumeration")) {
            ClassInfo classInfo = sGStateInfo.resolve(simpleType);
            if (classInfo == null) {
                JClass jClass = this.sourceFactory.createSourceCode(simpleType, (ClassInfoResolver)sGStateInfo, string);
                this.processJClass(jClass, sGStateInfo);
            } else {
                JClass jClass = classInfo.getJClass();
                if (!sGStateInfo.processed(jClass)) {
                    this.processJClass(jClass, sGStateInfo);
                }
            }
        }
    }

    public void setDefaultProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        _default = properties;
    }

    public void setDescriptorCreation(boolean bl) {
        this._createDescriptors = bl;
    }

    public void setDestDir(String string) {
        this.destDir = string;
    }

    public void setLineSeparator(String string) {
        this.lineSeparator = string;
    }

    public void setMarshallCreation(boolean bl) {
        if (this.sourceFactory != null) {
            this.sourceFactory.setMarshallCreation(bl);
        }
    }

    public void setSuppressNonFatalWarnings(boolean bl) {
        this.warnOnOverwrite = bl ^ true;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public static String toURIRepresentation(String string) {
        String string2 = string;
        if (!new File(string2).isAbsolute()) {
            throw new IllegalArgumentException("The parameter must represent an absolute path.");
        }
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        string2 = string2.startsWith("/") ? "file://" + string2 : "file:///" + string2;
        return string2;
    }

    public static class Property {
        public static final String BOUND_PROPERTIES = "org.exolab.castor.builder.boundproperties";
        public static final String SUPER_CLASS = "org.exolab.castor.builder.superclass";
        public static final String JavaClassMapping = "org.exolab.castor.builder.javaclassmapping";
        public static final String NamespacePackages = "org.exolab.castor.builder.nspackages";
        public static final String FileName = "castorbuilder.properties";
        static final String ResourceName = "/org/exolab/castor/builder/castorbuilder.properties";
    }
}

