/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Section {
    private String[] section;
    private static final String DELIMETER = ".";
    private static final String PARSE_SECTION_ERROR = "Section token cannot be longer than one character";
    private static final String GET_SECTION_INDEX_ERROR = "Section index too large";
    private static final String CONSTRUCTION_ERROR = "Cannot parse section string";

    public Section(String id) {
        try {
            this.section = this.parseSection(id);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(CONSTRUCTION_ERROR);
        }
    }

    public String getSection() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.section.length) {
            buffer.append(this.section[i]);
            if (i + 1 < this.section.length) {
                buffer.append(DELIMETER);
            }
            ++i;
        }
        return buffer.toString();
    }

    public String getSectionToken(int index) {
        if (this.section.length >= index) {
            throw new IndexOutOfBoundsException(GET_SECTION_INDEX_ERROR);
        }
        return this.section[index];
    }

    public Iterator getSectionTokens() {
        return Collections.unmodifiableList(Arrays.asList(this.section)).iterator();
    }

    private String[] parseSection(String id) throws ParseException {
        StringTokenizer tokenizer = new StringTokenizer(id, DELIMETER);
        int count = tokenizer.countTokens();
        String[] token = new String[count];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String str;
            token[i] = str = tokenizer.nextToken();
            ++i;
        }
        return token;
    }

    public String toString() {
        return this.getSection();
    }
}

