/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.security.auth.login.Configuration;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityDomain;
import org.jboss.security.SecurityProxyFactory;
import org.jboss.security.plugins.JaasSecurityManagerServiceMBean;
import org.jboss.security.plugins.SecurityDomainContext;
import org.jboss.util.CachePolicy;
import org.jboss.util.ServiceMBeanSupport;
import org.jboss.util.TimedCachePolicy;

public class JaasSecurityManagerService
extends ServiceMBeanSupport
implements JaasSecurityManagerServiceMBean {
    private static final String SECURITY_MGR_PATH = "java:/jaas";
    private static final String DEFAULT_CACHE_POLICY_PATH = "java:/timedCacheFactory";
    private static Logger log;
    private static String securityMgrClassName;
    private static Class securityMgrClass;
    private static String cacheJndiName;
    private static int defaultCacheTimeout;
    private static int defaultCacheResolution;
    private static String securityProxyFactoryClassName;
    private static Class securityProxyFactoryClass;
    private static Hashtable securityDomainCtxMap;
    private static String loginConfigName;
    private static Stack loginConfigStack;
    private static NameParser parser;
    private static MBeanServer server;
    static /* synthetic */ Class class$org$jboss$security$SubjectSecurityProxyFactory;
    static /* synthetic */ Class class$org$jboss$security$plugins$JaasSecurityManagerService;
    static /* synthetic */ Class class$org$jboss$security$AuthenticationManager;
    static /* synthetic */ Class class$org$jboss$security$plugins$JaasSecurityManagerService$SecurityDomainObjectFactory;
    static /* synthetic */ Class class$org$jboss$security$plugins$JaasSecurityManagerService$DefaultCacheObjectFactory;

    public String getSecurityManagerClassName() {
        return securityMgrClassName;
    }

    public void setSecurityManagerClassName(String className) throws ClassNotFoundException, ClassCastException {
        ClassLoader loader;
        securityMgrClassName = className;
        if (!(class$org$jboss$security$AuthenticationManager == null ? (class$org$jboss$security$AuthenticationManager = JaasSecurityManagerService.class$("org.jboss.security.AuthenticationManager")) : class$org$jboss$security$AuthenticationManager).isAssignableFrom(securityMgrClass = (loader = Thread.currentThread().getContextClassLoader()).loadClass(securityMgrClassName))) {
            throw new ClassCastException(securityMgrClass + " does not implement " + (class$org$jboss$security$AuthenticationManager == null ? (class$org$jboss$security$AuthenticationManager = JaasSecurityManagerService.class$("org.jboss.security.AuthenticationManager")) : class$org$jboss$security$AuthenticationManager));
        }
    }

    public String getSecurityProxyFactoryClassName() {
        return securityProxyFactoryClassName;
    }

    public void setSecurityProxyFactoryClassName(String className) throws ClassNotFoundException {
        securityProxyFactoryClassName = className;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        securityProxyFactoryClass = loader.loadClass(securityProxyFactoryClassName);
    }

    public String getAuthenticationCacheJndiName() {
        return cacheJndiName;
    }

    public void setAuthenticationCacheJndiName(String jndiName) {
        cacheJndiName = jndiName;
    }

    public int getDefaultCacheTimeout() {
        return defaultCacheTimeout;
    }

    public void setDefaultCacheTimeout(int timeoutInSecs) {
        defaultCacheTimeout = timeoutInSecs;
    }

    public int getDefaultCacheResolution() {
        return defaultCacheResolution;
    }

    public void setDefaultCacheResolution(int resInSecs) {
        defaultCacheResolution = resInSecs;
    }

    public void flushAuthenticationCache(String securityDomain) {
        SecurityDomainContext securityDomainCtx = (SecurityDomainContext)securityDomainCtxMap.get(securityDomain);
        if (securityDomainCtx != null) {
            CachePolicy cache = securityDomainCtx.getAuthenticationCache();
            if (cache != null) {
                cache.flush();
            }
        } else {
            log.error((Object)("Failed to find cache policy for securityDomain='" + securityDomain + "'"));
        }
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        JaasSecurityManagerService.server = server;
        return name == null ? new ObjectName("Security:name=JaasSecurityManager") : name;
    }

    public String getName() {
        return "JaasSecurityManagerService";
    }

    public String getLoginConfig() {
        return loginConfigName;
    }

    public void setLoginConfig(String name) throws MalformedObjectNameException {
        loginConfigName = name;
    }

    public synchronized void pushLoginConfig(String objectName) throws JMException, MalformedObjectNameException {
        ObjectName name = new ObjectName(objectName);
        Configuration prevConfig = null;
        if (!loginConfigStack.empty()) {
            ConfigInfo prevInfo = (ConfigInfo)loginConfigStack.peek();
            prevConfig = prevInfo.config;
        }
        ConfigInfo info = this.installConfig(name, prevConfig);
        loginConfigStack.push(info);
    }

    public synchronized void popLoginConfig() throws JMException {
        ConfigInfo info = (ConfigInfo)loginConfigStack.pop();
        Configuration prevConfig = null;
        if (!loginConfigStack.empty()) {
            ConfigInfo prevInfo = (ConfigInfo)loginConfigStack.peek();
            prevConfig = prevInfo.config;
        }
        this.installConfig(info.name, prevConfig);
    }

    protected void startService() throws Exception {
        boolean debug = log.isDebugEnabled();
        InitialContext ctx = new InitialContext();
        parser = ctx.getNameParser("");
        StringRefAddr refAddr = new StringRefAddr("nns", "JSM");
        String factoryName = (class$org$jboss$security$plugins$JaasSecurityManagerService$SecurityDomainObjectFactory == null ? (class$org$jboss$security$plugins$JaasSecurityManagerService$SecurityDomainObjectFactory = JaasSecurityManagerService.class$("org.jboss.security.plugins.JaasSecurityManagerService$SecurityDomainObjectFactory")) : class$org$jboss$security$plugins$JaasSecurityManagerService$SecurityDomainObjectFactory).getName();
        Reference ref = new Reference("javax.naming.Context", refAddr, factoryName, null);
        ctx.rebind(SECURITY_MGR_PATH, (Object)ref);
        log.debug((Object)"securityMgrCtxPath=java:/jaas");
        refAddr = new StringRefAddr("nns", "JSMCachePolicy");
        factoryName = (class$org$jboss$security$plugins$JaasSecurityManagerService$DefaultCacheObjectFactory == null ? (class$org$jboss$security$plugins$JaasSecurityManagerService$DefaultCacheObjectFactory = JaasSecurityManagerService.class$("org.jboss.security.plugins.JaasSecurityManagerService$DefaultCacheObjectFactory")) : class$org$jboss$security$plugins$JaasSecurityManagerService$DefaultCacheObjectFactory).getName();
        ref = new Reference("javax.naming.Context", refAddr, factoryName, null);
        ctx.rebind(DEFAULT_CACHE_POLICY_PATH, (Object)ref);
        log.debug((Object)("cachePolicyCtxPath=" + cacheJndiName));
        SecurityProxyFactory proxyFactory = (SecurityProxyFactory)securityProxyFactoryClass.newInstance();
        ctx.bind("java:/SecurityProxyFactory", (Object)proxyFactory);
        log.debug((Object)("SecurityProxyFactory=" + proxyFactory));
        this.pushLoginConfig(loginConfigName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopService() throws Exception {
        block5: {
            InitialContext ic = new InitialContext();
            try {
                try {
                    ic.unbind(SECURITY_MGR_PATH);
                }
                catch (CommunicationException e) {
                    Object var4_3 = null;
                    ic.close();
                    break block5;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ic.close();
                throw throwable;
            }
            ic.close();
        }
        if (!loginConfigStack.empty()) {
            this.popLoginConfig();
        }
    }

    public void registerSecurityDomain(String securityDomain, SecurityDomain instance) {
        CachePolicy authCache = JaasSecurityManagerService.getCachePolicy(securityDomain);
        SecurityDomainContext sdc = new SecurityDomainContext(instance, authCache);
        securityDomainCtxMap.put(securityDomain, sdc);
        log.info((Object)("Added " + securityDomain + ", " + instance + " to map"));
    }

    private ConfigInfo installConfig(ObjectName name, Configuration prevConfig) throws JMException {
        MBeanServer server = super.getServer();
        Object[] args = new Object[]{prevConfig};
        String[] signature = new String[]{"javax.security.auth.login.Configuration"};
        Configuration config = (Configuration)server.invoke(name, "getConfiguration", args, signature);
        Configuration.setConfiguration(config);
        ConfigInfo info = new ConfigInfo(name, config);
        log.debug((Object)("Installed JAAS Configuration service=" + name + ", config=" + config));
        return info;
    }

    private static CachePolicy getCachePolicy(String securityDomain) {
        CachePolicy authCache = null;
        String domainCachePath = cacheJndiName + '/' + securityDomain;
        try {
            InitialContext iniCtx = new InitialContext();
            authCache = (CachePolicy)iniCtx.lookup(domainCachePath);
        }
        catch (Exception e) {
            try {
                InitialContext iniCtx = new InitialContext();
                authCache = (CachePolicy)iniCtx.lookup(cacheJndiName);
            }
            catch (Exception e2) {
                log.warn((Object)("Failed to locate auth CachePolicy at: " + cacheJndiName + " for securityDomain=" + securityDomain));
            }
        }
        return authCache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        securityMgrClassName = "org.jboss.security.plugins.JaasSecurityManager";
        cacheJndiName = DEFAULT_CACHE_POLICY_PATH;
        defaultCacheTimeout = 1800;
        defaultCacheResolution = 60;
        securityProxyFactoryClassName = "org.jboss.security.SubjectSecurityProxyFactory";
        securityProxyFactoryClass = class$org$jboss$security$SubjectSecurityProxyFactory == null ? (class$org$jboss$security$SubjectSecurityProxyFactory = JaasSecurityManagerService.class$("org.jboss.security.SubjectSecurityProxyFactory")) : class$org$jboss$security$SubjectSecurityProxyFactory;
        securityDomainCtxMap = new Hashtable();
        loginConfigName = "Security:name=DefaultLoginConfig";
        loginConfigStack = new Stack();
        SecurityAssociation.setServer();
        log = Logger.getLogger((Class)(class$org$jboss$security$plugins$JaasSecurityManagerService == null ? (class$org$jboss$security$plugins$JaasSecurityManagerService = JaasSecurityManagerService.class$("org.jboss.security.plugins.JaasSecurityManagerService")) : class$org$jboss$security$plugins$JaasSecurityManagerService));
    }

    public static class DefaultCacheObjectFactory
    implements InvocationHandler,
    ObjectFactory {
        static /* synthetic */ Class class$javax$naming$Context;

        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class[] interfaces = new Class[]{class$javax$naming$Context == null ? (class$javax$naming$Context = DefaultCacheObjectFactory.class$("javax.naming.Context")) : class$javax$naming$Context};
            Context ctx = (Context)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)this);
            return ctx;
        }

        public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
            TimedCachePolicy cachePolicy = new TimedCachePolicy(defaultCacheTimeout, true, defaultCacheResolution);
            cachePolicy.init();
            cachePolicy.start();
            return cachePolicy;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class DomainEnumeration
    implements NamingEnumeration {
        Enumeration domains;
        Hashtable ctxMap;

        DomainEnumeration(Enumeration domains, Hashtable ctxMap) {
            this.domains = domains;
            this.ctxMap = ctxMap;
        }

        public void close() {
        }

        public boolean hasMoreElements() {
            return this.domains.hasMoreElements();
        }

        public boolean hasMore() {
            return this.domains.hasMoreElements();
        }

        public Object next() {
            String name = (String)this.domains.nextElement();
            Object value = this.ctxMap.get(name);
            String className = value.getClass().getName();
            NameClassPair pair = new NameClassPair(name, className);
            return pair;
        }

        public Object nextElement() {
            return this.domains.nextElement();
        }
    }

    public static class SecurityDomainObjectFactory
    implements InvocationHandler,
    ObjectFactory {
        static /* synthetic */ Class class$javax$naming$Context;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$org$jboss$util$CachePolicy;

        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class[] interfaces = new Class[]{class$javax$naming$Context == null ? (class$javax$naming$Context = SecurityDomainObjectFactory.class$("javax.naming.Context")) : class$javax$naming$Context};
            Context ctx = (Context)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)this);
            return ctx;
        }

        private SecurityDomainContext newSecurityDomainCtx(String securityDomain) throws NamingException {
            SecurityDomainContext sdc = null;
            try {
                Class[] parameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SecurityDomainObjectFactory.class$("java.lang.String")) : class$java$lang$String};
                Constructor ctor = securityMgrClass.getConstructor(parameterTypes);
                Object[] args = new Object[]{securityDomain};
                ObjectName name = new ObjectName(server.getDefaultDomain(), "securityDomain", securityDomain);
                AuthenticationManager securityMgr = (AuthenticationManager)ctor.newInstance(args);
                log.info((Object)("Created securityMgr=" + securityMgr));
                CachePolicy cachePolicy = JaasSecurityManagerService.getCachePolicy(securityDomain);
                sdc = new SecurityDomainContext(securityMgr, cachePolicy);
                try {
                    parameterTypes[0] = class$org$jboss$util$CachePolicy == null ? (class$org$jboss$util$CachePolicy = SecurityDomainObjectFactory.class$("org.jboss.util.CachePolicy")) : class$org$jboss$util$CachePolicy;
                    Method m = securityMgrClass.getMethod("setCachePolicy", parameterTypes);
                    args[0] = cachePolicy;
                    log.info((Object)("setCachePolicy, c=" + args[0]));
                    m.invoke((Object)securityMgr, args);
                }
                catch (Exception e2) {}
            }
            catch (Exception e2) {
                log.error((Object)"Failed to create sec mgr", (Throwable)e2);
                throw new NamingException("Failed to create sec mgr:" + e2.getMessage());
            }
            return sdc;
        }

        public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("toString")) {
                return "java:/jaas Context proxy";
            }
            if (methodName.equals("list")) {
                return new DomainEnumeration(securityDomainCtxMap.keys(), securityDomainCtxMap);
            }
            if (!methodName.equals("lookup")) {
                throw new OperationNotSupportedException("Only lookup is supported, op=" + method);
            }
            String securityDomain = null;
            Name name = null;
            name = args[0] instanceof String ? parser.parse((String)args[0]) : (Name)args[0];
            securityDomain = name.get(0);
            SecurityDomainContext securityDomainCtx = (SecurityDomainContext)securityDomainCtxMap.get(securityDomain);
            if (securityDomainCtx == null) {
                securityDomainCtx = this.newSecurityDomainCtx(securityDomain);
                securityDomainCtxMap.put(securityDomain, securityDomainCtx);
                log.info((Object)("Added " + securityDomain + ", " + securityDomainCtx + " to map"));
            }
            Object binding = securityDomainCtx.getSecurityManager();
            if (name.size() == 2) {
                String request = name.get(1);
                binding = securityDomainCtx.lookup(request);
            }
            return binding;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class ConfigInfo {
        ObjectName name;
        Configuration config;

        ConfigInfo(ObjectName name, Configuration config) {
            this.name = name;
            this.config = config;
        }
    }
}

