/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.Logger;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SubjectSecurityManager;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.util.CachePolicy;

public class JaasSecurityManager
implements SubjectSecurityManager,
RealmMapping {
    private String securityDomain;
    private CachePolicy domainCache;
    protected Logger log;
    static /* synthetic */ Class class$java$security$acl$Group;
    static /* synthetic */ Class class$java$security$Principal;

    public static Subject getActiveSubject(String securityDomain) {
        Subject subject = null;
        try {
            InitialContext ctx = new InitialContext();
            String jsmName = "jaas:/" + securityDomain;
            JaasSecurityManager jsm = (JaasSecurityManager)ctx.lookup(jsmName);
            subject = jsm.getActiveSubject();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return subject;
    }

    public static LoginContext getActiveSubjectLoginContext(String securityDomain, CallbackHandler handler) throws LoginException {
        LoginContext lc = null;
        Subject subject = JaasSecurityManager.getActiveSubject(securityDomain);
        if (subject == null) {
            throw new LoginException("No active subject found in securityDomain: " + securityDomain);
        }
        lc = handler != null ? new LoginContext(securityDomain, subject, handler) : new LoginContext(securityDomain, subject);
        return lc;
    }

    public JaasSecurityManager() {
        this("other");
    }

    public JaasSecurityManager(String securityDomain) {
        this.securityDomain = securityDomain;
        String categoryName = this.getClass().getName() + '.' + securityDomain;
        this.log = Logger.getLogger((String)categoryName);
    }

    public void setCachePolicy(CachePolicy domainCache) {
        this.domainCache = domainCache;
        this.log.debug((Object)("CachePolicy set to: " + domainCache));
    }

    public void flushCache() {
        if (this.domainCache != null) {
            this.domainCache.flush();
        }
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public Subject getActiveSubject() {
        return SecurityAssociation.getSubject();
    }

    public boolean isValid(Principal principal, Object credential) {
        DomainInfo cacheInfo = this.getCacheInfo(principal, true);
        boolean isValid = false;
        if (cacheInfo != null) {
            isValid = this.validateCache(cacheInfo, credential);
        }
        if (!isValid) {
            isValid = this.authenticate(principal, credential);
        }
        return isValid;
    }

    public Principal getPrincipal(Principal principal) {
        Principal result = principal;
        DomainInfo info = this.getCacheInfo(principal, false);
        if (info != null && (result = info.callerPrincipal) == null) {
            result = principal;
        }
        return result;
    }

    public boolean doesUserHaveRole(Principal principal, Set rolePrincipals) {
        boolean hasRole = false;
        Subject subject = this.getActiveSubject();
        if (subject != null) {
            DomainInfo info = this.getCacheInfo(principal, false);
            Group roles = null;
            if (info != null) {
                roles = info.roles;
            }
            if (roles != null) {
                Iterator iter = rolePrincipals.iterator();
                while (!hasRole && iter.hasNext()) {
                    Principal role = (Principal)iter.next();
                    hasRole = roles.isMember(role);
                }
            }
        }
        return hasRole;
    }

    public boolean doesUserHaveRole(Principal principal, Principal role) {
        boolean hasRole = false;
        Subject subject = this.getActiveSubject();
        if (subject != null) {
            DomainInfo info = this.getCacheInfo(principal, false);
            Group roles = null;
            if (info != null) {
                roles = info.roles;
            }
            if (roles != null) {
                hasRole = roles.isMember(role);
            }
        }
        return hasRole;
    }

    public Set getUserRoles(Principal principal) {
        HashSet<Principal> userRoles = null;
        Subject subject = this.getActiveSubject();
        if (subject != null) {
            DomainInfo info = this.getCacheInfo(principal, false);
            Group roles = null;
            if (info != null) {
                roles = info.roles;
            }
            if (roles != null) {
                userRoles = new HashSet<Principal>();
                Enumeration members = roles.members();
                while (members.hasMoreElements()) {
                    Principal role = (Principal)members.nextElement();
                    userRoles.add(role);
                }
            }
        }
        return userRoles;
    }

    private synchronized boolean authenticate(Principal principal, Object credential) {
        boolean authenticated;
        block3: {
            Object lc = null;
            Subject subject = null;
            authenticated = false;
            try {
                SecurityAssociation.setSubject(null);
                subject = this.defaultLogin(principal, credential);
                if (subject != null) {
                    SecurityAssociation.setSubject((Subject)subject);
                    authenticated = true;
                    this.updateCache(subject, principal, credential);
                }
            }
            catch (LoginException e) {
                if ((principal == null || principal.getName() == null) && !this.log.isTraceEnabled()) break block3;
                this.log.debug((Object)"Login failure", (Throwable)e);
            }
        }
        return authenticated;
    }

    private Subject defaultLogin(Principal principal, Object credential) throws LoginException {
        SecurityAssociationHandler handler = new SecurityAssociationHandler(principal, credential);
        Subject subject = new Subject();
        LoginContext lc = new LoginContext(this.securityDomain, subject, (CallbackHandler)handler);
        lc.login();
        return subject;
    }

    private boolean validateCache(DomainInfo info, Object credential) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("validateCache, info=" + info));
        }
        Object subjectCredential = info.credential;
        boolean isValid = false;
        if (credential == null || subjectCredential == null) {
            isValid = credential == null && subjectCredential == null;
        } else if (!subjectCredential.getClass().isAssignableFrom(credential.getClass())) {
            isValid = false;
        } else if (subjectCredential instanceof Comparable) {
            Comparable c = (Comparable)subjectCredential;
            isValid = c.compareTo(credential) == 0;
        } else if (subjectCredential instanceof char[]) {
            char[] a1 = (char[])subjectCredential;
            char[] a2 = (char[])credential;
            isValid = Arrays.equals(a1, a2);
        } else if (subjectCredential instanceof byte[]) {
            byte[] a1 = (byte[])subjectCredential;
            byte[] a2 = (byte[])credential;
            isValid = Arrays.equals(a1, a2);
        } else {
            isValid = subjectCredential.equals(credential);
        }
        if (isValid) {
            SecurityAssociation.setSubject((Subject)info.subject);
        }
        return isValid;
    }

    private DomainInfo getCacheInfo(Principal principal, boolean allowRefresh) {
        if (this.domainCache == null) {
            return null;
        }
        DomainInfo cacheInfo = null;
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            cacheInfo = allowRefresh ? (DomainInfo)this.domainCache.get((Object)principal) : (DomainInfo)this.domainCache.peek((Object)principal);
        }
        return cacheInfo;
    }

    private void updateCache(Subject subject, Principal principal, Object credential) {
        if (this.domainCache == null) {
            return;
        }
        DomainInfo info = new DomainInfo();
        info.subject = subject;
        info.credential = credential;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("updateCache, subject=" + subject));
        }
        Set subjectGroups = subject.getPrincipals(class$java$security$acl$Group == null ? (class$java$security$acl$Group = JaasSecurityManager.class$("java.security.acl.Group")) : class$java$security$acl$Group);
        Iterator iter = subjectGroups.iterator();
        while (iter.hasNext()) {
            Group grp = (Group)iter.next();
            String name = grp.getName();
            if (name.equals("CallerPrincipal")) {
                Enumeration members = grp.members();
                if (!members.hasMoreElements()) continue;
                info.callerPrincipal = (Principal)members.nextElement();
                continue;
            }
            if (!name.equals("Roles")) continue;
            info.roles = grp;
        }
        if (principal == null && info.callerPrincipal == null) {
            Set subjectPrincipals = subject.getPrincipals(class$java$security$Principal == null ? (class$java$security$Principal = JaasSecurityManager.class$("java.security.Principal")) : class$java$security$Principal);
            iter = subjectPrincipals.iterator();
            while (iter.hasNext()) {
                Principal p = (Principal)iter.next();
                if (p instanceof Group) continue;
                info.callerPrincipal = p;
            }
        }
        CachePolicy cachePolicy = this.domainCache;
        synchronized (cachePolicy) {
            if (this.domainCache.peek((Object)principal) != null) {
                this.domainCache.remove((Object)principal);
            }
            this.domainCache.insert((Object)principal, (Object)info);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DomainInfo {
        Subject subject;
        Object credential;
        Principal callerPrincipal;
        Group roles;
    }
}

