/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.jboss.security.AbstractSecurityProxy;
import org.jboss.security.SecurityPolicy;
import org.jboss.security.SubjectSecurityManager;

public class SubjectSecurityProxy
extends AbstractSecurityProxy {
    private SubjectSecurityManager subjectSecurityManager;

    SubjectSecurityProxy(Object delegate) {
        super(delegate);
    }

    public void init(Class beanHome, Class beanRemote, Object securityMgr) throws InstantiationException {
        if (!(securityMgr instanceof SubjectSecurityManager)) {
            throw new InstantiationException("SubjectSecurityProxy requires a SubjectSecurityManager instance, securityMgr=" + securityMgr);
        }
        this.subjectSecurityManager = (SubjectSecurityManager)securityMgr;
        super.init(beanHome, beanRemote, securityMgr);
    }

    protected void invokeHomeOnDelegate(final Method m, final Object[] args, final Object delegate) throws SecurityException {
        Subject subject = this.subjectSecurityManager.getActiveSubject();
        if (subject == null) {
            throw new SecurityException("No subject associated with secure proxy");
        }
        try {
            String domainName = this.subjectSecurityManager.getSecurityDomain();
            SecurityPolicy.setActiveApp(domainName);
            Subject.doAsPrivileged(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    m.invoke(delegate, args);
                    return null;
                }
            }, null);
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getException();
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            } else if (t instanceof UndeclaredThrowableException) {
                t = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
            }
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            t.printStackTrace();
            throw new SecurityException("Unexpected error during security proxy execution:" + t.getMessage());
        }
    }

    protected void invokeOnDelegate(final Method m, final Object[] args, final Object delegate) throws SecurityException {
        Subject subject = this.subjectSecurityManager.getActiveSubject();
        if (subject == null) {
            throw new SecurityException("No subject associated with secure proxy");
        }
        try {
            String domainName = this.subjectSecurityManager.getSecurityDomain();
            SecurityPolicy.setActiveApp(domainName);
            Subject.doAsPrivileged(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    m.invoke(delegate, args);
                    return null;
                }
            }, null);
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getException();
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            } else if (t instanceof UndeclaredThrowableException) {
                t = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
            }
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            t.printStackTrace();
            throw new SecurityException("Unexpected error during security proxy execution:" + t.getMessage());
        }
    }
}

