/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.Policy;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.jboss.security.AppPolicy;
import org.jboss.security.IAppPolicyStore;

public class SecurityPolicy
extends Policy {
    private static final AuthPermission REFRESH_PERM = new AuthPermission("refreshPolicy");
    private static final Set emptySet = new HashSet();
    private static final ThreadLocal activeApp = new ThreadLocal();
    private IAppPolicyStore policyStore;
    private LoginConfiguration loginConfig = new LoginConfiguration();

    public static void setActiveApp(String appName) {
        activeApp.set(appName);
    }

    public static void unsetActiveApp() {
        activeApp.set(null);
    }

    public SecurityPolicy(IAppPolicyStore policyStore) {
        this.policyStore = policyStore;
    }

    public Configuration getLoginConfiguration() {
        return this.loginConfig;
    }

    public PermissionCollection getPermissions(Subject subject, CodeSource codesource) {
        String appName = (String)activeApp.get();
        if (appName == null) {
            appName = "other";
        }
        PermissionCollection perms = this.getPermissions(subject, codesource, appName);
        return perms;
    }

    public PermissionCollection getPermissions(Subject subject, CodeSource codesource, String appName) {
        AppPolicy policy = this.policyStore.getAppPolicy(appName);
        PermissionCollection perms = AppPolicy.NO_PERMISSIONS;
        if (policy != null) {
            perms = policy.getPermissions(subject, codesource);
        }
        return perms;
    }

    public AppPolicy getAppPolicy(String appName) {
        AppPolicy appPolicy = this.policyStore.getAppPolicy(appName);
        return appPolicy;
    }

    public void refresh() {
        AccessController.checkPermission(REFRESH_PERM);
        this.policyStore.refresh();
    }

    public class LoginConfiguration
    extends Configuration {
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            AppConfigurationEntry[] entry = null;
            AppPolicy appPolicy = SecurityPolicy.this.policyStore.getAppPolicy(appName);
            if (appPolicy != null) {
                entry = appPolicy.getAppConfigurationEntry();
            }
            return entry;
        }

        public void refresh() {
            SecurityPolicy.this.refresh();
        }
    }
}

