/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.xml;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLUtils {
    static /* synthetic */ Class class$java$lang$String;

    public static void applyProperties(Object o, Element root) {
        Map map = XMLUtils.getProperties(root);
        Iterator it = map.keySet().iterator();
        Field[] fields = o.getClass().getFields();
        Method[] methods = o.getClass().getMethods();
        block2: while (it.hasNext()) {
            String name = (String)it.next();
            Object value = map.get(name);
            try {
                int i = 0;
                while (i < fields.length) {
                    if (fields[i].getName().equalsIgnoreCase(name) && XMLUtils.isTypeMatch(fields[i].getType(), value.getClass())) {
                        fields[i].set(o, value);
                        System.out.println("Set field " + fields[i].getName() + "=" + value);
                        break;
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < methods.length) {
                    if (methods[i2].getName().equalsIgnoreCase("set" + name) && methods[i2].getParameterTypes().length == 1 && XMLUtils.isTypeMatch(methods[i2].getParameterTypes()[0], value.getClass())) {
                        methods[i2].invoke(o, value);
                        System.out.println("Set method " + methods[i2].getName() + "=" + value);
                        continue block2;
                    }
                    ++i2;
                }
            }
            catch (Exception e) {
                System.out.println("Unable to apply property '" + name + "': " + e);
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static Element createChild(Document doc, Element root, String name) {
        Element elem = doc.createElement(name);
        root.appendChild(elem);
        return elem;
    }

    public static void createChildText(Document doc, Element elem, String name, String value) {
        Element child = doc.createElement(name);
        child.appendChild(doc.createTextNode(value == null ? "" : value));
        elem.appendChild(child);
    }

    public static void createOptionalChildText(Document doc, Element elem, String name, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        Element child = doc.createElement(name);
        child.appendChild(doc.createTextNode(value));
        elem.appendChild(child);
    }

    public static Element getChildByName(Element e, String name) {
        Element[] list = XMLUtils.getChildrenByName(e, name);
        if (list.length == 0) {
            return null;
        }
        if (list.length > 1) {
            throw new IllegalStateException("Too many (" + list.length + ") '" + name + "' elements found!");
        }
        return list[0];
    }

    public static String getChildText(Element parent, String name) {
        Element e = XMLUtils.getChildByName(parent, name);
        if (e == null) {
            return "";
        }
        return XMLUtils.getText(e);
    }

    public static Element[] getChildrenByName(Element e, String name) {
        NodeList nl = e.getChildNodes();
        int max = nl.getLength();
        LinkedList<Node> list = new LinkedList<Node>();
        int i = 0;
        while (i < max) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1 && n.getNodeName().equals(name)) {
                list.add(n);
            }
            ++i;
        }
        return list.toArray(new Element[list.size()]);
    }

    public static Map getProperties(Element root) {
        HashMap map = new HashMap();
        Element[] list = XMLUtils.getChildrenByName(root, "property");
        int i = 0;
        while (i < list.length) {
            String name = list[i].getAttribute("name");
            String type = list[i].getAttribute("type");
            String valueString = XMLUtils.getText(list[i]);
            try {
                Class<?> cls = Class.forName(type);
                Constructor<?> con = cls.getConstructor(class$java$lang$String != null ? class$java$lang$String : XMLUtils.class$("java.lang.String"));
                Object value = con.newInstance(valueString);
                map.put(name, value);
            }
            catch (Exception e) {
                System.out.println("Unable to parse property '" + name + "'='" + valueString + "': " + e);
            }
            ++i;
        }
        return map;
    }

    public static String getText(Element e) {
        NodeList nl = e.getChildNodes();
        int max = nl.getLength();
        int i = 0;
        while (i < max) {
            Node n = nl.item(i);
            if (n.getNodeType() == 3) {
                return n.getNodeValue();
            }
            ++i;
        }
        return "";
    }

    private static boolean isTypeMatch(Class one, Class two) {
        if (one.equals(two)) {
            return true;
        }
        if (one.isPrimitive()) {
            if (one.getName().equals("int") && two.getName().equals("java.lang.Integer")) {
                return true;
            }
            if (one.getName().equals("long") && two.getName().equals("java.lang.Long")) {
                return true;
            }
            if (one.getName().equals("float") && two.getName().equals("java.lang.Float")) {
                return true;
            }
            if (one.getName().equals("double") && two.getName().equals("java.lang.Double")) {
                return true;
            }
            if (one.getName().equals("char") && two.getName().equals("java.lang.Character")) {
                return true;
            }
            if (one.getName().equals("byte") && two.getName().equals("java.lang.Byte")) {
                return true;
            }
            if (one.getName().equals("short") && two.getName().equals("java.lang.Short")) {
                return true;
            }
            if (one.getName().equals("boolean") && two.getName().equals("java.lang.Boolean")) {
                return true;
            }
        }
        return false;
    }

    public static String[] splitOnWhitespace(String source) {
        int pos = -1;
        LinkedList<String> list = new LinkedList<String>();
        int max = source.length();
        int i = 0;
        while (i < max) {
            char c = source.charAt(i);
            if (Character.isWhitespace(c)) {
                if (i - pos > 1) {
                    list.add(source.substring(pos + 1, i));
                }
                pos = i;
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }
}

