/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.jdbc.xa.wrapper;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.jboss.pool.PoolEvent;
import org.jboss.pool.PoolEventListener;
import org.jboss.pool.PooledObject;
import org.jboss.pool.cache.ObjectCache;
import org.jboss.pool.jdbc.ConnectionInPool;
import org.jboss.pool.jdbc.xa.wrapper.TransactionListener;
import org.jboss.pool.jdbc.xa.wrapper.XAClientConnection;
import org.jboss.pool.jdbc.xa.wrapper.XAResourceImpl;

public class XAConnectionImpl
implements XAConnection,
PooledObject {
    private static final String CLOSED = "Connection has been closed!";
    private Connection con;
    private XAResourceImpl resource;
    private Vector listeners;
    private Vector poolListeners;
    private ArrayList clientConnections;
    private TransactionListener transListener;
    private int preparedStatementCacheSize = 0;
    private int clientConnectionCount = 0;
    private String user;
    private String password;
    private boolean saveStackTrace;

    public XAConnectionImpl(Connection con, XAResourceImpl resource, boolean saveStackTrace) {
        this.con = con;
        this.resource = resource;
        this.listeners = new Vector();
        this.poolListeners = new Vector();
        this.clientConnections = new ArrayList();
        this.saveStackTrace = saveStackTrace;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.addElement(listener);
    }

    public void addPoolEventListener(PoolEventListener listener) {
        this.poolListeners.addElement(listener);
    }

    public void clearTransactionListener() {
        this.transListener = null;
    }

    public void clientConnectionClosed(XAClientConnection clientCon) {
        ((AbstractCollection)this.clientConnections).remove(clientCon);
        if (this.clientConnections.size() > 0) {
            return;
        }
        boolean trans = this.resource.isTransaction();
        Vector local = (Vector)this.listeners.clone();
        int i = local.size() - 1;
        while (i >= 0) {
            ((ConnectionEventListener)local.elementAt(i)).connectionClosed(new ConnectionEvent(this));
            --i;
        }
    }

    public void close() {
        try {
            this.con.close();
        }
        catch (SQLException sQLException) {}
        ObjectCache cache = (ObjectCache)ConnectionInPool.psCaches.remove(this.con);
        if (cache != null) {
            cache.close();
        }
        this.con = null;
        this.resource = null;
        this.listeners.clear();
        this.listeners = null;
    }

    void firePoolEvent(PoolEvent evt) {
        Vector local = (Vector)this.poolListeners.clone();
        int i = local.size() - 1;
        while (i >= 0) {
            if (evt.getType() == -8986432) {
                ((PoolEventListener)local.elementAt(i)).objectClosed(evt);
            } else if (evt.getType() == -8986433) {
                ((PoolEventListener)local.elementAt(i)).objectError(evt);
            } else {
                ((PoolEventListener)local.elementAt(i)).objectUsed(evt);
            }
            --i;
        }
    }

    public void forceClientConnectionsClose() {
        int i = 0;
        while (i < this.clientConnections.size()) {
            XAClientConnection client = (XAClientConnection)this.clientConnections.get(i);
            try {
                client.forcedClose();
            }
            catch (SQLException sQLException) {}
            ++i;
        }
        this.clientConnections.clear();
    }

    public Connection getConnection() {
        XAClientConnection xaCon;
        ArrayList arrayList = this.clientConnections;
        synchronized (arrayList) {
            xaCon = new XAClientConnection(this, this.con, this.saveStackTrace);
            xaCon.setPSCacheSize(this.preparedStatementCacheSize);
            this.clientConnections.add(xaCon);
        }
        return xaCon;
    }

    public int getPSCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    public XAResource getXAResource() {
        return this.resource;
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (!this.listeners.remove(listener)) {
            throw new IllegalArgumentException();
        }
    }

    public void removePoolEventListener(PoolEventListener listener) {
        this.poolListeners.removeElement(listener);
    }

    public void rollback() throws SQLException {
        if (!this.con.getAutoCommit()) {
            this.con.rollback();
        }
    }

    public void setConnectionError(SQLException e) {
        Vector local = (Vector)this.listeners.clone();
        int i = local.size() - 1;
        while (i >= 0) {
            try {
                ((ConnectionEventListener)local.elementAt(i)).connectionErrorOccurred(new ConnectionEvent(this, e));
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
            }
            --i;
        }
    }

    public void setPSCacheSize(int maxSize) {
        this.preparedStatementCacheSize = maxSize;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTransactionIsolation(int iso) throws SQLException {
        this.con.setTransactionIsolation(iso);
    }

    public void setTransactionListener(TransactionListener tl) {
        this.transListener = tl;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void transactionFailed() {
        if (this.transListener != null) {
            this.transListener.transactionFailed(this);
        }
    }

    public void transactionFinished() {
        if (this.transListener != null) {
            this.transListener.transactionFinished(this);
        }
    }
}

