/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.jdbc.xa;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.jboss.logging.Logger;
import org.jboss.logging.log4j.CategoryWriter;
import org.jboss.pool.ObjectPool;
import org.jboss.pool.jdbc.xa.XAConnectionFactory;
import org.jboss.pool.jdbc.xa.XAPoolDriver;

public class XAPoolDataSource
implements DataSource,
Referenceable,
ObjectFactory,
Serializable {
    private static transient Logger log = Logger.getLogger((Class)(class$org$jboss$pool$jdbc$xa$XAPoolDataSource != null ? class$org$jboss$pool$jdbc$xa$XAPoolDataSource : (class$org$jboss$pool$jdbc$xa$XAPoolDataSource = XAPoolDataSource.class$("org.jboss.pool.jdbc.xa.XAPoolDataSource"))));
    private static transient HashMap sources = new HashMap();
    private transient ObjectPool pool;
    private transient XAConnectionFactory factory;
    private transient PrintWriter logWriter;
    private transient int timeout;
    private transient boolean initialized = false;
    private transient String jndiName;
    private String name;
    static /* synthetic */ Class class$org$jboss$pool$jdbc$xa$XAPoolDataSource;

    public XAPoolDataSource() {
        log.trace((Object)"Creating XA Pool");
        this.pool = new ObjectPool();
        try {
            this.factory = new XAConnectionFactory();
        }
        catch (NamingException e) {
            log.error((Object)"Can't get XAConnectionFactory", (Throwable)e);
        }
        XAPoolDriver.instance();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Closing DataSource");
        }
        try {
            this.setJNDIName(null);
        }
        catch (NamingException e) {
            log.warn((Object)"Can't unbind from JNDI", (Throwable)e);
        }
        sources.remove(this.pool.getName());
        this.pool.shutDown();
        this.pool = null;
        this.factory = null;
    }

    public long getAvailableConnections() {
        return this.pool.getAvailableObjects();
    }

    public int getBlockingTimeout() {
        return this.pool.getBlockingTimeout();
    }

    public Connection getConnection() throws SQLException {
        if (!this.initialized) {
            this.initialize();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Getting a Connection");
        }
        String user = this.factory.getUser();
        String password = this.factory.getPassword();
        String[] params = new String[]{user, password};
        XAConnection xaConn = (XAConnection)this.pool.getObject(params);
        return xaConn.getConnection();
    }

    public Connection getConnection(String user, String password) throws SQLException {
        if (!this.initialized) {
            this.initialize();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Getting a connection for user " + user + " with password " + password));
        }
        String[] params = new String[]{user, password};
        XAConnection xaConn = (XAConnection)this.pool.getObject(params);
        return xaConn.getConnection();
    }

    public XADataSource getDataSource() {
        return this.factory.getDataSource();
    }

    public static XAPoolDataSource getDataSource(String poolName) {
        return (XAPoolDataSource)sources.get(poolName);
    }

    public static Collection getDataSources() {
        return new HashSet(sources.values());
    }

    public long getGCInterval() {
        return this.pool.getGCInterval();
    }

    public long getGCMinIdleTime() {
        return this.pool.getGCMinIdleTime();
    }

    public long getIdleTimeout() {
        return this.pool.getIdleTimeout();
    }

    public String getJDBCPassword() {
        return this.factory.getPassword();
    }

    public String getJDBCUser() {
        return this.factory.getUser();
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public int getLoginTimeout() throws SQLException {
        return this.timeout;
    }

    public float getMaxIdleTimeoutPercent() {
        return this.pool.getMaxIdleTimeoutPercent();
    }

    public int getMaxSize() {
        return this.pool.getMaxSize();
    }

    public int getMinSize() {
        return this.pool.getMinSize();
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) {
        Reference ref;
        if (obj instanceof Reference && (ref = (Reference)obj).getClassName().equals(this.getClass().getName())) {
            RefAddr addr = ref.get("XAPool");
            return sources.get((String)addr.getContent());
        }
        return null;
    }

    public int getPSCacheSize() {
        return this.factory.getPSCacheSize();
    }

    public String getPoolName() {
        return this.name;
    }

    public String getPoolStatus() {
        return this.pool.toString();
    }

    public Reference getReference() {
        return new Reference(this.getClass().getName(), new StringRefAddr("XAPool", this.pool.getName()), this.getClass().getName(), null);
    }

    public boolean getReleaseOnCommit() {
        return this.factory.getReleaseOnCommit();
    }

    public boolean getSaveStackTrace() {
        return this.factory.getSaveStackTrace();
    }

    public int getTransactionIsolation() {
        return this.factory.getTransactionIsolation();
    }

    public String getTransactionManagerJNDIName() {
        return this.factory.getTransactionManagerJNDIName();
    }

    public long getUsedConnections() {
        return (long)this.getMaxSize() - this.getAvailableConnections();
    }

    public void initialize() {
        this.initialized = true;
        this.pool.setObjectFactory(this.factory);
        this.pool.initialize();
    }

    public boolean isBlocking() {
        return this.pool.isBlocking();
    }

    public boolean isGCEnabled() {
        return this.pool.isGCEnabled();
    }

    public boolean isIdleTimeoutEnabled() {
        return this.pool.isIdleTimeoutEnabled();
    }

    public boolean isInvalidateOnError() {
        return this.pool.isInvalidateOnError();
    }

    public boolean isTimestampUsed() {
        return this.pool.isTimestampUsed();
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            InitialContext ctx = new InitialContext();
            return ctx.lookup("java:/" + this.name);
        }
        catch (NamingException e) {
            throw new InvalidObjectException("problem finding correct datasource instance" + e);
        }
    }

    public void setBlocking(boolean blocking) {
        this.pool.setBlocking(blocking);
    }

    public void setBlockingTimeout(int blockingTimeout) {
        this.pool.setBlockingTimeout(blockingTimeout);
    }

    public void setDataSource(XADataSource ds) {
        this.factory.setDataSource(ds);
    }

    public void setGCEnabled(boolean allowGC) {
        this.pool.setGCEnabled(allowGC);
    }

    public void setGCInterval(long millis) {
        this.pool.setGCInterval(millis);
    }

    public void setGCMinIdleTime(long millis) {
        this.pool.setGCMinIdleTime(millis);
    }

    public void setIdleTimeout(long millis) {
        this.pool.setIdleTimeout(millis);
    }

    public void setIdleTimeoutEnabled(boolean allowShrinking) {
        this.pool.setIdleTimeoutEnabled(allowShrinking);
    }

    public void setInvalidateOnError(boolean invalidate) {
        this.pool.setInvalidateOnError(invalidate);
    }

    public void setJDBCPassword(String password) {
        this.factory.setPassword(password);
    }

    public void setJDBCUser(String user) {
        this.factory.setUser(user);
    }

    public void setJNDIName(String name) throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Binding to JNDI name " + name));
        }
        InitialContext ctx = new InitialContext();
        if (this.jndiName != null && !this.jndiName.equals(name)) {
            ctx.unbind(this.jndiName);
        }
        if (name != null) {
            ctx.bind(name, (Object)this);
        }
        this.jndiName = name;
    }

    public void setLogWriter(PrintWriter writer) throws SQLException {
        if (writer == null) {
            this.logWriter = null;
        } else if (this.logWriter == null) {
            this.logWriter = new CategoryWriter(log.getCategory());
        }
    }

    public void setLoginTimeout(int timeout) throws SQLException {
        this.timeout = timeout;
    }

    public void setMaxIdleTimeoutPercent(float percent) {
        this.pool.setMaxIdleTimeoutPercent(percent);
    }

    public void setMaxSize(int size) {
        this.pool.setMaxSize(size);
    }

    public void setMinSize(int size) {
        this.pool.setMinSize(size);
    }

    public void setPSCacheSize(int size) {
        this.factory.setPSCacheSize(size);
    }

    public void setPoolName(String name) {
        this.name = name;
        this.pool.setName(name);
        sources.put(this.pool.getName(), this);
    }

    public void setReleaseOnCommit(boolean rel) {
        this.factory.setReleaseOnCommit(rel);
    }

    public void setSaveStackTrace(boolean save) {
        this.factory.setSaveStackTrace(save);
    }

    public void setTimestampUsed(boolean timestamp) {
        this.pool.setTimestampUsed(timestamp);
    }

    public void setTransactionIsolation(int iso) {
        this.factory.setTransactionIsolation(iso);
    }

    public void setTransactionManagerJNDIName(String name) {
        this.factory.setTransactionManagerJNDIName(name);
    }
}

