/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.jdbc.xa;

import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.logging.Logger;
import org.jboss.pool.ObjectPool;
import org.jboss.pool.PoolObjectFactory;
import org.jboss.pool.jdbc.xa.wrapper.TransactionListener;
import org.jboss.pool.jdbc.xa.wrapper.XAConnectionImpl;
import org.jboss.pool.jdbc.xa.wrapper.XADataSourceImpl;
import org.jboss.pool.jdbc.xa.wrapper.XAResourceImpl;

public class XAConnectionFactory
extends PoolObjectFactory {
    public static final int DEFAULT_ISOLATION = -1;
    private InitialContext ctx;
    private XADataSource source;
    private String userName;
    private String password;
    private String tmJndiName;
    private int psCacheSize = 10;
    private boolean releaseOnCommit = false;
    private boolean saveStackTrace = false;
    private int transactionIsolation = -1;
    private ConnectionEventListener listener;
    private ConnectionEventListener errorListener;
    private TransactionListener transListener;
    private ObjectPool pool;
    private final Map wrapperTx = Collections.synchronizedMap(new HashMap());
    private final Map rms = Collections.synchronizedMap(new HashMap());
    private TransactionManager tm;
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$pool$jdbc$xa$XAConnectionFactory != null ? class$org$jboss$pool$jdbc$xa$XAConnectionFactory : (class$org$jboss$pool$jdbc$xa$XAConnectionFactory = XAConnectionFactory.class$("org.jboss.pool.jdbc.xa.XAConnectionFactory"))));
    static /* synthetic */ Class class$org$jboss$pool$jdbc$xa$XAConnectionFactory;

    public XAConnectionFactory() throws NamingException {
        this.ctx = new InitialContext();
        this.errorListener = new ConnectionEventListener(){

            public void connectionClosed(ConnectionEvent evt) {
            }

            public void connectionErrorOccurred(ConnectionEvent evt) {
                if (XAConnectionFactory.this.pool.isInvalidateOnError()) {
                    XAConnectionFactory.this.pool.markObjectAsInvalid(evt.getSource());
                }
            }
        };
        this.listener = new ConnectionEventListener(){

            private void closeConnection(ConnectionEvent evt, int status) {
                XAConnection con = (XAConnection)evt.getSource();
                try {
                    con.removeConnectionEventListener(XAConnectionFactory.this.listener);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return;
                }
                Transaction trans = null;
                try {
                    if (XAConnectionFactory.this.tm.getStatus() != 6) {
                        trans = XAConnectionFactory.this.tm.getTransaction();
                        XAResource res = (XAResource)XAConnectionFactory.this.rms.remove(con);
                        if (res != null) {
                            trans.delistResource(res, status);
                        } else {
                            log.warn((Object)("no xares in rms for con " + con));
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Unable to deregister with TransactionManager", (Throwable)e);
                    throw new RuntimeException("Unable to deregister with TransactionManager: " + e);
                }
                if (!(con instanceof XAConnectionImpl)) {
                    XAConnectionFactory.this.pool.releaseObject(con);
                } else {
                    XAConnectionImpl xaCon = (XAConnectionImpl)con;
                    if (!((XAResourceImpl)xaCon.getXAResource()).isTransaction()) {
                        log.warn((Object)("XAConnectionImpl: " + xaCon + " has no current tx!"));
                        try {
                            xaCon.rollback();
                        }
                        catch (SQLException sQLException) {
                            XAConnectionFactory.this.pool.markObjectAsInvalid(con);
                        }
                        XAConnectionFactory.this.pool.releaseObject(con);
                    } else {
                        con.addConnectionEventListener(XAConnectionFactory.this.errorListener);
                    }
                }
            }

            public void connectionClosed(ConnectionEvent evt) {
                this.closeConnection(evt, 0x4000000);
            }

            public void connectionErrorOccurred(ConnectionEvent evt) {
                if (XAConnectionFactory.this.pool.isInvalidateOnError()) {
                    XAConnectionFactory.this.pool.markObjectAsInvalid(evt.getSource());
                }
            }
        };
        this.transListener = new TransactionListener(){

            public void transactionFailed(XAConnectionImpl con) {
                con.clearTransactionListener();
                Object tx = XAConnectionFactory.this.wrapperTx.remove(con);
                if (tx != null) {
                    XAConnectionFactory.this.wrapperTx.remove(tx);
                }
                XAConnectionFactory.this.pool.markObjectAsInvalid(con);
                try {
                    con.removeConnectionEventListener(XAConnectionFactory.this.errorListener);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!XAConnectionFactory.this.releaseOnCommit) {
                        return;
                    }
                    XAConnectionFactory.this.rms.remove(con);
                    con.forceClientConnectionsClose();
                }
                XAConnectionFactory.this.pool.releaseObject(con);
            }

            public void transactionFinished(XAConnectionImpl con) {
                con.clearTransactionListener();
                Object tx = XAConnectionFactory.this.wrapperTx.remove(con);
                if (tx != null) {
                    XAConnectionFactory.this.wrapperTx.remove(tx);
                }
                try {
                    con.removeConnectionEventListener(XAConnectionFactory.this.errorListener);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!XAConnectionFactory.this.releaseOnCommit) {
                        return;
                    }
                    XAConnectionFactory.this.rms.remove(con);
                    XAConnectionFactory.this.pool.markObjectAsInvalid(con);
                    con.forceClientConnectionsClose();
                }
                XAConnectionFactory.this.pool.releaseObject(con);
            }
        };
    }

    public boolean checkValidObject(Object source, Object parameters) {
        boolean validObject = true;
        if (parameters != null && source instanceof XAConnectionImpl) {
            XAConnectionImpl con = (XAConnectionImpl)source;
            String[] credentials = (String[])parameters;
            if (credentials.length == 2) {
                String user = con.getUser();
                String password = con.getPassword();
                boolean validUser = user == null && credentials[0] == null || user != null && user.equals(credentials[0]);
                boolean validPassword = password == null && credentials[1] == null || password != null && password.equals(credentials[1]);
                validObject = validUser && validPassword;
            }
        }
        return validObject;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Object createObject(Object parameters) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Opening new XAConnection");
        }
        XAConnection obj = null;
        try {
            if (parameters != null) {
                String[] credentials = (String[])parameters;
                if (credentials.length == 2) {
                    obj = this.source.getXAConnection(credentials[0], credentials[1]);
                }
            } else {
                obj = this.userName != null && this.userName.length() > 0 ? this.source.getXAConnection(this.userName, this.password) : this.source.getXAConnection();
            }
        }
        catch (SQLException e) {
            log.error((Object)"Can't get an XAConnection", (Throwable)e);
            throw e;
        }
        return obj;
    }

    public void deleteObject(Object pooledObject) {
        XAConnection con = (XAConnection)pooledObject;
        try {
            con.close();
        }
        catch (SQLException sQLException) {}
    }

    public XADataSource getDataSource() {
        return this.source;
    }

    public int getPSCacheSize() {
        return this.psCacheSize;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getReleaseOnCommit() {
        return this.releaseOnCommit;
    }

    public boolean getSaveStackTrace() {
        return this.saveStackTrace;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public String getTransactionManagerJNDIName() {
        return this.tmJndiName;
    }

    public String getUser() {
        return this.userName;
    }

    public Object isUniqueRequest() {
        try {
            if (this.tm.getStatus() != 6) {
                Transaction trans = this.tm.getTransaction();
                return this.wrapperTx.get(trans);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void poolStarted(ObjectPool pool) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting");
        }
        super.poolStarted(pool);
        this.pool = pool;
        if (this.source == null) {
            throw new IllegalStateException("Must specify XADataSource to " + this.getClass().getName());
        }
        if (this.source instanceof XADataSourceImpl) {
            ((XADataSourceImpl)this.source).setSaveStackTrace(this.saveStackTrace);
        }
        if (this.tmJndiName == null) {
            throw new IllegalStateException("Must specify TransactionManager JNDI Name to " + this.getClass().getName());
        }
        if (this.ctx == null) {
            throw new IllegalStateException("Must specify InitialContext to " + this.getClass().getName());
        }
        try {
            this.tm = (TransactionManager)this.ctx.lookup(this.tmJndiName);
        }
        catch (NamingException namingException) {
            throw new IllegalStateException("Cannot lookup TransactionManager using specified context and name!");
        }
    }

    public Object prepareObject(Object pooledObject) {
        boolean trace = log.isTraceEnabled();
        XAConnection con = (XAConnection)pooledObject;
        con.addConnectionEventListener(this.listener);
        Transaction trans = null;
        try {
            if (this.tm.getStatus() != 6) {
                trans = this.tm.getTransaction();
                XAResource res = con.getXAResource();
                this.rms.put(con, res);
                trans.enlistResource(res);
                if (trace) {
                    log.trace((Object)("Resource '" + res + "' enlisted for '" + con + "'."));
                }
            } else if (trace) {
                log.trace((Object)"No transaction right now.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Unable to register with TransactionManager", (Throwable)e);
            con.removeConnectionEventListener(this.listener);
            throw new RuntimeException("Unable to register with TransactionManager: " + e);
        }
        if (con instanceof XAConnectionImpl) {
            ((XAConnectionImpl)con).setTransactionListener(this.transListener);
            ((XAConnectionImpl)con).setPSCacheSize(this.psCacheSize);
            if (this.transactionIsolation != -1) {
                try {
                    ((XAConnectionImpl)con).setTransactionIsolation(this.transactionIsolation);
                }
                catch (SQLException sex) {
                    throw new RuntimeException("Unable to setTransactionIsolation: " + sex.getMessage());
                }
            }
            if (trans != null) {
                this.wrapperTx.put(con, trans);
                this.wrapperTx.put(trans, con);
            }
        }
        return con;
    }

    public void setDataSource(XADataSource dataSource) {
        this.source = dataSource;
    }

    public void setPSCacheSize(int size) {
        this.psCacheSize = size;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setReleaseOnCommit(boolean rel) {
        this.releaseOnCommit = rel;
    }

    public void setSaveStackTrace(boolean save) {
        this.saveStackTrace = save;
    }

    public void setTransactionIsolation(int iso) {
        this.transactionIsolation = iso;
    }

    public void setTransactionManagerJNDIName(String name) {
        this.tmJndiName = name;
    }

    public void setUser(String userName) {
        this.userName = userName;
    }
}

