/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.connector.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.pool.connector.jdbc.JDBCConnectionRequestInfo;
import org.jboss.pool.connector.jdbc.JDBCDataSource;
import org.jboss.pool.connector.jdbc.JDBCManagedConnection;

public class JDBCManagedConnectionFactory
implements ManagedConnectionFactory {
    private String driver;
    private String url;
    private String username;
    private String password;
    private transient PrintWriter logger;
    static /* synthetic */ Class class$javax$resource$spi$security$PasswordCredential;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new UnsupportedOperationException("Must be used in managed mode");
    }

    public Object createConnectionFactory(ConnectionManager mgr) throws ResourceException {
        return new JDBCDataSource(mgr, this);
    }

    public ManagedConnection createManagedConnection(Subject sub, ConnectionRequestInfo info) throws ResourceException {
        String user = this.username;
        String pw = this.password;
        if (sub != null) {
            Set creds = sub.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential != null ? class$javax$resource$spi$security$PasswordCredential : (class$javax$resource$spi$security$PasswordCredential = JDBCManagedConnectionFactory.class$("javax.resource.spi.security.PasswordCredential")));
            Iterator it = creds.iterator();
            if (it.hasNext()) {
                PasswordCredential pc = (PasswordCredential)it.next();
                user = pc.getUserName();
                pw = new String(pc.getPassword());
            }
        } else if (info != null) {
            JDBCConnectionRequestInfo jdbcInfo = (JDBCConnectionRequestInfo)info;
            user = jdbcInfo.user;
            pw = jdbcInfo.password;
        }
        try {
            Connection con = DriverManager.getConnection(this.url, user, pw);
            JDBCManagedConnection mc = new JDBCManagedConnection(con, user, this.url);
            mc.setLogWriter(this.logger);
            return mc;
        }
        catch (SQLException e) {
            throw new ResourceException("Unable to create DB connection: " + e);
        }
    }

    public String getConnectionURL() {
        return this.url;
    }

    public String getDriver() {
        return this.driver;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logger;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.username;
    }

    public ManagedConnection matchManagedConnections(Set cons, Subject sub, ConnectionRequestInfo info) throws ResourceException {
        String user = this.username;
        String pw = this.password;
        if (sub != null) {
            Set creds = sub.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential != null ? class$javax$resource$spi$security$PasswordCredential : (class$javax$resource$spi$security$PasswordCredential = JDBCManagedConnectionFactory.class$("javax.resource.spi.security.PasswordCredential")));
            Iterator it = creds.iterator();
            if (it.hasNext()) {
                PasswordCredential pc = (PasswordCredential)it.next();
                user = pc.getUserName();
                pw = new String(pc.getPassword());
            }
        } else if (info != null) {
            if (!(info instanceof JDBCConnectionRequestInfo)) {
                throw new ResourceException("Passed ConnectionRequestInfo class '" + info.getClass().getName() + "' to JDBCManagedConnectionFactory!");
            }
            JDBCConnectionRequestInfo jdbcInfo = (JDBCConnectionRequestInfo)info;
            user = jdbcInfo.user;
            pw = jdbcInfo.password;
        }
        Iterator it = cons.iterator();
        while (it.hasNext()) {
            JDBCManagedConnection con;
            Object unknown = it.next();
            if (!(unknown instanceof JDBCManagedConnection) || !(con = (JDBCManagedConnection)unknown).getUser().equals(user) || !con.getURL().equals(this.url)) continue;
            return con;
        }
        return null;
    }

    public void setConnectionURL(String url) {
        this.url = url;
    }

    public void setDriver(String driver) {
        this.driver = driver;
        try {
            Class.forName(driver);
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.println("Unable to load JDBC driver '" + driver + "'");
                e.printStackTrace(this.logger);
            }
            System.err.println("Unable to load JDBC driver '" + driver + "'");
            e.printStackTrace();
        }
    }

    public void setLogWriter(PrintWriter writer) throws ResourceException {
        this.logger = writer;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserName(String username) {
        this.username = username;
    }
}

