/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.connector.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.jboss.pool.PoolEvent;
import org.jboss.pool.PoolEventListener;
import org.jboss.pool.connector.jdbc.BaseManagedConnection;
import org.jboss.pool.connector.jdbc.JDBCLocalTransaction;
import org.jboss.pool.jdbc.ConnectionInPool;

public class JDBCManagedConnection
extends BaseManagedConnection {
    private Connection con;
    private String url;

    public JDBCManagedConnection(Connection con, String user, String url) {
        super(user);
        this.con = con;
        this.url = url;
    }

    public void cleanup() throws ResourceException {
        try {
            this.con.rollback();
        }
        catch (SQLException e) {
            throw new ResourceException("Unable to rollback DB connection: " + e);
        }
    }

    public void destroy() throws ResourceException {
        super.destroy();
        try {
            this.con.close();
        }
        catch (SQLException e) {
            throw new ResourceException("Unable to close DB connection: " + e);
        }
        this.con = null;
    }

    public Object getConnection(Subject sub, ConnectionRequestInfo info) throws ResourceException {
        final ConnectionInPool wrapper = new ConnectionInPool(this.con, -1);
        wrapper.addPoolEventListener(new PoolEventListener(){

            public void objectClosed(PoolEvent evt) {
                ConnectionEvent ce = new ConnectionEvent((ManagedConnection)JDBCManagedConnection.this, 1);
                ce.setConnectionHandle((Object)wrapper);
                JDBCManagedConnection.this.fireConnectionEvent(ce);
                wrapper.removePoolEventListener(this);
            }

            public void objectError(PoolEvent evt) {
                ConnectionEvent ce = new ConnectionEvent((ManagedConnection)JDBCManagedConnection.this, 5);
                ce.setConnectionHandle((Object)wrapper);
                JDBCManagedConnection.this.fireConnectionEvent(ce);
                wrapper.removePoolEventListener(this);
            }

            public void objectUsed(PoolEvent evt) {
            }
        });
        return wrapper;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return new JDBCLocalTransaction(this.con);
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        throw new UnsupportedOperationException("Method getMetaData() not yet implemented.");
    }

    String getURL() {
        return this.url;
    }

    public XAResource getXAResource() throws ResourceException {
        throw new ResourceException("getXAResource not supported");
    }
}

