/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.security;

import java.security.Principal;
import java.util.Hashtable;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.resource.security.PrincipalMappingSupport;

public class ManyToOnePrincipalMapping
extends PrincipalMappingSupport {
    private Principal resourcePrincipal;
    private String userName;
    private String password;

    public Subject createSubject(Principal callerPrincipal) {
        if (this.userName == null) {
            return null;
        }
        Subject subject = new Subject();
        subject.getPrincipals().add(this.resourcePrincipal);
        if (!this.metadata.getAuthMechType().equals("BasicPassword")) {
            throw new RuntimeException("Unsupported authentication-mechanism-type: '" + this.metadata.getAuthMechType() + "'");
        }
        PasswordCredential cred = new PasswordCredential(this.userName, this.password.toCharArray());
        cred.setManagedConnectionFactory(this.mcf);
        subject.getPrivateCredentials().add(cred);
        return subject;
    }

    protected void afterSetProperties() {
        String principalName;
        this.userName = (String)((Hashtable)this.properties).get("userName");
        this.password = (String)((Hashtable)this.properties).get("password");
        if (this.password == null) {
            this.password = "";
        }
        if ((principalName = (String)((Hashtable)this.properties).get("principalName")) == null) {
            principalName = this.userName;
        }
        this.resourcePrincipal = new ResourcePrincipal(principalName);
    }

    private static class ResourcePrincipal
    implements Principal {
        private final String name;

        private ResourcePrincipal(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof ResourcePrincipal) {
                return ((ResourcePrincipal)other).name.equals(this.name);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

