/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.loading.MLet;
import org.jboss.deployment.DeployerMBeanSupport;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.resource.RARDeployerMBean;
import org.jboss.resource.RARMetaData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RARDeployer
extends DeployerMBeanSupport
implements RARDeployerMBean {
    private static int nextNum = 0;
    private Logger category = Logger.getLogger((Class)(class$org$jboss$resource$RARDeployer == null ? (class$org$jboss$resource$RARDeployer = RARDeployer.class$("org.jboss.resource.RARDeployer")) : class$org$jboss$resource$RARDeployer));
    private File rarTmpDir;
    private int nextMessageNum = 0;
    static /* synthetic */ Class class$org$jboss$resource$RARDeployer;

    private static String generateUniqueDirName(URL u) {
        int thisNum = nextNum++;
        return "rar." + thisNum;
    }

    public FilenameFilter getDeployableFilter() {
        return new FilenameFilter(){

            public boolean accept(File dir, String filename) {
                return filename.endsWith(".rar");
            }
        };
    }

    public String getName() {
        return "RARDeployer";
    }

    public RARMetaData getMetaData(String resourceAdapterName) {
        Collection dis = this.getDeployments().values();
        Iterator i = dis.iterator();
        while (i.hasNext()) {
            DeploymentInfo di = (DeploymentInfo)i.next();
            if (!di.metadata.getDisplayName().equals(resourceAdapterName)) continue;
            return di.metadata;
        }
        return null;
    }

    public void initService() throws Exception {
        URL tmpPropURL = this.getClass().getResource("/tmp.properties");
        File tmpDir = new File(tmpPropURL.getFile()).getParentFile();
        File deployTmpDir = new File(tmpDir, "deploy");
        this.rarTmpDir = new File(deployTmpDir, this.getName());
        if (this.rarTmpDir.exists()) {
            this.category.info((Object)"Found a temp directory left over from a previous run - deleting it.");
            if (!this.recursiveDelete(this.rarTmpDir)) {
                this.category.warn((Object)("Unable to recursively delete temp directory '" + this.rarTmpDir + "' that appears to be left over from " + "the previous run. This might cause problems."));
            }
        }
        if (!this.rarTmpDir.exists() && !this.rarTmpDir.mkdirs()) {
            throw new DeploymentException("Can't create temp directory '" + this.rarTmpDir + "'");
        }
    }

    public void destroyService() {
        if (!this.recursiveDelete(this.rarTmpDir)) {
            this.category.warn((Object)("Unable to recursively delete the temp directory '" + this.rarTmpDir + "' - it should be cleaned up when the " + "server is next restarted."));
        }
    }

    protected Object deploy(URL url) throws IOException, DeploymentException {
        this.category.info((Object)("Attempting to deploy RAR at '" + url + "'"));
        String unpackedDirName = RARDeployer.generateUniqueDirName(url);
        File unpackedDir = new File(this.rarTmpDir, unpackedDirName);
        if (unpackedDir.exists()) {
            throw new DeploymentException("The application at URL '" + url + "' " + "appears to already have been " + "deployed because the directory '" + unpackedDir + "' exists");
        }
        unpackedDir.mkdirs();
        if (url.getFile().endsWith("/")) {
            if (!url.getProtocol().equals("file")) {
                throw new DeploymentException("Can only deploy directories specified by 'file:' URLs");
            }
            this.copyDirectory(new File(url.getFile()), unpackedDir);
        } else {
            File copyFile = new File(this.rarTmpDir, "copy" + unpackedDirName);
            InputStream input = url.openStream();
            try {
                FileOutputStream output = new FileOutputStream(copyFile);
                try {
                    this.copy(input, output);
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    ((OutputStream)output).close();
                    throw throwable;
                }
                ((OutputStream)output).close();
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                input.close();
                throw throwable;
            }
            input.close();
            this.inflateJar(copyFile.toURL(), unpackedDir);
        }
        File ddFile = new File(unpackedDir, "META-INF/ra.xml");
        if (!ddFile.exists()) {
            throw new DeploymentException("No deployment descriptor ('META-INF/ra.xml') found in alleged resource adapter at '" + url + "'");
        }
        Document dd = XmlFileLoader.getDocument((URL)ddFile.toURL());
        Element root = dd.getDocumentElement();
        RARMetaData metadata = new RARMetaData();
        metadata.importXml(root);
        ArrayList jars = new ArrayList();
        FileFilter filter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".jar");
            }
        };
        Collection jarFiles = this.recursiveFind(unpackedDir, filter);
        MLet mlet = (MLet)Thread.currentThread().getContextClassLoader();
        this.category.debug((Object)"Adding the following URLs to classpath:");
        Iterator i = jarFiles.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            URL jarUrl = file.toURL();
            this.category.debug((Object)jarUrl.toString());
            mlet.addURL(jarUrl);
        }
        metadata.setClassLoader(mlet);
        Notification notification = new Notification("org.jboss.resource.deployment.deploy", (Object)this, (long)this.nextMessageNum++, metadata.getDisplayName());
        notification.setUserData(metadata);
        ((NotificationBroadcasterSupport)((Object)this)).sendNotification(notification);
        DeploymentInfo info = new DeploymentInfo();
        info.metadata = metadata;
        info.unpackedDir = unpackedDir;
        return info;
    }

    protected void undeploy(URL url, Object o) throws DeploymentException {
        this.category.info((Object)("Undeploying RAR at '" + url + "'"));
        DeploymentInfo info = (DeploymentInfo)o;
        if (info == null) {
            throw new DeploymentException("There doesn't appear to be a RAR deployed at '" + url + "'");
        }
        RARMetaData metadata = info.metadata;
        Notification notification = new Notification("org.jboss.resource.deployment.undeploy", (Object)this, (long)this.nextMessageNum++, metadata.getDisplayName());
        ((NotificationBroadcasterSupport)((Object)this)).sendNotification(notification);
        File unpackedDir = info.unpackedDir;
        if (!this.recursiveDelete(unpackedDir)) {
            this.category.warn((Object)("Unable to recursively delete temp directory '" + unpackedDir + "' - this should be cleaned up either " + "when the server is shut down or when it restarts."));
        }
    }

    private Collection recursiveFind(File dir, FileFilter filter) {
        ArrayList<File> files = new ArrayList<File>();
        File[] candidates = dir.listFiles();
        if (candidates == null) {
            return null;
        }
        int i = 0;
        while (i < candidates.length) {
            File candidate = candidates[i];
            if (candidate.isDirectory()) {
                files.addAll(this.recursiveFind(candidate, filter));
            } else if (filter.accept(candidate)) {
                files.add(candidate);
            }
            ++i;
        }
        return files;
    }

    private void copyDirectory(File srcDir, File destDir) throws DeploymentException, IOException {
        File[] files = srcDir.listFiles();
        if (files == null) {
            throw new DeploymentException("Not a directory: '" + srcDir + "'");
        }
        destDir.mkdirs();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            File dest = new File(destDir, file.getName());
            if (file.isDirectory()) {
                this.copyDirectory(file, dest);
            } else {
                this.copyFile(file, dest);
            }
            ++i;
        }
    }

    private void copyFile(File src, File dest) throws IOException {
        FileInputStream in = new FileInputStream(src);
        try {
            FileOutputStream out = new FileOutputStream(dest);
            try {
                this.copy(in, out);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ((OutputStream)out).close();
                throw throwable;
            }
            ((OutputStream)out).close();
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
    }

    private void inflateJar(URL url, File destDir) throws DeploymentException, IOException {
        URL jarUrl;
        try {
            jarUrl = new URL("jar:" + url.toString() + "!/");
        }
        catch (MalformedURLException mfue) {
            throw new DeploymentException("Oops! Couldn't convert URL to a jar URL", (Throwable)mfue);
        }
        JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
        JarFile jarFile = jarConnection.getJarFile();
        try {
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                Object var15_14;
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                File outFile = new File(destDir, name);
                if (entry.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                InputStream in = jarFile.getInputStream(entry);
                try {
                    Object var13_13;
                    FileOutputStream out = new FileOutputStream(outFile);
                    try {
                        this.copy(in, out);
                        var13_13 = null;
                    }
                    catch (Throwable throwable) {
                        var13_13 = null;
                        ((OutputStream)out).close();
                        throw throwable;
                    }
                    ((OutputStream)out).close();
                    var15_14 = null;
                }
                catch (Throwable throwable) {
                    var15_14 = null;
                    in.close();
                    throw throwable;
                }
                in.close();
                {
                }
            }
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            jarFile.close();
            throw throwable;
        }
        jarFile.close();
    }

    /*
     * WARNING - void declaration
     */
    private void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) > 0) {
            void var4_4;
            out.write(buffer, 0, (int)var4_4);
        }
    }

    private boolean recursiveDelete(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            int i = 0;
            while (i < files.length) {
                if (!this.recursiveDelete(files[i])) {
                    return false;
                }
                ++i;
            }
        }
        return f.delete();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DeploymentInfo {
        public RARMetaData metadata;
        public File unpackedDir;

        private DeploymentInfo() {
        }
    }
}

