/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSServer;

public class ClientConsumer
implements Runnable {
    Logger log;
    JMSServer server;
    ConnectionToken dc;
    boolean enabled;
    boolean closed = false;
    HashMap subscriptions = new HashMap();
    HashMap removedSubscriptions = new HashMap();
    LinkedList blockedSubscriptions = new LinkedList();
    private LinkedList messages = new LinkedList();
    private Thread messagePushThread;
    static /* synthetic */ Class class$org$jboss$mq$server$ClientConsumer;

    public ClientConsumer(JMSServer server, ConnectionToken dc) throws JMSException {
        this.server = server;
        this.dc = dc;
        this.log = Logger.getLogger((String)(String.valueOf((class$org$jboss$mq$server$ClientConsumer != null ? class$org$jboss$mq$server$ClientConsumer : (class$org$jboss$mq$server$ClientConsumer = ClientConsumer.class$("org.jboss.mq.server.ClientConsumer"))).getName()) + ":" + dc.getClientID()));
        this.messagePushThread = new Thread(server.threadGroup, this, "Message Pusher " + dc.getClientID());
        this.messagePushThread.setDaemon(true);
        this.messagePushThread.start();
    }

    public void acknowledge(AcknowledgementRequest request, Tx txId) throws JMSException {
        Subscription sub = (Subscription)this.subscriptions.get(new Integer(request.subscriberId));
        if (sub == null) {
            HashMap hashMap = this.subscriptions;
            synchronized (hashMap) {
                sub = (Subscription)this.removedSubscriptions.get(new Integer(request.subscriberId));
            }
        }
        if (sub == null) {
            throw new JMSException("The provided subscription does not exist");
        }
        JMSDestination queue = this.server.getJMSDestination(sub.destination);
        if (queue == null) {
            throw new JMSException("The subscription's destination(" + sub.destination + ") does not exist");
        }
        queue.acknowledge(request, sub, txId);
    }

    void addBlockedSubscription(Subscription sub) {
        LinkedList linkedList = this.blockedSubscriptions;
        synchronized (linkedList) {
            this.blockedSubscriptions.add(sub);
        }
    }

    public void addSubscription(Subscription req) throws JMSException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Adding subscription for: " + req));
        }
        req.dc = this.dc;
        req.clientConsumer = this;
        JMSDestination jmsdest = this.server.getJMSDestination(req.destination);
        if (jmsdest == null) {
            throw new JMSException("Destination(" + req.destination + ") does not exist !");
        }
        jmsdest.addSubscriber(req);
        HashMap hashMap = this.subscriptions;
        synchronized (hashMap) {
            HashMap subscriptionsClone = (HashMap)this.subscriptions.clone();
            subscriptionsClone.put(new Integer(req.subscriptionId), req);
            this.subscriptions = subscriptionsClone;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void close() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this + "->close()"));
        }
        Cloneable cloneable = this.messages;
        synchronized (cloneable) {
            this.closed = true;
            this.messages.notifyAll();
        }
        cloneable = this.subscriptions;
        synchronized (cloneable) {
            Iterator i = this.subscriptions.keySet().iterator();
            while (i.hasNext()) {
                Integer subscriptionId = (Integer)i.next();
                try {
                    this.removeSubscription(subscriptionId);
                }
                catch (JMSException jMSException) {}
            }
        }
    }

    public void queueMessageForSending(ReceiveRequest r) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("queueMessageForSending: " + r));
        }
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            this.messages.add(r);
            this.messages.notify();
        }
    }

    public SpyMessage receive(int subscriberId, long wait) throws JMSException {
        Subscription req = (Subscription)this.subscriptions.get(new Integer(subscriberId));
        if (req == null) {
            throw new JMSException("The provided subscription(" + subscriberId + ") does not exist");
        }
        JMSDestination queue = this.server.getJMSDestination(req.destination);
        if (queue == null) {
            throw new JMSException("The subscription's destination(" + req.destination + ") does not exist");
        }
        if (this.enabled) {
            return queue.receive(req, wait != -1L);
        }
        if (wait != -1L) {
            this.addBlockedSubscription(req);
        }
        return null;
    }

    void removeRemovedSubscription(int subId) {
        HashMap hashMap = this.subscriptions;
        synchronized (hashMap) {
            this.removedSubscriptions.remove(new Integer(subId));
        }
    }

    public void removeSubscription(int subscriptionId) throws JMSException {
        Subscription req;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this + "->removeSubscription(subscriberId=" + subscriptionId + ")"));
        }
        Integer subId = new Integer(subscriptionId);
        HashMap hashMap = this.subscriptions;
        synchronized (hashMap) {
            HashMap subscriptionsClone = (HashMap)this.subscriptions.clone();
            req = (Subscription)subscriptionsClone.remove(subId);
            this.subscriptions = subscriptionsClone;
            if (req != null) {
                this.removedSubscriptions.put(subId, req);
            }
        }
        if (req == null) {
            throw new JMSException("The subscription had not been previously registered");
        }
        JMSDestination queue = this.server.getJMSDestination(req.destination);
        if (queue == null) {
            throw new JMSException("The subscription was registed with a destination that does not exist !");
        }
        queue.removeSubscriber(req);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this + "->run()"));
        }
        while (true) {
            ReceiveRequest[] job;
            LinkedList linkedList = this.messages;
            synchronized (linkedList) {
                while (true) {
                    if (this.messages.size() != 0) {
                        job = new ReceiveRequest[this.messages.size()];
                        job = this.messages.toArray(job);
                        this.messages.clear();
                        break;
                    }
                    if (this.closed) {
                        return;
                    }
                    try {
                        this.messages.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                this.dc.clientIL.receive(job);
                continue;
            }
            catch (Exception e) {
                this.log.warn((Object)"Could not send messages to a receiver.", (Throwable)e);
                try {
                    this.server.connectionFailure(this.dc);
                    continue;
                }
                catch (Throwable ignore) {
                    this.log.warn((Object)"Could not close the client connection..", ignore);
                    continue;
                }
            }
            break;
        }
    }

    public void setEnabled(boolean enabled) throws JMSException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this + "->setEnabled(enabled=" + enabled + ")"));
        }
        this.enabled = enabled;
        if (enabled) {
            LinkedList linkedList = this.blockedSubscriptions;
            synchronized (linkedList) {
                Iterator it = this.blockedSubscriptions.iterator();
                while (it.hasNext()) {
                    Subscription sub = (Subscription)it.next();
                    JMSDestination dest = this.server.getJMSDestination(sub.destination);
                    if (dest == null) continue;
                    dest.addReceiver(sub);
                }
                this.blockedSubscriptions.clear();
            }
        }
    }

    public String toString() {
        return "ClientConsumer:" + this.dc.getClientID();
    }
}

