/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.selectors.Selector;
import org.jboss.mq.server.BasicQueue;
import org.jboss.mq.server.ClientConsumer;
import org.jboss.mq.server.JMSServer;
import org.jboss.mq.server.PersistentQueue;

public class BasicQueue {
    SortedSet messages = new TreeSet();
    JMSServer server;
    HashSet receivers = new HashSet();
    HashMap unacknowledgedMessages = new HashMap();
    HashMap removedSubscribers = new HashMap();
    Subscription exclusiveSubscription;
    Logger log;
    static /* synthetic */ Class class$org$jboss$mq$server$BasicQueue;

    public BasicQueue(JMSServer server, String description, Subscription exclusiveSubscription) throws JMSException {
        this.server = server;
        this.exclusiveSubscription = exclusiveSubscription;
        this.log = Logger.getLogger((String)(String.valueOf((class$org$jboss$mq$server$BasicQueue != null ? class$org$jboss$mq$server$BasicQueue : (class$org$jboss$mq$server$BasicQueue = BasicQueue.class$("org.jboss.mq.server.BasicQueue"))).getName()) + "." + description));
    }

    static /* synthetic */ void access$0(BasicQueue $0, SpyMessage $1) {
        $0.internalAddMessage($1);
    }

    public void acknowledge(AcknowledgementRequest item, Tx txId) throws JMSException {
        class RestoreMessageTask
        implements Runnable {
            private final /* synthetic */ BasicQueue this$0;
            SpyMessage message;
            int subscriptionId;

            RestoreMessageTask(BasicQueue this$0, SpyMessage m, int subscriptionId) {
                this.this$0 = this$0;
                this.message = m;
                this.subscriptionId = subscriptionId;
            }

            public void run() {
                if (this.this$0.log.isTraceEnabled()) {
                    this.this$0.log.trace((Object)("Restoring message: " + this.message.getJMSMessageID()));
                }
                this.this$0.restoreMessage(this.message);
            }
        }
        RestoreMessageTask task;
        SpyMessage m;
        HashMap hashMap = this.unacknowledgedMessages;
        synchronized (hashMap) {
            m = (SpyMessage)this.unacknowledgedMessages.remove(item);
        }
        this.checkRemovedSubscribers(item.subscriberId);
        if (m == null) {
            return;
        }
        if (!item.isAck) {
            m.setJMSRedelivered(true);
            task = new RestoreMessageTask(this, m, item.subscriberId);
            this.server.getPersistenceManager().getTxManager().addPostCommitTask(txId, task);
        } else {
            if (this instanceof PersistentQueue && m.getJMSDeliveryMode() == 2) {
                this.server.getPersistenceManager().remove(m, txId);
            }
            task = new RestoreMessageTask(this, m, item.subscriberId);
            this.server.getPersistenceManager().getTxManager().addPostRollbackTask(txId, task);
        }
    }

    public void addMessage(SpyMessage mes, Tx txId) throws JMSException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("addMessage: " + mes.getJMSMessageID() + ", txId: " + txId));
        }
        class AddMessagePostCommitTask
        implements Runnable {
            private final /* synthetic */ BasicQueue this$0;
            SpyMessage message;

            AddMessagePostCommitTask(BasicQueue this$0, SpyMessage m) {
                this.this$0 = this$0;
                this.message = m;
            }

            public void run() {
                BasicQueue.access$0(this.this$0, this.message);
            }
        }
        AddMessagePostCommitTask task = new AddMessagePostCommitTask(this, mes);
        this.server.getPersistenceManager().getTxManager().addPostCommitTask(txId, task);
    }

    public void addReceiver(Subscription sub) {
        SortedSet sortedSet = this.messages;
        synchronized (sortedSet) {
            if (this.messages.size() != 0) {
                Iterator it = this.messages.iterator();
                while (it.hasNext()) {
                    SpyMessage message = (SpyMessage)it.next();
                    try {
                        if (!sub.accepts(message)) continue;
                        this.queueMessageForSending(sub, message);
                        it.remove();
                        Object var3_6 = null;
                        return;
                    }
                    catch (JMSException ignore) {
                        this.log.debug((Object)"Caught unusual exception in addReceiver.", (Throwable)ignore);
                    }
                }
            }
        }
        this.addToReceivers(sub);
    }

    protected void addToReceivers(Subscription sub) {
        HashSet hashSet = this.receivers;
        synchronized (hashSet) {
            this.receivers.add(sub);
        }
    }

    public SpyMessage[] browse(String selector) throws JMSException {
        if (selector == null) {
            SpyMessage[] list;
            SortedSet sortedSet = this.messages;
            synchronized (sortedSet) {
                list = new SpyMessage[this.messages.size()];
                list = this.messages.toArray(list);
            }
            return list;
        }
        Selector s = new Selector(selector);
        LinkedList<SpyMessage> selection = new LinkedList<SpyMessage>();
        SortedSet sortedSet = this.messages;
        synchronized (sortedSet) {
            Iterator i = this.messages.iterator();
            while (i.hasNext()) {
                SpyMessage m = (SpyMessage)i.next();
                if (!s.test(m)) continue;
                selection.add(m);
            }
        }
        SpyMessage[] list = new SpyMessage[selection.size()];
        list = selection.toArray(list);
        return list;
    }

    protected void checkRemovedSubscribers(int subId) {
        Integer id = new Integer(subId);
        HashMap hashMap = this.removedSubscribers;
        synchronized (hashMap) {
            if (this.removedSubscribers.containsKey(id) && !this.hasUnackedMessages(subId)) {
                Subscription sub = (Subscription)this.removedSubscribers.remove(id);
                ClientConsumer cc = (ClientConsumer)sub.clientConsumer;
                cc.removeRemovedSubscription(subId);
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void clientConsumerStopped(ClientConsumer clientConsumer) {
        HashSet hashSet = this.receivers;
        synchronized (hashSet) {
            Iterator it = this.receivers.iterator();
            while (it.hasNext()) {
                Subscription sub = (Subscription)it.next();
                if (!sub.clientConsumer.equals(clientConsumer)) continue;
                clientConsumer.addBlockedSubscription(sub);
                it.remove();
            }
        }
    }

    public void destroy() throws JMSException {
        HashMap hashMap = this.unacknowledgedMessages;
        synchronized (hashMap) {
            Iterator i = ((HashMap)this.unacknowledgedMessages.clone()).keySet().iterator();
            while (i.hasNext()) {
                AcknowledgementRequest item = (AcknowledgementRequest)i.next();
                try {
                    this.acknowledge(item, null);
                }
                catch (JMSException jMSException) {}
            }
        }
    }

    protected boolean hasUnackedMessages(int sub) {
        HashMap hashMap = this.unacknowledgedMessages;
        synchronized (hashMap) {
            Iterator it = this.unacknowledgedMessages.keySet().iterator();
            while (it.hasNext()) {
                AcknowledgementRequest ack = (AcknowledgementRequest)it.next();
                if (ack.subscriberId != sub) continue;
                boolean bl = true;
                Object var4_7 = null;
                return bl;
            }
            boolean bl = false;
            Object var4_8 = null;
            return bl;
        }
    }

    private void internalAddMessage(SpyMessage message) {
        boolean trace = this.log.isTraceEnabled();
        try {
            if (this.exclusiveSubscription != null && !this.exclusiveSubscription.accepts(message)) {
                if (trace) {
                    this.log.trace((Object)("Dropping msg:" + message.getJMSMessageID() + " due to exclusiveSubscription"));
                }
                return;
            }
            HashSet hashSet = this.receivers;
            synchronized (hashSet) {
                Object it;
                if (!this.receivers.isEmpty()) {
                    it = this.receivers.iterator();
                    while (it.hasNext()) {
                        Subscription sub = (Subscription)it.next();
                        if (!sub.accepts(message)) continue;
                        this.queueMessageForSending(sub, message);
                        it.remove();
                        Object var4_7 = null;
                        return;
                    }
                }
                it = this.messages;
                synchronized (it) {
                    if (trace) {
                        this.log.trace((Object)("No active subscribers, queing msg:" + message.getJMSMessageID()));
                    }
                    this.messages.add(message);
                }
            }
        }
        catch (JMSException e) {
            this.log.error((Object)"Caught unusual exception in internalAddMessage.", (Throwable)e);
        }
    }

    protected void queueMessageForSending(Subscription sub, SpyMessage message) throws JMSException {
        this.setupMessageAcknowledgement(sub, message);
        ReceiveRequest r = new ReceiveRequest();
        r.message = message;
        r.subscriptionId = new Integer(sub.subscriptionId);
        ClientConsumer cc = (ClientConsumer)sub.clientConsumer;
        cc.queueMessageForSending(r);
    }

    public SpyMessage receive(Subscription sub, boolean wait) throws JMSException {
        SpyMessage message = null;
        Selector selector = sub.getSelector();
        HashSet hashSet = this.receivers;
        synchronized (hashSet) {
            if (selector == null) {
                SortedSet sortedSet = this.messages;
                synchronized (sortedSet) {
                    if (this.messages.size() != 0) {
                        message = (SpyMessage)this.messages.first();
                        this.messages.remove(message);
                    }
                }
            }
            SortedSet sortedSet = this.messages;
            synchronized (sortedSet) {
                Iterator i = this.messages.iterator();
                while (i.hasNext()) {
                    SpyMessage m = (SpyMessage)i.next();
                    if (!selector.test(m)) continue;
                    message = m;
                    this.messages.remove(message);
                    break;
                }
            }
            if (message == null) {
                if (wait) {
                    this.addToReceivers(sub);
                }
            } else {
                this.setupMessageAcknowledgement(sub, message);
            }
        }
        return message;
    }

    public void removeReceiver(Subscription sub) {
        HashSet hashSet = this.receivers;
        synchronized (hashSet) {
            this.receivers.remove(sub);
        }
    }

    public void removeSubscriber(Subscription sub) {
        this.removeReceiver(sub);
        if (this.hasUnackedMessages(sub.subscriptionId)) {
            HashMap hashMap = this.removedSubscribers;
            synchronized (hashMap) {
                this.removedSubscribers.put(new Integer(sub.subscriptionId), sub);
            }
        } else {
            ((ClientConsumer)sub.clientConsumer).removeRemovedSubscription(sub.subscriptionId);
        }
    }

    public void restoreMessage(SpyMessage mes) {
        this.internalAddMessage(mes);
    }

    protected void setupMessageAcknowledgement(Subscription sub, SpyMessage message) {
        AcknowledgementRequest ack = new AcknowledgementRequest();
        ack.destination = message.getJMSDestination();
        ack.messageID = message.getJMSMessageID();
        ack.subscriberId = sub.subscriptionId;
        ack.isAck = false;
        HashMap hashMap = this.unacknowledgedMessages;
        synchronized (hashMap) {
            this.unacknowledgedMessages.put(ack, message);
        }
    }
}

