/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.selectors;

import java.util.HashMap;
import java.util.Iterator;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.selectors.Identifier;
import org.jboss.mq.selectors.Operator;
import org.jboss.mq.selectors.parser;

public class Selector {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$selectors$Selector != null ? class$org$jboss$mq$selectors$Selector : (class$org$jboss$mq$selectors$Selector = Selector.class$("org.jboss.mq.selectors.Selector"))));
    public HashMap identifiers;
    public Object result;
    static /* synthetic */ Class class$org$jboss$mq$selectors$Selector;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$org$jboss$mq$selectors$Identifier;
    static /* synthetic */ Class class$org$jboss$mq$selectors$Operator;

    public Selector(String sel) throws JMSException {
        parser bob = new parser();
        this.identifiers = new HashMap();
        try {
            this.result = bob.parse(sel, this.identifiers);
        }
        catch (Exception e) {
            InvalidSelectorException exception = new InvalidSelectorException("The selector is invalid:" + sel);
            exception.setLinkedException(e);
            throw exception;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private Object getHeaderFieldReferences(SpyMessage msg, String idName) throws JMSException {
        if (idName.equals("JMSDeliveryMode")) {
            return new Integer(msg.getJMSDeliveryMode());
        }
        if (idName.equals("JMSPriority")) {
            return new Integer(msg.getJMSPriority());
        }
        if (idName.equals("JMSMessageID")) {
            return msg.getJMSMessageID();
        }
        if (idName.equals("JMSTimestamp")) {
            return new Long(msg.getJMSTimestamp());
        }
        if (idName.equals("JMSCorrelationID")) {
            return msg.getJMSCorrelationID();
        }
        if (idName.equals("JMSType")) {
            return msg.getJMSType();
        }
        return null;
    }

    public boolean test(SpyMessage mes) throws JMSException {
        try {
            Iterator i = this.identifiers.values().iterator();
            while (i.hasNext()) {
                Identifier id = (Identifier)i.next();
                Object find = mes.getObjectProperty(id.name);
                if (find == null) {
                    find = this.getHeaderFieldReferences(mes, id.name);
                }
                if (find == null) {
                    log.debug((Object)("Warning : missing property " + id.name));
                    id.value = null;
                    continue;
                }
                Class<?> type = find.getClass();
                if (type.equals(class$java$lang$Boolean != null ? class$java$lang$Boolean : Selector.class$("java.lang.Boolean")) || type.equals(class$java$lang$String != null ? class$java$lang$String : Selector.class$("java.lang.String")) || type.equals(class$java$lang$Double != null ? class$java$lang$Double : Selector.class$("java.lang.Double")) || type.equals(class$java$lang$Float != null ? class$java$lang$Float : Selector.class$("java.lang.Float")) || type.equals(class$java$lang$Integer != null ? class$java$lang$Integer : Selector.class$("java.lang.Integer")) || type.equals(class$java$lang$Long != null ? class$java$lang$Long : Selector.class$("java.lang.Long")) || type.equals(class$java$lang$Short != null ? class$java$lang$Short : Selector.class$("java.lang.Short")) || type.equals(class$java$lang$Byte != null ? class$java$lang$Byte : Selector.class$("java.lang.Byte"))) {
                    id.value = find;
                    continue;
                }
                throw new Exception("Bad property type !");
            }
            Object res = this.result.getClass().equals(class$org$jboss$mq$selectors$Identifier != null ? class$org$jboss$mq$selectors$Identifier : (class$org$jboss$mq$selectors$Identifier = Selector.class$("org.jboss.mq.selectors.Identifier"))) ? ((Identifier)this.result).value : (this.result.getClass().equals(class$org$jboss$mq$selectors$Operator != null ? class$org$jboss$mq$selectors$Operator : (class$org$jboss$mq$selectors$Operator = Selector.class$("org.jboss.mq.selectors.Operator"))) ? ((Operator)this.result).apply() : this.result);
            if (res == null) {
                return false;
            }
            if (!res.getClass().equals(class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = Selector.class$("java.lang.Boolean")))) {
                throw new Exception("Bad object type");
            }
            return (Boolean)res;
        }
        catch (Exception e) {
            throw new JMSException("SELECTOR: " + e.getMessage());
        }
    }
}

