/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.rollinglogged;

import java.io.IOException;
import java.util.TreeSet;
import javax.jms.JMSException;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.rollinglogged.IntegrityLog;

public class SpyTxLog {
    private IntegrityLog transactionLog;
    private int liveTransactionCount = 0;
    private Object counterLock = new Object();

    public SpyTxLog(String fileName) throws JMSException {
        try {
            this.transactionLog = new IntegrityLog(fileName);
        }
        catch (IOException e) {
            this.throwJMSException("Could not open the queue's tranaction log: " + fileName, e);
        }
    }

    public synchronized void close() throws JMSException {
        try {
            this.transactionLog.close();
        }
        catch (IOException e) {
            this.throwJMSException("Could not close the queue's tranaction log.", e);
        }
    }

    public synchronized void commitTx(Tx id) throws JMSException {
        try {
            this.transactionLog.addTx(id);
            this.transactionLog.commit();
            Object object = this.counterLock;
            synchronized (object) {
                --this.liveTransactionCount;
            }
        }
        catch (IOException e) {
            this.throwJMSException("Could not create a new transaction.", e);
        }
    }

    public boolean completed() throws JMSException {
        Object object = this.counterLock;
        synchronized (object) {
            boolean bl = this.liveTransactionCount == 0;
            Object var3_3 = null;
            return bl;
        }
    }

    public void createTx() throws JMSException {
        Object object = this.counterLock;
        synchronized (object) {
            ++this.liveTransactionCount;
        }
    }

    public synchronized void delete() throws JMSException {
        try {
            this.transactionLog.delete();
        }
        catch (IOException e) {
            this.throwJMSException("Could not delete the queue's tranaction log.", e);
        }
    }

    public synchronized void restore(TreeSet result) throws JMSException {
        try {
            result.addAll(this.transactionLog.toTreeSet());
        }
        catch (Exception e) {
            this.throwJMSException("Could not restore the transaction log.", e);
        }
    }

    public void rollbackTx(Tx txId) throws JMSException {
        Object object = this.counterLock;
        synchronized (object) {
            --this.liveTransactionCount;
        }
    }

    private void throwJMSException(String message, Exception e) throws JMSException {
        SpyJMSException newE = new SpyJMSException(message);
        newE.setLinkedException(e);
        throw newE;
    }
}

