/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.logged;

import java.io.IOException;
import java.util.Iterator;
import java.util.TreeSet;
import javax.jms.JMSException;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.logged.ObjectIntegrityLog;

public class SpyTxLog {
    private ObjectIntegrityLog transactionLog;
    private long nextTransactionId = Long.MIN_VALUE;

    public SpyTxLog(String fileName) throws JMSException {
        try {
            this.transactionLog = new ObjectIntegrityLog(fileName);
        }
        catch (IOException e) {
            this.throwJMSException("Could not open the queue's tranaction log: " + fileName, e);
        }
    }

    public synchronized void close() throws JMSException {
        try {
            this.transactionLog.close();
        }
        catch (IOException e) {
            this.throwJMSException("Could not close the queue's tranaction log.", e);
        }
    }

    public synchronized void commitTx(Tx id) throws JMSException {
        try {
            this.transactionLog.add(id);
            this.transactionLog.commit();
        }
        catch (IOException e) {
            this.throwJMSException("Could not create a new transaction.", e);
        }
    }

    public synchronized Tx createTx() throws JMSException {
        return new Tx(this.nextTransactionId++);
    }

    public synchronized TreeSet restore() throws JMSException {
        TreeSet items = null;
        try {
            items = this.transactionLog.toTreeSet();
        }
        catch (Exception e) {
            this.throwJMSException("Could not restore the transaction log.", e);
        }
        long maxId = Long.MIN_VALUE;
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            Long l = (Long)iter.next();
            if (l <= maxId) continue;
            maxId = l;
        }
        this.nextTransactionId = maxId + 1L;
        return items;
    }

    public synchronized void rollbackTx(Tx txId) throws JMSException {
    }

    private void throwJMSException(String message, Exception e) throws JMSException {
        SpyJMSException newE = new SpyJMSException(message);
        newE.setLinkedException(e);
        throw newE;
    }
}

