/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.logged;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.Vector;
import org.jboss.mq.pm.logged.IntegrityLog;

public class ObjectIntegrityLog {
    private IntegrityLog.LogOutputStream logOutputStream;
    private ObjectOutputStream out;
    private IntegrityLog transactionLog;

    public ObjectIntegrityLog(String fileName) throws IOException {
        this.transactionLog = new IntegrityLog(fileName);
        this.logOutputStream = this.transactionLog.getOutputStream();
        this.out = new MyObjectOutputStream(this.logOutputStream);
    }

    public IndexItem add(Object o) throws IOException {
        IndexItem item = new IndexItem();
        item.record = o;
        item.recordOffset = this.logOutputStream.getFilePointer();
        this.out.writeObject(o);
        this.out.reset();
        this.out.flush();
        return item;
    }

    public void close() throws IOException {
        this.transactionLog.close();
    }

    public void commit() throws IOException {
        this.transactionLog.commit();
    }

    public void rollback() throws IOException {
        this.transactionLog.rollback();
    }

    public Object[] toArray() throws IOException, ClassNotFoundException {
        LinkedList<Object> ll = new LinkedList<Object>();
        MyObjectInputStream in = new MyObjectInputStream(new BufferedInputStream(this.transactionLog.getInputStream()));
        try {
            while (true) {
                Object o = in.readObject();
                ll.addLast(o);
            }
        }
        catch (EOFException eOFException) {
            in.close();
            Object[] rc = new Object[ll.size()];
            return ll.toArray(rc);
        }
    }

    public HashSet toHashSet() throws IOException, ClassNotFoundException {
        HashSet<Object> hash = new HashSet<Object>();
        MyObjectInputStream in = new MyObjectInputStream(new BufferedInputStream(this.transactionLog.getInputStream()));
        try {
            while (true) {
                Object o = in.readObject();
                hash.add(o);
            }
        }
        catch (EOFException eOFException) {
            in.close();
            return hash;
        }
    }

    public IndexItem[] toIndex() throws IOException, ClassNotFoundException {
        LinkedList<IndexItem> ll = new LinkedList<IndexItem>();
        IntegrityLog.LogInputStream logStream = this.transactionLog.getInputStream();
        MyObjectInputStream in = new MyObjectInputStream(logStream);
        try {
            while (true) {
                IndexItem i = new IndexItem();
                i.recordOffset = logStream.getFilePointer();
                i.record = in.readObject();
                ll.addLast(i);
            }
        }
        catch (EOFException eOFException) {
            in.close();
            IndexItem[] rc = new IndexItem[ll.size()];
            return ll.toArray(rc);
        }
    }

    public TreeSet toTreeSet() throws IOException, ClassNotFoundException {
        TreeSet<Object> treeSet = new TreeSet<Object>();
        MyObjectInputStream in = new MyObjectInputStream(new BufferedInputStream(this.transactionLog.getInputStream()));
        try {
            while (true) {
                Object o = in.readObject();
                treeSet.add(o);
            }
        }
        catch (EOFException eOFException) {
            in.close();
            return treeSet;
        }
    }

    public Vector toVector() throws IOException, ClassNotFoundException {
        Vector<Object> vector = new Vector<Object>();
        MyObjectInputStream in = new MyObjectInputStream(new BufferedInputStream(this.transactionLog.getInputStream()));
        try {
            while (true) {
                Object o = in.readObject();
                vector.add(o);
            }
        }
        catch (EOFException eOFException) {
            in.close();
            return vector;
        }
    }

    static class IndexItem {
        long recordOffset;
        Object record;

        IndexItem() {
        }
    }

    static class MyObjectOutputStream
    extends ObjectOutputStream {
        MyObjectOutputStream(OutputStream os) throws IOException {
            super(os);
        }

        protected void writeStreamHeader() {
        }
    }

    static class MyObjectInputStream
    extends ObjectInputStream {
        MyObjectInputStream(InputStream is) throws IOException {
            super(is);
        }

        protected void readStreamHeader() {
        }
    }
}

