/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.logged;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class IntegrityLog {
    private long firstRecordPos;
    private long nextRecordPos;
    private byte[] headerBytes = new byte[16];
    private RandomAccessFile raf;
    private LogOutputStream outputStream;
    private LogInputStream inputStream;
    private static final int HEADER_SIZE = 16;

    public IntegrityLog(String fileName) throws IOException {
        File f = new File(fileName);
        boolean exists = f.isFile();
        this.raf = new RandomAccessFile(f, "rw");
        if (exists) {
            this.loadHeader();
        } else {
            this.initHeader();
        }
    }

    public void close() throws IOException {
        this.raf.close();
        this.raf = null;
    }

    public void commit() throws IOException {
        this.headerBytes[0] = (byte)(this.firstRecordPos >>> 56 & 0xFFL);
        this.headerBytes[1] = (byte)(this.firstRecordPos >>> 48 & 0xFFL);
        this.headerBytes[2] = (byte)(this.firstRecordPos >>> 40 & 0xFFL);
        this.headerBytes[3] = (byte)(this.firstRecordPos >>> 32 & 0xFFL);
        this.headerBytes[4] = (byte)(this.firstRecordPos >>> 24 & 0xFFL);
        this.headerBytes[5] = (byte)(this.firstRecordPos >>> 16 & 0xFFL);
        this.headerBytes[6] = (byte)(this.firstRecordPos >>> 8 & 0xFFL);
        this.headerBytes[7] = (byte)(this.firstRecordPos & 0xFFL);
        this.headerBytes[8] = (byte)(this.nextRecordPos >>> 56 & 0xFFL);
        this.headerBytes[9] = (byte)(this.nextRecordPos >>> 48 & 0xFFL);
        this.headerBytes[10] = (byte)(this.nextRecordPos >>> 40 & 0xFFL);
        this.headerBytes[11] = (byte)(this.nextRecordPos >>> 32 & 0xFFL);
        this.headerBytes[12] = (byte)(this.nextRecordPos >>> 24 & 0xFFL);
        this.headerBytes[13] = (byte)(this.nextRecordPos >>> 16 & 0xFFL);
        this.headerBytes[14] = (byte)(this.nextRecordPos >>> 8 & 0xFFL);
        this.headerBytes[15] = (byte)(this.nextRecordPos & 0xFFL);
        this.raf.seek(0L);
        this.raf.write(this.headerBytes);
    }

    private long getBytesLeft(long offset) {
        return this.nextRecordPos - offset;
    }

    public LogInputStream getInputStream() {
        if (this.inputStream == null || this.inputStream.closed) {
            this.inputStream = new LogInputStream();
        }
        return this.inputStream;
    }

    public LogOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null || this.outputStream.closed) {
            this.outputStream = new LogOutputStream();
        }
        return this.outputStream;
    }

    private void initHeader() throws IOException {
        this.firstRecordPos = 16L;
        this.nextRecordPos = 16L;
        this.commit();
    }

    private void loadHeader() throws IOException {
        this.raf.seek(0L);
        this.firstRecordPos = this.raf.readLong();
        this.nextRecordPos = this.raf.readLong();
    }

    private int read(long offset) throws IOException {
        if (offset >= this.nextRecordPos) {
            return -1;
        }
        if (this.raf.getFilePointer() != offset) {
            this.raf.seek(offset);
        }
        int rc = this.raf.read();
        return rc;
    }

    private int read(long offset, byte[] bytes, int off, int len) throws IOException {
        if (offset >= this.nextRecordPos) {
            return -1;
        }
        len = (int)Math.min((long)len, this.getBytesLeft(offset));
        if (this.raf.getFilePointer() != offset) {
            this.raf.seek(offset);
        }
        int rc = this.raf.read(bytes, off, len);
        return rc;
    }

    public void rollback() throws IOException {
        this.loadHeader();
    }

    private void write(byte b) throws IOException {
        if (this.raf.getFilePointer() != this.nextRecordPos) {
            this.raf.seek(this.nextRecordPos);
        }
        this.raf.write(b);
        ++this.nextRecordPos;
    }

    private void write(byte[] record, int off, int len) throws IOException {
        if (this.raf.getFilePointer() != this.nextRecordPos) {
            this.raf.seek(this.nextRecordPos);
        }
        this.raf.write(record, off, len);
        this.nextRecordPos += (long)len;
    }

    class LogInputStream
    extends InputStream {
        boolean closed = false;
        long inputPos = 0L;

        LogInputStream() {
        }

        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        public long getFilePointer() {
            return this.inputPos;
        }

        public int read() throws IOException {
            this.inputPos = Math.max(this.inputPos, IntegrityLog.this.firstRecordPos);
            int rc = IntegrityLog.this.read(this.inputPos);
            if (rc >= 0) {
                ++this.inputPos;
            }
            return rc;
        }

        public int read(byte[] bytes, int off, int len) throws IOException {
            this.inputPos = Math.max(this.inputPos, IntegrityLog.this.firstRecordPos);
            int rc = IntegrityLog.this.read(this.inputPos, bytes, off, len);
            if (rc >= 0) {
                this.inputPos += (long)rc;
            }
            return rc;
        }
    }

    class LogOutputStream
    extends OutputStream {
        boolean closed = false;

        LogOutputStream() {
        }

        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        public long getFilePointer() {
            return IntegrityLog.this.nextRecordPos;
        }

        public void write(int b) throws IOException {
            IntegrityLog.this.write((byte)b);
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            IntegrityLog.this.write(bytes, off, len);
        }
    }
}

