/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TreeSet;
import javax.jms.JMSException;
import javax.sql.DataSource;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.pm.Tx;

public class TxLog {
    protected long nextTransactionId = Long.MIN_VALUE;
    protected static DataSource ds = null;

    public TxLog(DataSource datasource) throws JMSException {
        if (ds == null) {
            ds = datasource;
        }
    }

    public synchronized void commitTx(Tx txId) throws JMSException {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement("delete from jms_transactions where id = ?");
            String hexString = null;
            long id = txId.longValue();
            hexString = id <= 0L ? "-" + Long.toHexString(-1L * id) : Long.toHexString(id);
            stmt.setString(1, hexString);
            stmt.executeUpdate();
            con.commit();
        }
        catch (SQLException e) {
            this.throwJMSException("Could not write transaction log on commit.", e);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            this.throwJMSException("Could not close database connection in transaction log (commitTx)", e);
        }
    }

    public synchronized Tx createTx() throws JMSException {
        Tx id = new Tx(this.nextTransactionId++);
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement("insert into jms_transactions values(?)");
            String hexString = null;
            long lId = id.longValue();
            hexString = lId <= 0L ? "-" + Long.toHexString(-1L * lId) : Long.toHexString(lId);
            stmt.setString(1, hexString);
            stmt.executeUpdate();
            con.commit();
        }
        catch (SQLException e) {
            this.throwJMSException("Could not write transaction log on commit.", e);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            this.throwJMSException("Could not close database connection in transaction log (createTx).", e);
        }
        return id;
    }

    private final Connection getConnection() throws SQLException {
        return ds.getConnection();
    }

    public synchronized TreeSet restore() throws JMSException {
        TreeSet<Long> items = new TreeSet<Long>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("select  id from jms_transactions");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    long id = Long.parseLong(rs.getString(1).trim(), 16);
                    items.add(new Long(id));
                }
            }
            catch (SQLException e) {
                this.throwJMSException("Could not write transaction log on commit.", e);
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                this.throwJMSException("Could not close database connection in transaction log (restore)", e);
            }
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            this.throwJMSException("Could not close database connection in transaction log (restore)", e);
        }
        return items;
    }

    public synchronized void rollbackTx(Tx txId) throws JMSException {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            stmt = con.prepareStatement("delete from jms_transactions where id = ?");
            String hexString = null;
            long id = txId.longValue();
            hexString = id <= 0L ? "-" + Long.toHexString(-1L * id) : Long.toHexString(id);
            stmt.setString(1, hexString);
            stmt.executeUpdate();
            con.commit();
        }
        catch (SQLException e) {
            this.throwJMSException("Could not write transaction log on commit.", e);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            this.throwJMSException("Could not close database connection in transaction log (rollbackTx)", e);
        }
    }

    private void throwJMSException(String message, Exception e) throws JMSException {
        SpyJMSException newE = new SpyJMSException(message);
        newE.setLinkedException(e);
        throw newE;
    }
}

