/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.cluster.transport.udp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.apache.log4j.Category;
import org.jboss.mq.cluster.transport.udp.Datagram;
import org.jboss.mq.cluster.transport.udp.UDPTransport;

class UDPAdminStream
implements Runnable {
    UDPTransport transport;
    DatagramSocket socket;
    private Thread runningThread;
    private boolean done = false;
    private int nextDatagramId = 0;
    static Category cat = Category.getInstance((Class)(class$org$jboss$mq$cluster$transport$udp$UDPAdminStream != null ? class$org$jboss$mq$cluster$transport$udp$UDPAdminStream : (class$org$jboss$mq$cluster$transport$udp$UDPAdminStream = UDPAdminStream.class$("org.jboss.mq.cluster.transport.udp.UDPAdminStream"))));
    static /* synthetic */ Class class$org$jboss$mq$cluster$transport$udp$UDPAdminStream;

    UDPAdminStream() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private synchronized void fragmentArrived(Datagram dg) throws InterruptedException {
        this.transport.datagramArrived(dg);
    }

    protected int getNextDatagramId() {
        return this.nextDatagramId++;
    }

    public void run() {
        try {
            byte[] buffer = new byte[this.transport.maxFragmentSize + 17];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            this.socket.setSoTimeout(2000);
            while (!this.done) {
                try {
                    packet.setData(buffer);
                    packet.setLength(buffer.length);
                    this.socket.receive(packet);
                    if (packet.getLength() < 17) {
                        cat.info((Object)("[" + this + "] Packet was too small, dropping."));
                        continue;
                    }
                    Datagram dg = new Datagram(packet.getData(), packet.getLength());
                    dg.getSenderId().address = packet.getAddress();
                    if (this.transport.nodeId.equals(dg.getSenderId())) continue;
                    this.fragmentArrived(dg);
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    synchronized void start() {
        if (this.runningThread != null) {
            return;
        }
        this.done = false;
        this.runningThread = new Thread((Runnable)this, "UDPAdminStream");
        this.runningThread.start();
    }

    synchronized void stop() throws InterruptedException {
        if (this.runningThread == null) {
            return;
        }
        this.done = true;
        this.runningThread.interrupt();
        this.runningThread.join();
        this.runningThread = null;
    }

    public String toString() {
        return "org.jboss.mq.cluster.udp.UDPAdminStream";
    }
}

