/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.cluster.transport;

public class SerializerUtil {
    public static void main(String[] args) {
        byte[] data = new byte[8];
        int i = -10;
        while (i < 150) {
            SerializerUtil.writeIntTo(i, data, 0);
            int r = SerializerUtil.readIntFrom(data, 0);
            System.out.println("Int :" + i + "==" + r);
            ++i;
        }
        long i2 = -10L;
        while (i2 < 150L) {
            SerializerUtil.writeLongTo(i2, data, 0);
            long r = SerializerUtil.readLongFrom(data, 0);
            System.out.println("Long :" + i2 + "==" + r);
            ++i2;
        }
    }

    public static int readIntFrom(byte[] data, int offset) {
        return (data[offset] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF;
    }

    public static long readLongFrom(byte[] data, int offset) {
        return (long)(data[offset] & 0xFF) << 56 | (long)(data[offset + 1] & 0xFF) << 48 | (long)(data[offset + 2] & 0xFF) << 40 | (long)(data[offset + 3] & 0xFF) << 32 | (long)(data[offset + 4] & 0xFF) << 24 | (long)(data[offset + 5] & 0xFF) << 16 | (long)(data[offset + 6] & 0xFF) << 8 | (long)(data[offset + 7] & 0xFF);
    }

    public static short readShortFrom(byte[] data, int offset) {
        return (short)(data[offset] << 8 & 0xFF | data[offset + 1] & 0xFF);
    }

    public static int readUShortFrom(byte[] data, int offset) {
        return (data[offset] & 0xFF) << 8 | data[offset + 1] & 0xFF;
    }

    public static void writeIntTo(int v, byte[] data, int pos) {
        data[pos] = (byte)(v >>> 24 & 0xFF);
        data[pos + 1] = (byte)(v >>> 16 & 0xFF);
        data[pos + 2] = (byte)(v >>> 8 & 0xFF);
        data[pos + 3] = (byte)(v & 0xFF);
    }

    public static void writeLongTo(long v, byte[] data, int pos) {
        data[pos] = (byte)(v >>> 56 & 0xFFL);
        data[pos + 1] = (byte)(v >>> 48 & 0xFFL);
        data[pos + 2] = (byte)(v >>> 40 & 0xFFL);
        data[pos + 3] = (byte)(v >>> 32 & 0xFFL);
        data[pos + 4] = (byte)(v >>> 24 & 0xFFL);
        data[pos + 5] = (byte)(v >>> 16 & 0xFFL);
        data[pos + 6] = (byte)(v >>> 8 & 0xFFL);
        data[pos + 7] = (byte)(v & 0xFFL);
    }

    public static void writeShortTo(short v, byte[] data, int pos) {
        data[pos] = (byte)(v >>> 8 & 0xFF);
        data[pos + 1] = (byte)(v & 0xFF);
    }

    public static void writeUShortTo(int v, byte[] data, int pos) {
        data[pos] = (byte)(v >>> 8 & 0xFF);
        data[pos + 1] = (byte)(v & 0xFF);
    }
}

