/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.cluster.jms;

import java.io.InputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.cluster.jms.ClusterTopicConnection;
import org.jboss.mq.xml.XElement;

public class ClusterTopicConnectionFactory
implements Serializable,
TopicConnectionFactory {
    private XElement serverXElement;

    public ClusterTopicConnectionFactory() throws Exception {
        InputStream in = this.getClass().getClassLoader().getResource("jbossmq-cluster.xml").openStream();
        this.serverXElement = XElement.createFrom(in);
        in.close();
        if (!this.serverXElement.getName().equals("Server")) {
            throw new JMSException("The jbossmq-cluster.xml file is invalid.");
        }
    }

    public TopicConnection createTopicConnection() throws JMSException {
        try {
            return new ClusterTopicConnection(this.serverXElement);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpyJMSException("ClusterTopicConnection creation has failed !", e);
        }
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return this.createTopicConnection();
    }
}

