/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubcriptionID;
import org.jboss.mq.GenericConnectionFactory;
import org.jboss.mq.ReceiveRequest;
import org.jboss.mq.SpyConnectionMetaData;
import org.jboss.mq.SpyConsumer;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpySession;
import org.jboss.mq.SpyXAResourceManager;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.il.ClientILService;
import org.jboss.mq.il.ServerIL;

public class Connection
implements Serializable,
javax.jms.Connection {
    static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$Connection != null ? class$org$jboss$mq$Connection : (class$org$jboss$mq$Connection = Connection.class$("org.jboss.mq.Connection"))));
    public HashMap destinationSubscriptions = new HashMap();
    public HashMap subscriptions = new HashMap();
    public boolean modeStop;
    protected ServerIL serverIL;
    protected String clientID;
    protected ConnectionToken connectionToken;
    protected ClientILService clientILService;
    protected static ClockDaemon clockDaemon = new ClockDaemon();
    protected long pingPeriod = 60000L;
    protected boolean ponged = true;
    protected boolean pingFailed = false;
    Semaphore pingTaskSemaphore = new Semaphore(1L);
    Object pingTaskId;
    protected volatile boolean closing = false;
    HashSet createdSessions;
    int subscriptionCounter = Integer.MIN_VALUE;
    boolean closed;
    SpyXAResourceManager spyXAResourceManager;
    GenericConnectionFactory genericConnectionFactory;
    private int lastMessageID;
    private ExceptionListener exceptionListener;
    private StringBuffer sb = new StringBuffer();
    private char[] charStack = new char[22];
    public static ThreadGroup threadGroup = new ThreadGroup("JBossMQ Client Threads");
    static /* synthetic */ Class class$org$jboss$mq$Connection;

    static {
        log.debug((Object)"Setting the clockDaemon's thread factory");
        clockDaemon.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(threadGroup, r, "Connection Monitor Thread");
                t.setDaemon(true);
                return t;
            }
        });
    }

    Connection(String userName, String password, GenericConnectionFactory genericConnectionFactory) throws JMSException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Connection Initializing");
        }
        this.createdSessions = new HashSet();
        this.connectionToken = null;
        this.closed = false;
        this.lastMessageID = 0;
        this.modeStop = true;
        if (trace) {
            log.trace((Object)"Getting the serverIL");
        }
        this.genericConnectionFactory = genericConnectionFactory;
        this.serverIL = genericConnectionFactory.createServerIL();
        if (trace) {
            log.trace((Object)"Authenticating");
        }
        if (userName != null) {
            this.askForAnID(userName, password);
        }
        if (this.clientID == null) {
            this.askForAnID();
        }
        if (trace) {
            log.trace((Object)"Starting the clientIL service");
        }
        this.startILService();
        this.spyXAResourceManager = new SpyXAResourceManager(this);
        this.startPingThread();
        if (trace) {
            log.trace((Object)"Connection establishment successful");
        }
    }

    Connection(GenericConnectionFactory genericConnectionFactory) throws JMSException {
        this(null, null, genericConnectionFactory);
    }

    void addConsumer(SpyConsumer consumer) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        Subscription req = consumer.getSubscription();
        req.subscriptionId = this.subscriptionCounter++;
        req.dc = this.connectionToken;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Connection: addConsumer(dest=" + req.destination.toString() + ")"));
        }
        try {
            HashMap hashMap = this.subscriptions;
            synchronized (hashMap) {
                this.subscriptions.put(new Integer(req.subscriptionId), consumer);
                LinkedList<SpyConsumer> ll = (LinkedList<SpyConsumer>)this.destinationSubscriptions.get(req.destination);
                if (ll == null) {
                    ll = new LinkedList<SpyConsumer>();
                    this.destinationSubscriptions.put(req.destination, ll);
                }
                ll.add(consumer);
            }
            this.serverIL.subscribe(this.connectionToken, req);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot subscribe to this Destination: " + e.getMessage(), e);
        }
    }

    protected void askForAnID() throws JMSException {
        try {
            this.clientID = this.serverIL.getID();
        }
        catch (Exception e) {
            log.debug((Object)"Server Exception: ", (Throwable)e);
            throw new SpyJMSException("Cannot get a client ID: " + e.getMessage(), e);
        }
    }

    protected void askForAnID(String userName, String password) throws JMSException {
        try {
            this.clientID = this.serverIL.checkUser(userName, password);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot get a client ID", e);
        }
    }

    public void asynchClose() {
    }

    public void asynchDeleteTemporaryDestination(SpyDestination dest) {
        try {
            this.deleteTemporaryDestination(dest);
        }
        catch (JMSException e) {
            this.asynchFailure(e.getMessage(), e.getLinkedException());
        }
    }

    public void asynchDeliver(ReceiveRequest[] requests) {
        boolean trace = log.isTraceEnabled();
        try {
            int i = 0;
            while (i < requests.length) {
                SpyConsumer consumer = (SpyConsumer)this.subscriptions.get(requests[i].subscriptionId);
                if (consumer == null) {
                    this.send(requests[i].message.getAcknowledgementRequest(false));
                    if (trace) {
                        log.trace((Object)"WARNING: NACK issued due to non existent subscription");
                    }
                } else {
                    requests[i].message.routeToSubscriber = requests[i].subscriptionId;
                    consumer.addMessage(requests[i].message);
                }
                ++i;
            }
        }
        catch (JMSException e) {
            this.asynchFailure(e.getMessage(), e.getLinkedException());
        }
    }

    public void asynchFailure(String reason, Exception e) {
        if (this.closing) {
            return;
        }
        SpyJMSException excep = new SpyJMSException(reason);
        excep.setLinkedException(e);
        ((Throwable)((Object)excep)).fillInStackTrace();
        if (this.exceptionListener != null) {
            ExceptionListener exceptionListener = this.exceptionListener;
            synchronized (exceptionListener) {
                this.exceptionListener.onException((JMSException)excep);
            }
        } else {
            log.warn((Object)"JBossMQ Connection failure: ", (Throwable)((Object)excep));
            ((Throwable)((Object)excep)).printStackTrace();
        }
    }

    public void asynchPong(long serverTime) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PONG, serverIL=" + this.serverIL));
        }
        this.ponged = true;
        this.pingFailed = false;
    }

    SpyMessage[] browse(Queue queue, String selector) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        try {
            return this.serverIL.browse(this.connectionToken, (Destination)queue, selector);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot browse the Queue", e);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public synchronized void close() throws JMSException {
        if (this.closed) {
            return;
        }
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Closing sessions, ClientID=" + this.connectionToken.getClientID()));
        }
        this.closing = true;
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            Object[] vect = ((AbstractCollection)this.createdSessions).toArray();
            int i = 0;
            while (i < vect.length) {
                ((SpySession)vect[i]).close();
                ++i;
            }
        }
        if (trace) {
            log.trace((Object)"Closed sessions");
            log.trace((Object)"Disconnecting from server");
        }
        try {
            try {
                this.serverIL.connectionClosing(this.connectionToken);
            }
            catch (Exception e) {
                throw new SpyJMSException("Cannot close properly the connection", e);
            }
            Object var3_7 = null;
            this.stopPingThread();
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.stopPingThread();
            throw throwable;
        }
        this.stopILService();
        if (trace) {
            log.trace((Object)"Disconnected from server");
        }
        this.closed = true;
    }

    public void deleteTemporaryDestination(SpyDestination dest) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("SpyConnection: deleteDestination(dest=" + dest.toString() + ")"));
        }
        try {
            Cloneable cloneable = this.subscriptions;
            synchronized (cloneable) {
                this.destinationSubscriptions.remove(dest);
            }
            cloneable = this.createdSessions;
            synchronized (cloneable) {
                Iterator i = this.createdSessions.iterator();
                while (i.hasNext()) {
                    ((SpySession)i.next()).deleteTemporaryDestination(dest);
                }
            }
            this.serverIL.deleteTemporaryDestination(this.connectionToken, dest);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot delete the TemporaryDestination", e);
        }
    }

    public String getClientID() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        return this.clientID;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        return this.exceptionListener;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        return new SpyConnectionMetaData();
    }

    String getNewMessageID() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        StringBuffer stringBuffer = this.sb;
        synchronized (stringBuffer) {
            this.sb.setLength(0);
            this.sb.append(this.clientID);
            this.sb.append('-');
            long time = System.currentTimeMillis();
            int count = 0;
            do {
                this.charStack[count] = (char)(48L + time % 10L);
                ++count;
            } while ((time /= 10L) != 0L);
            --count;
            while (count >= 0) {
                this.sb.append(this.charStack[count]);
                --count;
            }
            ++this.lastMessageID;
            if (this.lastMessageID < 0) {
                this.lastMessageID = 0;
            }
            int id = this.lastMessageID;
            count = 0;
            do {
                this.charStack[count] = (char)(48 + id % 10);
                ++count;
            } while ((id /= 10) != 0);
            --count;
            while (count >= 0) {
                this.sb.append(this.charStack[count]);
                --count;
            }
            String string = this.sb.toString();
            Object var3_6 = null;
            return string;
        }
    }

    public ServerIL getServerIL() {
        return this.serverIL;
    }

    void pingServer(long clientTime) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        try {
            log.debug((Object)"PING");
            this.serverIL.ping(this.connectionToken, clientTime);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot ping the JMS server", e);
        }
    }

    SpyMessage receive(Subscription sub, long wait) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        try {
            SpyMessage message = this.serverIL.receive(this.connectionToken, sub.subscriptionId, wait);
            if (message != null) {
                message.routeToSubscriber = sub.subscriptionId;
            }
            return message;
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot create a ConnectionReceiver", e);
        }
    }

    void removeConsumer(SpyConsumer consumer) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        Subscription req = consumer.getSubscription();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Connection: removeSession(dest=" + req.destination + ")"));
        }
        try {
            this.serverIL.unsubscribe(this.connectionToken, req.subscriptionId);
            HashMap hashMap = this.subscriptions;
            synchronized (hashMap) {
                this.subscriptions.remove(new Integer(req.subscriptionId));
                LinkedList ll = (LinkedList)this.destinationSubscriptions.get(req.destination);
                if (ll != null) {
                    boolean removed = ll.remove(consumer);
                    if (ll.size() == 0) {
                        this.destinationSubscriptions.remove(req.destination);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot unsubscribe to this destination", e);
        }
    }

    protected void send(AcknowledgementRequest item) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        try {
            this.serverIL.acknowledge(this.connectionToken, item);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot acknowlege a message", e);
        }
    }

    protected void send(TransactionRequest transaction) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        try {
            this.serverIL.transact(this.connectionToken, transaction);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot process a transaction", e);
        }
    }

    void sendToServer(SpyMessage mes) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        try {
            this.serverIL.addMessage(this.connectionToken, mes);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot send a message to the JMS server", e);
        }
    }

    void sessionClosing(SpySession who) {
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            this.createdSessions.remove(who);
        }
    }

    public void setClientID(String cID) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (this.clientID != null) {
            throw new IllegalStateException("The connection has already a clientID");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("SetClientID(" + this.clientID + ")"));
        }
        try {
            this.serverIL.checkID(cID);
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot connect to the JMSServer", e);
        }
        this.clientID = cID;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.exceptionListener = listener;
    }

    public void start() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (!this.modeStop) {
            return;
        }
        this.modeStop = false;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Starting connection, ClientID=" + this.connectionToken.getClientID()));
        }
        try {
            this.serverIL.setEnabled(this.connectionToken, true);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot enable the connection with the JMS server", e);
        }
    }

    protected void startILService() throws JMSException {
        try {
            this.clientILService = this.genericConnectionFactory.createClientILService(this);
            this.clientILService.start();
            this.connectionToken = new ConnectionToken(this.clientID, this.clientILService.getClientIL());
            this.serverIL.setConnectionToken(this.connectionToken);
        }
        catch (Exception e) {
            log.debug((Object)"Cannot start a the client IL service", (Throwable)e);
            throw new SpyJMSException("Cannot start a the client IL service", e);
        }
    }

    private void startPingThread() {
        if (this.pingPeriod == 0L) {
            return;
        }
        this.pingTaskId = clockDaemon.executePeriodically(this.pingPeriod, (Runnable)new PingTask(), true);
    }

    public void stop() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        if (this.modeStop) {
            return;
        }
        this.modeStop = true;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Stoping connection, ClientID=" + this.connectionToken.getClientID()));
        }
        try {
            this.serverIL.setEnabled(this.connectionToken, false);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot disable the connection with the JMS server", e);
        }
    }

    protected void stopILService() throws JMSException {
        try {
            this.clientILService.stop();
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot stop a the client IL service", e);
        }
    }

    private void stopPingThread() {
        if (this.pingPeriod == 0L) {
            return;
        }
        ClockDaemon.cancel((Object)this.pingTaskId);
        try {
            this.pingTaskSemaphore.attempt(10000L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    void unsubscribe(DurableSubcriptionID id) throws JMSException {
        try {
            this.serverIL.destroySubscription(id);
        }
        catch (Exception e) {
            throw new SpyJMSException("Cannot destroy durable subscription " + id, e);
        }
    }

    class PingTask
    implements Runnable {
        PingTask() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block9: {
                block8: {
                    try {
                        Connection.this.pingTaskSemaphore.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    try {
                        try {
                            if (!Connection.this.ponged) {
                                if (!Connection.this.pingFailed) {
                                    Connection.this.pingFailed = true;
                                    throw new SpyJMSException("", new IOException("ping timeout."));
                                }
                                Object var2_1 = null;
                                break block8;
                            }
                            Connection.this.ponged = false;
                            Connection.this.pingServer(System.currentTimeMillis());
                        }
                        catch (JMSException e) {
                            Connection.this.asynchFailure("Connection Failed", e.getLinkedException());
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        Connection.this.pingTaskSemaphore.release();
                        throw throwable;
                    }
                }
                Connection.this.pingTaskSemaphore.release();
                return;
            }
            Object var2_2 = null;
            Connection.this.pingTaskSemaphore.release();
        }
    }
}

